/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.common.skin;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Random;
import javax.imageio.ImageIO;
import me.swirtzly.regeneration.RegenConfig;
import me.swirtzly.regeneration.Regeneration;
import me.swirtzly.regeneration.util.common.FileUtil;
import me.swirtzly.regeneration.util.common.RegenUtil;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;

@Mod.EventBusSubscriber
public class HandleSkins {
    public static final File SKIN_DIRECTORY = new File((String)RegenConfig.COMMON.skinDir.get() + "/Regeneration Data/skins/");
    public static final File SKIN_DIRECTORY_STEVE = new File(SKIN_DIRECTORY, "/steve");
    public static final File SKIN_DIRECTORY_ALEX = new File(SKIN_DIRECTORY, "/alex");
    public static ArrayList<String> SKINS = new ArrayList();
    public static File TIMELORDS = new File(SKIN_DIRECTORY + "/timelords");

    public static String imageToPixelData(File file) {
        String encodedfile = RegenUtil.NO_SKIN;
        try {
            FileInputStream fileInputStreamReader = new FileInputStream(file);
            byte[] bytes = new byte[(int)file.length()];
            fileInputStreamReader.read(bytes);
            encodedfile = Base64.getMimeEncoder().encodeToString(bytes);
        }
        catch (IOException e) {
            Regeneration.LOG.error("Error creating image for: " + encodedfile);
            e.printStackTrace();
        }
        return encodedfile;
    }

    public static void downloadTimelordSkins() throws IOException {
        if (!TIMELORDS.exists()) {
            TIMELORDS.mkdirs();
        }
        FileUtils.cleanDirectory((File)TIMELORDS);
        Regeneration.LOG.info("Refreshing Skins for Timelords");
        SKINS.clear();
        try {
            String[] uuids;
            for (String uuid : uuids = (String[])Regeneration.GSON.fromJson(FileUtil.getJsonFromURL("https://raw.githubusercontent.com/Swirtzly/Regeneration/skins/donators.json"), String[].class)) {
                SKINS.addAll(HandleSkins.getSkins("https://namemc.com/minecraft-skins/profile/" + uuid));
            }
            SKINS.addAll(HandleSkins.getSkins("https://namemc.com/minecraft-skins"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (String skin : SKINS) {
            String cleanName = skin.replaceAll("https://namemc.com/texture/", "").replaceAll(".png", "");
            File file = new File(TIMELORDS + "/" + cleanName + ".png");
            URL url = new URL(skin);
            URLConnection openConnection = url.openConnection();
            openConnection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
            openConnection.connect();
            BufferedImage img = ImageIO.read(openConnection.getInputStream());
            ImageIO.write((RenderedImage)img, "png", file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String> getSkins(String downloadUrl) throws IOException {
        ArrayList<String> skins = new ArrayList<String>();
        try (BufferedReader br = null;){
            String line;
            URL url = new URL(downloadUrl);
            URLConnection uc = url.openConnection();
            uc.connect();
            uc = url.openConnection();
            uc.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.75 Safari/537.36");
            br = new BufferedReader(new InputStreamReader(uc.getInputStream()));
            while ((line = br.readLine()) != null) {
                if (!line.contains("<a href=\"/skin/")) continue;
                String downloadLine = line.replaceAll("<a href=\"/skin/", "").replaceAll("\">", "").replaceAll("        ", "");
                skins.add("https://namemc.com/texture/" + downloadLine + ".png");
            }
        }
        return skins;
    }

    public static File chooseRandomTimelordSkin(Random rand) {
        Collection folderFiles = FileUtils.listFiles((File)TIMELORDS, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
        if (folderFiles.isEmpty()) {
            folderFiles = FileUtils.listFiles((File)TIMELORDS, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
        }
        return (File)folderFiles.toArray()[rand.nextInt(folderFiles.size())];
    }

    public static File chooseRandomSkin(Random rand, boolean isAlex) {
        File skins = isAlex ? SKIN_DIRECTORY_ALEX : SKIN_DIRECTORY_STEVE;
        Collection folderFiles = FileUtils.listFiles((File)skins, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
        if (folderFiles.isEmpty()) {
            folderFiles = FileUtils.listFiles((File)skins, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
        }
        return (File)folderFiles.toArray()[rand.nextInt(folderFiles.size())];
    }
}

