/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.common.tiles;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.swirtzly.regeneration.client.gui.BioContainerContainer;
import me.swirtzly.regeneration.common.capability.RegenCap;
import me.swirtzly.regeneration.handlers.RegenObjects;
import me.swirtzly.regeneration.util.common.PlayerUtil;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class HandInJarTile
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    public int lindosAmont = 0;
    public LazyOptional<IItemHandler> handler = LazyOptional.of(this::createHandler);

    public HandInJarTile() {
        super((TileEntityType)RegenObjects.Tiles.HAND_JAR.get());
    }

    public int getLindosAmont() {
        return this.lindosAmont;
    }

    public void setLindosAmont(int lindosAmont) {
        this.lindosAmont = lindosAmont;
    }

    public void func_73660_a() {
        PlayerEntity player;
        if (this.field_145850_b.func_82737_E() % 35L == 0L && this.hasHand()) {
            this.field_145850_b.func_184148_a(null, (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (SoundEvent)RegenObjects.Sounds.JAR_BUBBLES.get(), SoundCategory.PLAYERS, 0.4f, 0.3f);
        }
        if ((player = this.field_145850_b.func_217366_a((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), 56.0, false)) != null) {
            RegenCap.get((Entity)player).ifPresent(data -> {
                if (data.getState() == PlayerUtil.RegenState.REGENERATING && this.field_145850_b.field_73012_v.nextInt(90) < 10) {
                    ++this.lindosAmont;
                }
            });
        }
    }

    public boolean hasHand() {
        return (Boolean)this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(data -> data.getStackInSlot(0).func_77973_b() == RegenObjects.Items.HAND.get()).orElse((Object)false);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 3, this.func_189517_E_());
    }

    public void handleUpdateTag(CompoundNBT tag) {
        super.handleUpdateTag(tag);
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public void sendUpdates() {
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        this.func_70296_d();
    }

    public void func_145839_a(CompoundNBT tag) {
        CompoundNBT invTag = tag.func_74775_l("inv");
        this.handler.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((INBT)invTag));
        this.lindosAmont = tag.func_74762_e("lindos");
        super.func_145839_a(tag);
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        this.handler.ifPresent(h -> {
            CompoundNBT compound = (CompoundNBT)((INBTSerializable)h).serializeNBT();
            tag.func_218657_a("inv", (INBT)compound);
        });
        tag.func_74768_a("lindos", this.lindosAmont);
        tag.func_74757_a("hasHand", this.hasHand());
        return super.func_189515_b(tag);
    }

    private IItemHandler createHandler() {
        return new ItemStackHandler(1){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return stack.func_77973_b() == RegenObjects.Items.HAND.get();
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (stack.func_77973_b() != RegenObjects.Items.HAND.get()) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    public LazyOptional<IItemHandler> getInventory() {
        return this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(((Block)RegenObjects.Blocks.HAND_JAR.get()).func_149739_a(), new Object[0]);
    }

    @Nullable
    public Container createMenu(int slot, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new BioContainerContainer(slot, playerInventory, playerEntity, this);
    }

    public ItemStack getHand() {
        return (ItemStack)this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(data -> data.getStackInSlot(0)).orElse((Object)ItemStack.field_190927_a);
    }

    public void destroyHand() {
        this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(data -> data.getStackInSlot(0).func_190920_e(0));
    }
}

