/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.common.traits;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import me.swirtzly.regeneration.common.capability.IRegen;
import me.swirtzly.regeneration.common.capability.RegenCap;
import me.swirtzly.regeneration.common.traits.negative.HungerTrait;
import me.swirtzly.regeneration.common.traits.negative.HydrophobicTrait;
import me.swirtzly.regeneration.common.traits.positive.AthleteTrait;
import me.swirtzly.regeneration.common.traits.positive.BaseTrait;
import me.swirtzly.regeneration.common.traits.positive.BreathingTrait;
import me.swirtzly.regeneration.common.traits.positive.FireResistantTrait;
import me.swirtzly.regeneration.common.traits.positive.NightVisionTrait;
import me.swirtzly.regeneration.common.traits.positive.ToughTrait;
import me.swirtzly.regeneration.common.traits.positive.WallClimbingTrait;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="regeneration", bus=Mod.EventBusSubscriber.Bus.MOD)
public class TraitManager {
    public static IDna DNA_ATHLETE = new AthleteTrait();
    public static IDna DNA_BORING = new BaseTrait("boring");
    public static IDna DNA_DUMB = new BaseTrait("dumb");
    private static final ArrayList<IDna> DNA_LIST = new ArrayList();
    public static IDna DNA_TOUGH = new ToughTrait();
    public static IDna DNA_SWIMMER = new BreathingTrait();
    public static IDna DNA_SCARED_OF_WATER = new HydrophobicTrait();
    public static IDna DNA_FIRE_RESISTANT = new FireResistantTrait();
    public static IDna DNA_HUNGER = new HungerTrait();
    public static IDna DNA_WALLCLIMB = new WallClimbingTrait();
    public static IDna DNA_NIGHTVISION = new NightVisionTrait();
    public static IDna DNA_REPEL_ARROW = new BaseTrait("repel_arrow");
    public static HashMap<ResourceLocation, IDna> DNA_ENTRIES = new HashMap();

    public static void init() {
        TraitManager.register(DNA_ATHLETE);
        TraitManager.register(DNA_BORING);
        TraitManager.register(DNA_DUMB);
        TraitManager.register(DNA_TOUGH);
        TraitManager.register(DNA_SWIMMER);
        TraitManager.register(DNA_SCARED_OF_WATER);
        TraitManager.register(DNA_FIRE_RESISTANT);
        TraitManager.register(DNA_HUNGER);
        TraitManager.register(DNA_NIGHTVISION);
        TraitManager.register(DNA_WALLCLIMB);
        TraitManager.register(DNA_REPEL_ARROW);
    }

    public static void register(IDna dna) {
        DNA_ENTRIES.put(dna.getRegistryName(), dna);
        DNA_LIST.add(dna);
    }

    public static IDna getDnaEntry(ResourceLocation resourceLocation) {
        if (DNA_ENTRIES.containsKey(resourceLocation)) {
            return DNA_ENTRIES.get(resourceLocation);
        }
        return DNA_BORING;
    }

    public static IDna getRandomDna(Random random) {
        return DNA_LIST.get(random.nextInt(DNA_LIST.size()));
    }

    @SubscribeEvent
    public static void onXpPickup(PlayerPickupXpEvent e) {
        RegenCap.get((Entity)e.getEntityPlayer()).ifPresent(data -> {
            IDna dna = TraitManager.getDnaEntry(data.getTrait());
            if (dna.getRegistryName().equals((Object)DNA_DUMB.getRegistryName()) && data.isDnaActive()) {
                e.getOrb().field_70530_e = (int)((double)e.getOrb().field_70530_e * 0.5);
            }
        });
    }

    @SubscribeEvent
    public static void onJump(LivingEvent.LivingJumpEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            RegenCap.get((Entity)player).ifPresent(data -> {
                if (player.field_70170_p.field_72995_K) {
                    return;
                }
                if (data.isDnaActive() && data.getTrait().equals((Object)DNA_ATHLETE.getRegistryName())) {
                    player.func_213322_ci().func_72441_c(0.0, 0.1, 0.0);
                    player.field_70133_I = true;
                }
            });
        }
    }

    @SubscribeEvent
    public static void onArrow(LivingAttackEvent event) {
        DamageSource source = event.getSource();
        Entity attacked = event.getEntity();
        if (source != null && attacked != null && source.func_76364_f() != null && attacked instanceof PlayerEntity && source.func_76364_f() instanceof AbstractArrowEntity && !attacked.field_70170_p.field_72995_K) {
            PlayerEntity player = (PlayerEntity)attacked;
            boolean flag = ((IRegen)RegenCap.get((Entity)player).orElse(null)).getTrait().toString().equals(DNA_REPEL_ARROW.getRegistryName().toString());
            event.setCanceled(flag);
        }
    }

    public static abstract class IDna {
        private final ResourceLocation resourceLocation;
        public String localName;
        public String localDesc;

        public IDna(String name) {
            this.resourceLocation = new ResourceLocation("regeneration", name);
            this.localName = "trait." + this.resourceLocation.func_110624_b() + "." + name;
            this.localDesc = "trait." + this.resourceLocation.func_110624_b() + "." + name + ".desc";
        }

        public abstract void onUpdate(IRegen var1);

        public abstract void onAdded(IRegen var1);

        public abstract void onRemoved(IRegen var1);

        public String getLangKey() {
            return this.localName;
        }

        public ResourceLocation getRegistryName() {
            return this.resourceLocation;
        }

        public String getLocalDesc() {
            return this.localDesc;
        }

        public void registerAttributeIfAbsent(LivingEntity livingEntity, IAttribute attributes) {
            if (livingEntity.func_110140_aT().func_111151_a(attributes) == null) {
                livingEntity.func_110140_aT().func_111150_b(attributes);
            }
        }
    }
}

