/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.common.types;

import java.util.Iterator;
import me.swirtzly.regeneration.RegenConfig;
import me.swirtzly.regeneration.client.rendering.types.FieryRenderer;
import me.swirtzly.regeneration.common.capability.IRegen;
import me.swirtzly.regeneration.common.types.RegenType;
import me.swirtzly.regeneration.handlers.RegenObjects;
import me.swirtzly.regeneration.util.common.PlayerUtil;
import me.swirtzly.regeneration.util.common.RegenUtil;
import net.minecraft.block.FireBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;

public class FieryType
implements RegenType<FieryRenderer> {
    private SoundEvent[] SOUNDS = new SoundEvent[]{(SoundEvent)RegenObjects.Sounds.REGENERATION_0.get(), (SoundEvent)RegenObjects.Sounds.REGENERATION_1.get(), (SoundEvent)RegenObjects.Sounds.REGENERATION_2.get(), (SoundEvent)RegenObjects.Sounds.REGENERATION_3.get(), (SoundEvent)RegenObjects.Sounds.REGENERATION_4.get(), (SoundEvent)RegenObjects.Sounds.REGENERATION_5.get(), (SoundEvent)RegenObjects.Sounds.REGENERATION_6.get(), (SoundEvent)RegenObjects.Sounds.REGENERATION_7.get()};

    @Override
    public void onUpdateMidRegen(IRegen capability) {
        LivingEntity livingEntity = capability.getLivingEntity();
        livingEntity.func_70066_B();
        if (!livingEntity.field_70170_p.field_72995_K && capability.getLivingEntity() instanceof ServerPlayerEntity) {
            PlayerUtil.setPerspective((ServerPlayerEntity)livingEntity, true, false);
        }
        if (livingEntity.field_70170_p.field_72995_K) {
            return;
        }
        if (livingEntity.field_70170_p.func_180495_p(livingEntity.func_180425_c()).func_177230_c() instanceof FireBlock) {
            livingEntity.field_70170_p.func_217377_a(livingEntity.func_180425_c(), false);
        }
        if (!PlayerUtil.isAboveZeroGrid(livingEntity)) {
            RegenUtil.regenerationExplosion(livingEntity);
            double x = livingEntity.field_70165_t + livingEntity.func_70681_au().nextGaussian() * 2.0;
            double y = livingEntity.field_70163_u + 0.5 + livingEntity.func_70681_au().nextGaussian() * 2.0;
            double z = livingEntity.field_70161_v + livingEntity.func_70681_au().nextGaussian() * 2.0;
            livingEntity.field_70170_p.func_217398_a((Entity)livingEntity, x, y, z, 0.1f, ((Boolean)RegenConfig.COMMON.fieryRegen.get()).booleanValue(), Explosion.Mode.NONE);
            Iterator iterator = BlockPos.func_218281_b((BlockPos)livingEntity.func_180425_c().func_177978_c().func_177976_e(), (BlockPos)livingEntity.func_180425_c().func_177968_d().func_177974_f()).iterator();
            while (iterator.hasNext()) {
                iterator.forEachRemaining(blockPos -> {
                    if (livingEntity.field_70170_p.func_180495_p(blockPos).func_177230_c() instanceof FireBlock) {
                        livingEntity.field_70170_p.func_217377_a(blockPos, false);
                    }
                });
            }
        }
    }

    @Override
    public void onFinishRegeneration(IRegen capability) {
        if (capability.getLivingEntity() instanceof ServerPlayerEntity) {
            PlayerUtil.setPerspective((ServerPlayerEntity)capability.getLivingEntity(), false, true);
        }
        capability.setAnimationTicks(0);
    }

    @Override
    public int getAnimationLength() {
        return 280;
    }

    @Override
    public double getAnimationProgress(IRegen cap) {
        return Math.min(1.0, (double)cap.getAnimationTicks() / (double)this.getAnimationLength());
    }

    @Override
    public SoundEvent[] getRegeneratingSounds() {
        return this.SOUNDS;
    }

    @Override
    public Vec3d getDefaultPrimaryColor() {
        return new Vec3d((double)0.93f, (double)0.61f, 0.0);
    }

    @Override
    public Vec3d getDefaultSecondaryColor() {
        return new Vec3d(1.0, 0.5, (double)0.18f);
    }

    @Override
    public ResourceLocation getRegistryName() {
        return new ResourceLocation("regeneration", "fiery");
    }

    @Override
    public FieryRenderer getRenderer() {
        return FieryRenderer.INSTANCE;
    }
}

