/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.common.types;

import java.util.function.Supplier;
import me.swirtzly.regeneration.common.types.FieryType;
import me.swirtzly.regeneration.common.types.RegenType;
import me.swirtzly.regeneration.common.types.TypeLayFade;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;

@Mod.EventBusSubscriber(modid="regeneration", bus=Mod.EventBusSubscriber.Bus.MOD)
public class RegenTypes
extends ForgeRegistryEntry<RegenTypes> {
    public static final RegenTypes FIERY = new RegenTypes(FieryType::new);
    public static final RegenTypes HARTNELL = new RegenTypes(TypeLayFade::new);
    public static IForgeRegistry<RegenTypes> REGISTRY;
    public static RegenTypes[] TYPES;
    private Supplier<RegenType> supplier;

    public RegenTypes(Supplier<RegenType> supplier) {
        this.supplier = supplier;
        this.setRegistryName(supplier.get().getRegistryName());
    }

    @SubscribeEvent
    public static void onRegisterNewRegistries(RegistryEvent.NewRegistry e) {
        REGISTRY = new RegistryBuilder().setName(new ResourceLocation("regeneration", "regeneration_types")).setType(RegenTypes.class).setIDRange(0, 2048).create();
    }

    public static int getPosition(RegenTypes rrRegenType) {
        for (int i = 0; i < TYPES.length; ++i) {
            if (TYPES[i] != rrRegenType) continue;
            return i;
        }
        return 0;
    }

    @SubscribeEvent
    public static void onRegisterTypes(RegistryEvent.Register<RegenTypes> e) {
        e.getRegistry().registerAll((IForgeRegistryEntry[])new RegenTypes[]{FIERY, HARTNELL});
    }

    public RegenType create() {
        return this.supplier.get();
    }

    static {
        TYPES = new RegenTypes[]{FIERY, HARTNELL};
    }
}

