/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.compat;

import me.swirtzly.regeneration.Regeneration;
import me.swirtzly.regeneration.compat.ArchUpgrade;
import me.swirtzly.regeneration.compat.TardisCompat;
import me.swirtzly.regeneration.handlers.RegenObjects;
import me.swirtzly.regeneration.util.common.PlayerUtil;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.tardis.mod.protocols.Protocol;
import net.tardis.mod.tileentities.ConsoleTile;

public class ArchProtocol
extends Protocol {
    private static final TranslationTextComponent ARCH = new TranslationTextComponent("tardis.protocol.arch", new Object[0]);
    private static AxisAlignedBB BOX = new AxisAlignedBB(-20.0, -20.0, -20.0, 20.0, 20.0, 20.0);

    public static BlockPos getGoodArchPlacement(World world, BlockPos consolePos) {
        BlockPos northPos = consolePos.func_177964_d(2).func_177981_b(2);
        BlockPos southPos = consolePos.func_177970_e(2).func_177981_b(2);
        BlockPos eastPos = consolePos.func_177965_g(2).func_177981_b(2);
        BlockPos westPos = consolePos.func_177985_f(2).func_177981_b(2);
        if (world.func_175623_d(northPos)) {
            return northPos;
        }
        if (world.func_175623_d(southPos)) {
            return southPos;
        }
        if (world.func_175623_d(eastPos)) {
            return eastPos;
        }
        if (world.func_175623_d(westPos)) {
            return westPos;
        }
        return BlockPos.field_177992_a;
    }

    public void call(World world, PlayerEntity player, ConsoleTile consoleTile) {
        if (!world.func_201670_d()) {
            consoleTile.getUpgrade(ArchUpgrade.class).ifPresent(archSubSystem -> {
                if (archSubSystem.isUsable()) {
                    BlockPos pos = consoleTile.func_174877_v();
                    BlockPos placePos = pos.func_177964_d(2).func_177981_b(2);
                    if (world.func_175623_d(placePos)) {
                        world.func_175656_a(placePos, ((Block)RegenObjects.Blocks.ARCH.get()).func_176223_P());
                        if (consoleTile.getArtron() > 10.0f) {
                            consoleTile.setArtron(consoleTile.getArtron() - 10.0f);
                        }
                        for (PlayerEntity playerEntity : world.func_217357_a(PlayerEntity.class, BOX.func_186670_a(consoleTile.func_174877_v()))) {
                            PlayerUtil.sendMessage((LivingEntity)playerEntity, "message.regeneration.arch_placed", true);
                        }
                    } else {
                        world.func_175656_a(placePos, Blocks.field_150350_a.func_176223_P());
                        TardisCompat.damageSubsystem(world);
                        for (PlayerEntity playerEntity : world.func_217357_a(PlayerEntity.class, BOX.func_186670_a(consoleTile.func_174877_v()))) {
                            PlayerUtil.sendMessage((LivingEntity)playerEntity, "message.regeneration.arch_removed", true);
                        }
                    }
                } else {
                    for (PlayerEntity playerEntity : world.func_217357_a(PlayerEntity.class, BOX.func_186670_a(consoleTile.func_174877_v()))) {
                        PlayerUtil.sendMessage((LivingEntity)playerEntity, new TranslationTextComponent("message.regeneration.arch_system_dead", new Object[0]), true);
                    }
                }
            });
        } else {
            Regeneration.proxy.closeGui();
        }
    }

    public String getSubmenu() {
        return "interior";
    }

    public String getDisplayName() {
        return ARCH.func_150261_e();
    }
}

