/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.compat;

import me.swirtzly.regeneration.Regeneration;
import me.swirtzly.regeneration.api.ZeroRoomEvent;
import me.swirtzly.regeneration.common.capability.RegenCap;
import me.swirtzly.regeneration.common.entity.TimelordEntity;
import me.swirtzly.regeneration.common.types.RegenTypes;
import me.swirtzly.regeneration.compat.ArchProtocol;
import me.swirtzly.regeneration.compat.ArchUpgrade;
import me.swirtzly.regeneration.handlers.RegenObjects;
import me.swirtzly.regeneration.util.common.PlayerUtil;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.tardis.mod.ars.ARSPiece;
import net.tardis.mod.ars.ARSPieces;
import net.tardis.mod.dimensions.TardisDimension;
import net.tardis.mod.entity.DalekEntity;
import net.tardis.mod.enums.EnumDoorState;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.items.TItems;
import net.tardis.mod.recipe.WeldRecipe;
import net.tardis.mod.registries.TardisRegistries;
import net.tardis.mod.subsystem.Subsystem;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.upgrades.Upgrade;
import net.tardis.mod.upgrades.UpgradeEntry;

public class TardisCompat {
    public static void addTardisCompat() {
        Regeneration.LOG.info("Loading Tardis Compatibility");
        TardisRegistries.registerRegisters(TardisCompat::registerAllProtocols);
        TardisRegistries.registerRegisters(TardisCompat::registerAllUpgrades);
        WeldRecipe.WELD_RECIPE.add(new WeldRecipe((Item)RegenObjects.Items.ARCH_PART.get(), false, new Item[]{(Item)RegenObjects.Items.HAND.get(), TItems.CIRCUITS}));
        WeldRecipe.WELD_RECIPE.add(new WeldRecipe((Item)RegenObjects.Items.ARCH_PART.get(), true, new Item[]{(Item)RegenObjects.Items.ARCH_PART.get(), TItems.CIRCUITS, (Item)RegenObjects.Items.HAND.get()}));
        TardisRegistries.registerRegisters(TardisCompat::registerAllRooms);
        MinecraftForge.EVENT_BUS.register((Object)new TardisCompat());
    }

    public static void registerAllUpgrades() {
        TardisRegistries.UPGRADES.register(new ResourceLocation("regeneration", "arch"), (Object)new UpgradeEntry(ArchUpgrade::new, (Item)RegenObjects.Items.ARCH_PART.get(), null));
    }

    public static void registerAllProtocols() {
        TardisRegistries.PROTOCOL_REGISTRY.register(new ResourceLocation("regeneration", "arch_protocol"), (Object)new ArchProtocol());
    }

    public static void registerAllRooms() {
        ARSPieces.register((String)"zero_room", (ARSPiece)new ARSPiece(new ResourceLocation("regeneration", "regeneration/structures/ars/zero_room"), new BlockPos(9, 5, 19)));
    }

    public static void damageSubsystem(World world) {
        TardisCompat.getTardis(world).getUpgrade(ArchUpgrade.class).ifPresent(archUpgrade -> archUpgrade.damage(1, Upgrade.DamageType.ITEM, null));
    }

    private static ConsoleTile getTardis(World world) {
        return (ConsoleTile)world.func_175625_s(TardisHelper.TARDIS_POS);
    }

    @SubscribeEvent
    public void onJoin(EntityJoinWorldEvent entityJoinWorldEvent) {
        if (entityJoinWorldEvent.getEntity() instanceof TimelordEntity) {
            TimelordEntity timelordEntity = (TimelordEntity)entityJoinWorldEvent.getEntity();
            timelordEntity.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)timelordEntity, DalekEntity.class, false));
        }
    }

    @SubscribeEvent
    public void onZeroRoom(ZeroRoomEvent event) {
        World world = event.getEntityLiving().field_70170_p;
        TardisHelper.getConsoleInWorld((World)world).ifPresent(consoleTile -> {
            if (consoleTile.getArtron() < 5.0f) {
                event.setCanceled(true);
            }
        });
    }

    @SubscribeEvent
    public void onServerChat(ServerChatEvent event) {
        ServerPlayerEntity player = event.getPlayer();
        RegenCap.get((Entity)player).ifPresent(data -> {
            if (data.getState() == PlayerUtil.RegenState.POST) {
                World world = player.field_70170_p;
                if (world.field_73011_w instanceof TardisDimension && PlayerUtil.isZeroRoom((LivingEntity)player)) {
                    TardisHelper.getConsoleInWorld((World)world).ifPresent(consoleTile -> consoleTile.setArtron(consoleTile.getArtron() - 5.0f));
                }
            }
        });
    }

    @SubscribeEvent
    public void onLive(LivingEvent.LivingUpdateEvent event) {
        World world = event.getEntityLiving().field_70170_p;
        if (world.field_72995_K) {
            return;
        }
        if (world.field_73011_w.getDimension() instanceof TardisDimension) {
            ConsoleTile console = this.findConsole(world.field_73011_w.func_186058_p());
            if (console == null) {
                return;
            }
            LivingEntity playerEntity = event.getEntityLiving();
            RegenCap.get((Entity)playerEntity).ifPresent(data -> {
                if (data.getState() == PlayerUtil.RegenState.REGENERATING) {
                    if (data.getRegenType() == RegenTypes.FIERY && playerEntity.field_70173_aa % 10 == 0) {
                        for (Subsystem subSystem : console.getSubSystems()) {
                            subSystem.damage(null, world.field_73012_v.nextInt(5));
                        }
                    }
                    if (console.isInFlight()) {
                        console.getInteriorManager().setAlarmOn(true);
                        console.getInteriorManager().setLight(0);
                        if (console.isInFlight() && data.getRegenType() == RegenTypes.FIERY && world.field_73012_v.nextInt(50) < 10) {
                            console.crash();
                        }
                    } else {
                        console.getDoor().ifPresent(doorEntity -> {
                            if (doorEntity.getOpenState() != EnumDoorState.CLOSED) {
                                BlockPos loc = console.getLocation();
                                ServerWorld currentWorld = ServerLifecycleHooks.getCurrentServer().func_71218_a(console.getDimension());
                                for (int i = 0; i < 5; ++i) {
                                    int xOffset = world.field_73012_v.nextInt(5);
                                    int zOffset = world.field_73012_v.nextInt(5);
                                    currentWorld.func_175656_a(loc.func_177982_a(xOffset, 0, zOffset), Blocks.field_150480_ab.func_176223_P());
                                }
                            }
                        });
                    }
                }
                if (data.getState().isGraceful()) {
                    for (TileEntity tileEntity : playerEntity.field_70170_p.field_147482_g) {
                        if (!(playerEntity.func_70092_e((double)tileEntity.func_174877_v().func_177958_n(), (double)tileEntity.func_174877_v().func_177956_o(), (double)tileEntity.func_174877_v().func_177952_p()) < 40.0) || !(tileEntity instanceof ConsoleTile) || data.getLivingEntity().field_70173_aa % 25 != 0) continue;
                        tileEntity.func_145831_w().func_184133_a(null, tileEntity.func_174877_v(), (SoundEvent)RegenObjects.Sounds.ALARM.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public void onBreed(BabyEntitySpawnEvent entitySpawnEvent) {
        ConsoleTile tardis;
        AgeableEntity kid = entitySpawnEvent.getChild();
        if (kid.func_130014_f_().field_73011_w instanceof TardisDimension && (tardis = TardisCompat.getTardis(kid.func_130014_f_())).isInFlight()) {
            RegenCap.get((Entity)kid).ifPresent(iRegen -> {
                iRegen.receiveRegenerations(kid.field_70170_p.field_73012_v.nextInt(12));
                iRegen.setRegenType(RegenTypes.HARTNELL);
            });
        }
    }

    public ConsoleTile findConsole(DimensionType type) {
        TileEntity te;
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        ServerWorld world = server.func_71218_a(type);
        if (world != null && (te = world.func_175625_s(TardisHelper.TARDIS_POS)) instanceof ConsoleTile) {
            return (ConsoleTile)te;
        }
        return null;
    }
}

