/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.handlers;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import me.swirtzly.regeneration.Regeneration;
import me.swirtzly.regeneration.client.gui.GuiPreferences;
import me.swirtzly.regeneration.client.skinhandling.SkinManipulation;
import me.swirtzly.regeneration.common.capability.IRegen;
import me.swirtzly.regeneration.common.capability.RegenCap;
import me.swirtzly.regeneration.common.dimension.biomes.GallifrayanWastelands;
import me.swirtzly.regeneration.common.types.RegenTypes;
import me.swirtzly.regeneration.compat.ArchHelper;
import me.swirtzly.regeneration.handlers.RegenObjects;
import me.swirtzly.regeneration.util.client.ClientUtil;
import me.swirtzly.regeneration.util.client.RenderUtil;
import me.swirtzly.regeneration.util.common.PlayerUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effects;
import net.minecraft.util.HandSide;
import net.minecraft.util.MovementInput;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ClientHandler {
    private static final ResourceLocation BUTTON_TEX = new ResourceLocation("regeneration", "textures/gui/gui_button_customize.png");

    public static String getColoredText(String msg) {
        return msg.replaceAll("&", String.valueOf('\u00a7'));
    }

    @SubscribeEvent
    public void onGui(GuiScreenEvent.InitGuiEvent event) {
        if (event.getGui() instanceof InventoryScreen) {
            RegenCap.get((Entity)Minecraft.func_71410_x().field_71439_g).ifPresent(data -> {
                if (data.canRegenerate()) {
                    event.addWidget((Widget)new ImageButton(((InventoryScreen)event.getGui()).getGuiLeft() + 134, event.getGui().height / 2 - 22, 20, 20, 0, 0, 20, BUTTON_TEX, 32, 64, p_213088_1_ -> Minecraft.func_71410_x().func_147108_a((Screen)new GuiPreferences()), I18n.func_135052_a((String)"Regeneration", (Object[])new Object[0])));
                }
            });
        }
    }

    @SubscribeEvent
    public void onTickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.START)) {
            return;
        }
        if (Minecraft.func_71410_x().field_71441_e == null && SkinManipulation.PLAYER_SKINS.size() > 0) {
            SkinManipulation.PLAYER_SKINS.forEach((uuid, skinInfo) -> Minecraft.func_71410_x().func_110434_K().func_147645_c(skinInfo.getTextureLocation()));
            SkinManipulation.PLAYER_SKINS.clear();
            Regeneration.LOG.warn("CLEARED CACHE OF PLAYER_SKINS");
        }
    }

    @SubscribeEvent
    public void onClientUpdate(LivingEvent.LivingUpdateEvent e) {
        if (!(e.getEntity() instanceof PlayerEntity) || Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        PlayerEntity player = (PlayerEntity)e.getEntity();
        Minecraft.func_71410_x().func_222817_e(() -> {
            if (player.field_70173_aa == 50) {
                UUID clientUUID = Minecraft.func_71410_x().field_71439_g.func_110124_au();
                RegenCap.get((Entity)player).ifPresent(data -> {
                    if (data.areHandsGlowing()) {
                        ClientUtil.playSound(data.getLivingEntity(), ((SoundEvent)RegenObjects.Sounds.HAND_GLOW.get()).getRegistryName(), SoundCategory.PLAYERS, true, () -> !data.areHandsGlowing(), 0.5f);
                    }
                    if (data.getState() == PlayerUtil.RegenState.REGENERATING) {
                        ClientUtil.playSound(data.getLivingEntity(), ((SoundEvent)RegenObjects.Sounds.REGENERATION_0.get()).getRegistryName(), SoundCategory.PLAYERS, true, () -> !data.getState().equals((Object)PlayerUtil.RegenState.REGENERATING), 1.0f);
                    }
                    if (data.getState().isGraceful() && clientUUID == player.func_110124_au()) {
                        ClientUtil.playSound(data.getLivingEntity(), ((SoundEvent)RegenObjects.Sounds.CRITICAL_STAGE.get()).getRegistryName(), SoundCategory.PLAYERS, true, () -> !data.getState().equals((Object)PlayerUtil.RegenState.GRACE_CRIT), 1.0f);
                        ClientUtil.playSound(data.getLivingEntity(), ((SoundEvent)RegenObjects.Sounds.HEART_BEAT.get()).getRegistryName(), SoundCategory.PLAYERS, true, () -> !data.getState().isGraceful(), 0.2f);
                        ClientUtil.playSound(data.getLivingEntity(), ((SoundEvent)RegenObjects.Sounds.GRACE_HUM.get()).getRegistryName(), SoundCategory.AMBIENT, true, () -> data.getState() != PlayerUtil.RegenState.GRACE, 1.5f);
                    }
                });
            }
        });
    }

    @SubscribeEvent
    public void onRenderGui(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        RegenCap.get((Entity)player).ifPresent(cap -> {
            String warning = null;
            switch (cap.getState()) {
                case GRACE: {
                    RenderUtil.renderVignette(cap.getPrimaryColor(), 0.3f, cap.getState());
                    warning = new TranslationTextComponent("regeneration.messages.warning.grace", new Object[]{new TranslationTextComponent(ClientUtil.keyBind, new Object[0])}).func_150261_e();
                    break;
                }
                case GRACE_CRIT: {
                    RenderUtil.renderVignette(new Vec3d(1.0, 0.0, 0.0), 0.5f, cap.getState());
                    warning = new TranslationTextComponent("regeneration.messages.warning.grace_critical", new Object[]{ClientUtil.keyBind}).func_150261_e();
                    break;
                }
                case REGENERATING: {
                    RenderUtil.renderVignette(cap.getSecondaryColor(), 0.5f, cap.getState());
                    break;
                }
                case POST: {
                    if (player.field_70737_aN <= 0 && player.func_70660_b(Effects.field_76431_k) == null) break;
                    RenderUtil.renderVignette(cap.getSecondaryColor(), 0.5f, cap.getState());
                }
            }
            if (warning != null) {
                Minecraft.func_71410_x().field_71466_p.func_211126_b(warning, (float)(Minecraft.func_71410_x().field_195558_d.func_198107_o() / 2 - Minecraft.func_71410_x().field_71466_p.func_78256_a(warning) / 2), 4.0f, -1);
            }
        });
    }

    @SubscribeEvent
    public void onColorFog(EntityViewRenderEvent.FogColors e) {
        RegenCap.get(Minecraft.func_71410_x().func_175606_aa()).ifPresent(data -> {
            if (data.getRegenType() == RegenTypes.HARTNELL && data.getState() == PlayerUtil.RegenState.REGENERATING) {
                e.setRed((float)data.getPrimaryColor().field_72450_a);
                e.setGreen((float)data.getPrimaryColor().field_72448_b);
                e.setBlue((float)data.getPrimaryColor().field_72449_c);
            }
        });
    }

    @SubscribeEvent
    public void onSetupFogDensity(EntityViewRenderEvent.FogDensity event) {
        Entity viewer = Minecraft.func_71410_x().func_175606_aa();
        if (viewer != null) {
            RegenCap.get(viewer).ifPresent(data -> {
                if (data.getState() == PlayerUtil.RegenState.GRACE_CRIT) {
                    event.setCanceled(true);
                    float amount = MathHelper.func_76134_b((float)((float)data.getLivingEntity().field_70173_aa * 0.06f)) * -0.09f;
                    event.setDensity(amount);
                }
                if (data.getRegenType() == RegenTypes.HARTNELL && data.getAnimationTicks() > 0) {
                    event.setCanceled(true);
                    float opacity = MathHelper.func_76131_a((float)(MathHelper.func_76126_a((float)(((float)viewer.field_70173_aa + Minecraft.func_71410_x().func_184121_ak()) / 10.0f)) * 0.1f + 0.1f), (float)0.11f, (float)1.0f);
                    event.setDensity(opacity);
                }
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onClientChatRecieved(ClientChatReceivedEvent e) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (e.getType() != ChatType.CHAT || PlayerUtil.isZeroRoom((LivingEntity)player)) {
            return;
        }
        IRegen data = (IRegen)RegenCap.get((Entity)player).orElse(null);
        if (data.getState() != PlayerUtil.RegenState.POST) {
            return;
        }
        if (player.field_70170_p.field_73012_v.nextBoolean()) {
            String[] words;
            String message = e.getMessage().func_150261_e();
            StringTextComponent newMessage = new StringTextComponent("");
            for (String word : words = message.split(" ")) {
                StringTextComponent txtComp;
                if (word.equals(words[0])) {
                    StringTextComponent name = new StringTextComponent(word + " ");
                    newMessage.func_150257_a((ITextComponent)name);
                    continue;
                }
                if (player.field_70170_p.field_73012_v.nextBoolean()) {
                    txtComp = new StringTextComponent(ClientHandler.getColoredText("&k" + word + "&r "));
                    txtComp.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new StringTextComponent(word)));
                    newMessage.func_150257_a((ITextComponent)txtComp);
                    continue;
                }
                txtComp = new StringTextComponent(word + " ");
                newMessage.func_150257_a((ITextComponent)txtComp);
            }
            e.setMessage((ITextComponent)newMessage);
        }
    }

    @SubscribeEvent
    public void keyInput(InputUpdateEvent e) {
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        RegenCap.get((Entity)Minecraft.func_71410_x().field_71439_g).ifPresent(data -> {
            if (data.getState() == PlayerUtil.RegenState.REGENERATING || data.isSyncingToJar()) {
                MovementInput moveType = e.getMovementInput();
                moveType.field_187258_f = false;
                moveType.field_187257_e = false;
                moveType.field_187256_d = false;
                moveType.field_78901_c = false;
                moveType.field_192832_b = 0.0f;
                moveType.field_78899_d = false;
                moveType.field_78902_a = 0.0f;
            }
        });
    }

    @SubscribeEvent
    public void onDeath(LivingDeathEvent e) {
        if (e.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)e.getEntityLiving();
            SkinManipulation.PLAYER_SKINS.remove(player.func_110124_au());
            if (player.func_110124_au().equals(Minecraft.func_71410_x().field_71439_g.func_110124_au())) {
                ClientUtil.sendSkinResetPacket();
            }
        }
    }

    @SubscribeEvent
    public void onRenderHand(RenderHandEvent e) {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        float factor = 0.2f;
        if (player.func_184614_ca().func_77973_b() != Items.field_190931_a || mc.field_71474_y.field_74320_O > 0) {
            return;
        }
        RegenCap.get((Entity)player).ifPresent(data -> {
            boolean flag = data.getState() == PlayerUtil.RegenState.REGENERATING;
            e.setCanceled(flag);
            if (!data.areHandsGlowing()) {
                return;
            }
            GlStateManager.pushMatrix();
            float leftHandedFactor = mc.field_71474_y.field_186715_A.equals((Object)HandSide.RIGHT) ? 1.0f : -1.0f;
            GlStateManager.translatef((float)(0.33f * leftHandedFactor), (float)-0.23f, (float)-0.5f);
            GlStateManager.translatef((float)(-0.8f * player.field_70733_aJ * leftHandedFactor), (float)(-0.8f * player.field_70733_aJ), (float)(-0.4f * player.field_70733_aJ));
            GlStateManager.translatef((float)(-(player.field_71154_f - player.field_71163_h) / 400.0f), (float)((player.field_71155_g - player.field_71164_i) / 500.0f), (float)0.0f);
            RenderUtil.setupRenderLightning();
            GlStateManager.rotatef((float)(((float)mc.field_71439_g.field_70173_aa + RenderUtil.renderTick) / 2.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            for (int i = 0; i < 15; ++i) {
                GlStateManager.rotatef((float)(((float)mc.field_71439_g.field_70173_aa + RenderUtil.renderTick) * (float)i / 70.0f), (float)1.0f, (float)1.0f, (float)0.0f);
                Vec3d primaryColor = data.getPrimaryColor();
                Random rand = player.field_70170_p.field_73012_v;
                RenderUtil.drawGlowingLine(new Vec3d((double)(-factor / 2.0f + rand.nextFloat() * factor), (double)(-factor / 2.0f + rand.nextFloat() * factor), (double)(-factor / 2.0f + rand.nextFloat() * factor)), new Vec3d((double)(-factor / 2.0f + rand.nextFloat() * factor), (double)(-factor / 2.0f + rand.nextFloat() * factor), (double)(-factor / 2.0f + rand.nextFloat() * factor)), 0.1f, primaryColor, 0.0f);
            }
            RenderUtil.finishRenderLightning();
            GlStateManager.popMatrix();
        });
    }

    private static void createWorldAmbience(PlayerEntity player) {
        Random random = player.field_70170_p.field_73012_v;
        double originX = player.field_70165_t;
        double originY = player.field_70163_u;
        double originZ = player.field_70161_v;
        for (int i = 0; i < 55; ++i) {
            double particleX = originX + (double)(random.nextInt(24) - random.nextInt(24));
            double particleY = originY + (double)(random.nextInt(24) - random.nextInt(24));
            double particleZ = originZ + (double)(random.nextInt(24) - random.nextInt(24));
            double velocityX = (random.nextDouble() - 0.5) * 0.02;
            double velocityY = (random.nextDouble() - 0.5) * 0.02;
            double velocityZ = (random.nextDouble() - 0.5) * 0.02;
            BasicParticleType[] TYPES = new BasicParticleType[]{ParticleTypes.field_197601_L, ParticleTypes.field_197614_g, ParticleTypes.field_197610_c};
            BasicParticleType currentType = TYPES[player.field_70170_p.field_73012_v.nextInt(TYPES.length - 1)];
            player.field_70170_p.func_195594_a((IParticleData)currentType, particleX, particleY, particleZ, velocityX, velocityY, velocityZ);
            if (player.field_70170_p.field_73012_v.nextInt(30) >= 10 || !player.field_70170_p.field_73012_v.nextBoolean()) continue;
            BlockPos pos = new BlockPos(particleX + (double)random.nextInt(500), particleY + (double)random.nextInt(500), particleZ + (double)random.nextInt(500));
            player.field_70170_p.func_217376_c((Entity)new LightningBoltEntity(player.field_70170_p, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), true));
        }
    }

    @SubscribeEvent
    public void onItemToolTip(ItemTooltipEvent event) {
        List tooltip = event.getToolTip();
        ItemStack stack = event.getItemStack();
        if (ArchHelper.getRegenerations(stack) > 0) {
            tooltip.add(new TranslationTextComponent("nbt.regeneration.item.stored_regens", new Object[]{ArchHelper.getRegenerations(stack)}));
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player.field_70170_p.func_180494_b(player.func_180425_c()) instanceof GallifrayanWastelands) {
            ClientHandler.createWorldAmbience((PlayerEntity)player);
        }
    }
}

