/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.handlers;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.swirtzly.regeneration.RegenConfig;
import me.swirtzly.regeneration.common.capability.IRegen;
import me.swirtzly.regeneration.common.capability.RegenCap;
import me.swirtzly.regeneration.common.entity.TimelordEntity;
import me.swirtzly.regeneration.common.traits.TraitManager;
import me.swirtzly.regeneration.common.types.RegenTypes;
import me.swirtzly.regeneration.compat.ArchHelper;
import me.swirtzly.regeneration.handlers.RegenObjects;
import me.swirtzly.regeneration.util.common.LootUtils;
import me.swirtzly.regeneration.util.common.PlayerUtil;
import me.swirtzly.regeneration.util.common.RegenUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ModDimension;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.RegisterDimensionsEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CommonHandler {
    @SubscribeEvent
    public void registerDim(RegisterDimensionsEvent event) {
        RegenObjects.GALLIFREY_TYPE = DimensionManager.registerOrGetDimension((ResourceLocation)new ResourceLocation("regeneration", "gallifrey"), (ModDimension)((ModDimension)RegenObjects.Dimensions.GALLIFREY.get()), null, (boolean)true);
    }

    @SubscribeEvent
    public void onPlayerUpdate(LivingEvent.LivingUpdateEvent event) {
        RegenCap.get((Entity)event.getEntityLiving()).ifPresent(IRegen::tick);
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        Capability.IStorage storage = RegenCap.CAPABILITY.getStorage();
        event.getOriginal().revive();
        RegenCap.get((Entity)event.getOriginal()).ifPresent(old -> RegenCap.get((Entity)event.getPlayer()).ifPresent(data -> {
            CompoundNBT nbt = (CompoundNBT)storage.writeNBT(RegenCap.CAPABILITY, old, null);
            storage.readNBT(RegenCap.CAPABILITY, data, null, (INBT)nbt);
        }));
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent e) {
        if (e.getName().toString().equalsIgnoreCase("minecraft:chests/")) {
            LootTable lootTable = e.getTable();
            LootUtils.addItemToTable(lootTable, (Item)RegenObjects.Items.ROBES_HEAD.get(), 6, 0.5f, 0, 2, "robes");
            LootUtils.addItemToTable(lootTable, (Item)RegenObjects.Items.DIAL.get(), 4, 0.3f, 0, 1, "seal");
            LootUtils.addItemToTable(lootTable, (Item)RegenObjects.Items.ROBES_CHEST.get(), 6, 0.5f, 0, 2, "hat");
        }
    }

    @SubscribeEvent
    public void onRightClickEntity(PlayerInteractEvent.EntityInteract entityInteract) {
        LivingEntity interactor = entityInteract.getEntityLiving();
        Entity interactedWith = entityInteract.getTarget();
        if (interactedWith instanceof LivingEntity) {
            LivingEntity toBeTimelord = (LivingEntity)interactedWith;
            ItemStack interactorsItem = interactor.func_184614_ca();
            if (!toBeTimelord.field_70170_p.field_72995_K && interactorsItem.func_77973_b() == RegenObjects.Items.ARCH_PART.get() && ArchHelper.getRegenerations(interactorsItem) > 0 && interactor.func_70093_af()) {
                entityInteract.setCanceled(true);
                RegenCap.get((Entity)toBeTimelord).ifPresent(data -> {
                    int amount = ArchHelper.getRegenerations(interactorsItem);
                    ArchHelper.storeRegenerations(interactorsItem, 0);
                    data.receiveRegenerations(amount);
                    data.setRegenType(RegenTypes.HARTNELL);
                    data.synchronise();
                    PlayerUtil.sendMessage(interactor, new TranslationTextComponent("message.regeneration.transferred_regens", new Object[]{interactedWith.func_200200_C_(), amount}), true);
                });
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTracked(PlayerEvent.StartTracking event) {
        RegenCap.get((Entity)event.getPlayer()).ifPresent(IRegen::synchronise);
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        RegenCap.get((Entity)event.getPlayer()).ifPresent(IRegen::synchronise);
    }

    @SubscribeEvent
    public void onDeathEvent(LivingDeathEvent e) {
        if (e.getEntityLiving() instanceof PlayerEntity) {
            RegenCap.get((Entity)e.getEntityLiving()).ifPresent(data -> {
                if (data.getRegenerationsLeft() == 0) {
                    TraitManager.IDna trait = TraitManager.getDnaEntry(data.getTrait());
                    trait.onRemoved((IRegen)data);
                    data.setTrait(TraitManager.DNA_BORING.getRegistryName());
                    TraitManager.DNA_BORING.onAdded((IRegen)data);
                }
                data.synchronise();
            });
        }
    }

    @SubscribeEvent
    public void onPunchBlock(PlayerInteractEvent.LeftClickBlock e) {
        if (e.getPlayer().field_70170_p.field_72995_K) {
            return;
        }
        RegenCap.get((Entity)e.getPlayer()).ifPresent(data -> data.getStateManager().onPunchBlock(e));
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onHurt(LivingHurtEvent event) {
        PlayerEntity player;
        Entity trueSource = event.getSource().func_76346_g();
        if (trueSource instanceof PlayerEntity && event.getEntityLiving() instanceof MobEntity) {
            player = (PlayerEntity)trueSource;
            RegenCap.get((Entity)player).ifPresent(data -> data.getStateManager().onPunchEntity(event));
        }
        if (event.getSource() == RegenObjects.REGEN_DMG_CRITICAL || event.getSource() == RegenObjects.REGEN_DMG_KILLED) {
            return;
        }
        player = event.getEntityLiving();
        RegenCap.get((Entity)player).ifPresent(arg_0 -> CommonHandler.lambda$onHurt$6(event, (LivingEntity)player, arg_0));
    }

    @SubscribeEvent
    public void onKnockback(LivingKnockBackEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        RegenCap.get((Entity)livingEntity).ifPresent(data -> {
            if (data.getState() == PlayerUtil.RegenState.REGENERATING) {
                event.setCanceled(true);
            }
        });
    }

    @SubscribeEvent
    public void attachCapabilities(final AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof LivingEntity) {
            event.addCapability(RegenCap.CAP_REGEN_ID, (ICapabilityProvider)new ICapabilitySerializable<CompoundNBT>(){
                final RegenCap regen;
                final LazyOptional<IRegen> regenInstance;
                {
                    this.regen = new RegenCap((LivingEntity)event.getObject());
                    this.regenInstance = LazyOptional.of(() -> this.regen);
                }

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                    if (cap == RegenCap.CAPABILITY) {
                        return this.regenInstance;
                    }
                    return LazyOptional.empty();
                }

                public CompoundNBT serializeNBT() {
                    return this.regen.serializeNBT();
                }

                public void deserializeNBT(CompoundNBT nbt) {
                    this.regen.deserializeNBT(nbt);
                }
            });
        }
    }

    @SubscribeEvent
    public void fix(LivingSpawnEvent event) {
        LivingEntity living = event.getEntityLiving();
        if (!(living instanceof TimelordEntity)) {
            RegenCap.get((Entity)living).ifPresent(iRegen -> iRegen.setRegenerationsLeft(0));
        }
    }

    @SubscribeEvent
    public void onCut(PlayerInteractEvent.RightClickItem event) {
        if (PlayerUtil.isSharp(event.getItemStack())) {
            PlayerEntity player = event.getPlayer();
            RegenCap.get((Entity)player).ifPresent(data -> {
                if (data.getState() == PlayerUtil.RegenState.POST && !data.hasDroppedHand()) {
                    PlayerUtil.createHand((LivingEntity)player);
                }
            });
        }
    }

    private static /* synthetic */ void lambda$onHurt$6(LivingHurtEvent event, LivingEntity player, IRegen cap) {
        cap.setDeathSource(event.getSource().func_151519_b(player).func_150261_e());
        if (cap.getState() == PlayerUtil.RegenState.POST && player.field_70163_u > 0.0) {
            if (event.getSource() == DamageSource.field_76379_h) {
                PlayerUtil.applyPotionIfAbsent(player, Effects.field_76431_k, 200, 4, false, false);
                if (event.getAmount() > 8.0f) {
                    if (player.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223599_b) && ((Boolean)RegenConfig.COMMON.genCrater.get()).booleanValue()) {
                        RegenUtil.genCrater(player.field_70170_p, player.func_180425_c(), 3);
                    }
                    event.setAmount(0.5f);
                    PlayerUtil.sendMessage(player, new TranslationTextComponent("regeneration.messages.fall_dmg", new Object[0]), true);
                    return;
                }
            } else {
                LivingEntity livingEntity;
                event.setAmount(0.5f);
                PlayerUtil.sendMessage(player, new TranslationTextComponent("regeneration.messages.reduced_dmg", new Object[0]), true);
                if (event.getSource().func_76346_g() instanceof LivingEntity && PlayerUtil.isSharp((livingEntity = (LivingEntity)event.getSource().func_76346_g()).func_184614_ca()) && !cap.hasDroppedHand() && cap.getState() == PlayerUtil.RegenState.POST) {
                    PlayerUtil.createHand(player);
                }
            }
            return;
        }
        if (cap.getLivingEntity() instanceof TimelordEntity && event.getSource() == DamageSource.field_76379_h) {
            return;
        }
        if (cap.getState() == PlayerUtil.RegenState.REGENERATING && ((Boolean)RegenConfig.COMMON.regenFireImmune.get()).booleanValue() && event.getSource().func_76347_k() || cap.getState() == PlayerUtil.RegenState.REGENERATING && event.getSource().func_94541_c()) {
            event.setCanceled(true);
        } else if (player.func_110143_aJ() + player.func_110139_bj() - event.getAmount() <= 0.0f) {
            boolean notDead = cap.getStateManager().onKilled(event.getSource());
            event.setCanceled(notDead);
        }
    }
}

