/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.handlers;

import java.util.Collection;
import java.util.function.Supplier;
import me.swirtzly.regeneration.Regeneration;
import me.swirtzly.regeneration.client.gui.BioContainerContainer;
import me.swirtzly.regeneration.common.block.ArchBlock;
import me.swirtzly.regeneration.common.block.BlockHandInJar;
import me.swirtzly.regeneration.common.block.ZeroRoomBlock;
import me.swirtzly.regeneration.common.dimension.DimSingle;
import me.swirtzly.regeneration.common.dimension.GallifreyChunkGenerator;
import me.swirtzly.regeneration.common.dimension.GallifreyDimension;
import me.swirtzly.regeneration.common.dimension.biomes.GallifrayanWastelands;
import me.swirtzly.regeneration.common.dimension.biomes.GallifreyanGoldenFields;
import me.swirtzly.regeneration.common.dimension.biomes.GallifreyanMountainsBiome;
import me.swirtzly.regeneration.common.dimension.biomes.GallifreyanOcean;
import me.swirtzly.regeneration.common.dimension.biomes.GallifreyanRedLands;
import me.swirtzly.regeneration.common.dimension.biomes.GallifreyanRedlandsForest;
import me.swirtzly.regeneration.common.dimension.biomes.GallifreyanRiver;
import me.swirtzly.regeneration.common.dimension.biomes.GallifreyanSnowFields;
import me.swirtzly.regeneration.common.dimension.biomes.GallifreyanWastelandsMountains;
import me.swirtzly.regeneration.common.dimension.features.FeatureSpikeyBoys;
import me.swirtzly.regeneration.common.dimension.features.GallifreyanHuts;
import me.swirtzly.regeneration.common.dimension.features.GallifreyanTreeFeature;
import me.swirtzly.regeneration.common.dimension.features.SkullFeature;
import me.swirtzly.regeneration.common.entity.LaserEntity;
import me.swirtzly.regeneration.common.entity.OverrideEntity;
import me.swirtzly.regeneration.common.entity.TimelordEntity;
import me.swirtzly.regeneration.common.item.ClothingItem;
import me.swirtzly.regeneration.common.item.ComponentItem;
import me.swirtzly.regeneration.common.item.ConfessionDialItem;
import me.swirtzly.regeneration.common.item.DyeableClothingItem;
import me.swirtzly.regeneration.common.item.FobWatchItem;
import me.swirtzly.regeneration.common.item.GunItem;
import me.swirtzly.regeneration.common.item.HandItem;
import me.swirtzly.regeneration.common.item.IngotItem;
import me.swirtzly.regeneration.common.item.ItemGroups;
import me.swirtzly.regeneration.common.item.SealItem;
import me.swirtzly.regeneration.common.tiles.ArchTile;
import me.swirtzly.regeneration.common.tiles.HandInJarTile;
import me.swirtzly.regeneration.util.common.ICompatObject;
import me.swirtzly.regeneration.util.common.RegenDamageSource;
import net.minecraft.block.Block;
import net.minecraft.block.OreBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.ChunkGeneratorType;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.IChunkGeneratorFactory;
import net.minecraft.world.gen.OverworldGenSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ModDimension;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.network.IContainerFactory;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="regeneration", bus=Mod.EventBusSubscriber.Bus.MOD)
public class RegenObjects {
    public static DimensionType GALLIFREY_TYPE;
    private static ItemGroup itemGroup;
    public static DamageSource REGEN_DMG_ENERGY_EXPLOSION;
    public static DamageSource REGEN_DMG_HEALING;
    public static DamageSource REGEN_DMG_CRITICAL;
    public static DamageSource REGEN_DMG_KILLED;
    public static DamageSource REGEN_DMG_FORCED;

    private static <T extends Container> ContainerType<T> registerContainer(IContainerFactory<T> fact, String name) {
        ContainerType type = new ContainerType(fact);
        type.setRegistryName(new ResourceLocation("regeneration", name));
        return type;
    }

    private static <T extends Container> ContainerType<T> registerContainerSpecial(IContainerFactory<T> fact, int windowId, PlayerInventory playerInv, PlayerEntity player, PacketBuffer buf, TileEntity te, String name) {
        ContainerType type = new ContainerType(fact);
        type.setRegistryName(new ResourceLocation("regeneration", name));
        return type;
    }

    private static <T extends Entity> EntityType<T> registerNoSpawnerBase(EntityType.IFactory<T> factory, EntityClassification classification, float width, float height, int trackingRange, int updateFreq, boolean sendUpdate, String name) {
        ResourceLocation loc = new ResourceLocation("regeneration", name);
        EntityType.Builder builder = EntityType.Builder.func_220322_a(factory, (EntityClassification)classification);
        builder.setShouldReceiveVelocityUpdates(sendUpdate);
        builder.setTrackingRange(trackingRange);
        builder.setUpdateInterval(updateFreq);
        builder.func_220321_a(width, height);
        return builder.func_206830_a(loc.toString());
    }

    private static <T extends Entity> EntityType<T> registerBase(EntityType.IFactory<T> factory, IClientSpawner<T> client, EntityClassification classification, float width, float height, int trackingRange, int updateFreq, boolean sendUpdate, String name) {
        ResourceLocation loc = new ResourceLocation("regeneration", name);
        EntityType.Builder builder = EntityType.Builder.func_220322_a(factory, (EntityClassification)classification);
        builder.setShouldReceiveVelocityUpdates(sendUpdate);
        builder.setTrackingRange(trackingRange);
        builder.setUpdateInterval(updateFreq);
        builder.func_220321_a(width, height);
        builder.setCustomClientFactory((spawnEntity, world) -> (Entity)client.spawn((World)world));
        return builder.func_206830_a(loc.toString());
    }

    private static <T extends Entity> EntityType<T> registerFireImmuneBase(EntityType.IFactory<T> factory, IClientSpawner<T> client, EntityClassification classification, float width, float height, int trackingRange, int updateFreq, boolean sendUpdate, String name) {
        ResourceLocation loc = new ResourceLocation("regeneration", name);
        EntityType.Builder builder = EntityType.Builder.func_220322_a(factory, (EntityClassification)classification);
        builder.setShouldReceiveVelocityUpdates(sendUpdate);
        builder.setTrackingRange(trackingRange);
        builder.setUpdateInterval(updateFreq);
        builder.func_220320_c();
        builder.func_220321_a(width, height);
        builder.setCustomClientFactory((spawnEntity, world) -> (Entity)client.spawn((World)world));
        EntityType type = builder.func_206830_a(loc.toString());
        return type;
    }

    private static <C extends IFeatureConfig, F extends Feature<C>> F registerFeatures(F value) {
        return value;
    }

    private static Item setUpItem(Item item) {
        return item;
    }

    @SubscribeEvent
    public static void registerFeature(RegistryEvent.Register<Feature<?>> event) {
        event.getRegistry().register(WorldGenEntries.TREES.setRegistryName("regeneration", "trees"));
        event.getRegistry().register(WorldGenEntries.SPIKEYS.setRegistryName("regeneration", "spikeys"));
        event.getRegistry().register(WorldGenEntries.SKULLS.setRegistryName("regeneration", "skulls"));
        event.getRegistry().register(WorldGenEntries.HUT.setRegistryName("regeneration", "huts"));
    }

    private static void genBlockItems(Collection<RegistryObject<Block>> collection) {
        for (RegistryObject<Block> block : collection) {
            if (block.get() instanceof ICompatObject && !ModList.get().isLoaded("tardis")) {
                itemGroup = null;
                continue;
            }
            itemGroup = ItemGroups.REGEN_TAB;
            Blocks.BLOCK_ITEMS.register(((Block)block.get()).getRegistryName().func_110623_a(), () -> RegenObjects.setUpItem((Item)new BlockItem((Block)block.get(), new Item.Properties().func_200916_a(itemGroup))));
        }
    }

    @SubscribeEvent
    public static void regBlockItems(RegistryEvent.Register<Item> e) {
        RegenObjects.genBlockItems(Blocks.BLOCKS.getEntries());
    }

    private static Block setUpBlock(Block block) {
        return block;
    }

    @SubscribeEvent
    public static void addSpawns(FMLLoadCompleteEvent e) {
        ((Biome)GallifreyBiomes.GALLIFREY_MOUNTAINS.get()).func_76747_a(EntityClassification.AMBIENT).add(new Biome.SpawnListEntry((EntityType)EntityEntries.TIMELORD.get(), 5, 1, 1));
        ((Biome)GallifreyBiomes.REDLANDS_FOREST.get()).func_76747_a(EntityClassification.AMBIENT).add(new Biome.SpawnListEntry((EntityType)EntityEntries.TIMELORD.get(), 5, 1, 1));
        ((Biome)GallifreyBiomes.REDLANDS.get()).func_76747_a(EntityClassification.AMBIENT).add(new Biome.SpawnListEntry((EntityType)EntityEntries.TIMELORD.get(), 5, 1, 1));
    }

    private static <T extends TileEntity> TileEntityType<T> registerTiles(Supplier<T> tile, Block ... validBlock) {
        return TileEntityType.Builder.func_223042_a(tile, (Block[])validBlock).func_206865_a(null);
    }

    private static SoundEvent setUpSound(String soundName) {
        return new SoundEvent(new ResourceLocation("regeneration", soundName));
    }

    private static <T extends Entity> EntityType<T> registerFireResistMob(EntityType.IFactory<T> factory, IClientSpawner<T> client, EntityClassification classification, float width, float height, String name, boolean velocity) {
        return RegenObjects.registerFireImmuneBase(factory, client, classification, width, height, 80, 3, velocity, name);
    }

    private static <T extends Entity> EntityType<T> registerStatic(EntityType.IFactory<T> factory, IClientSpawner<T> client, EntityClassification classification, float width, float height, String name) {
        return RegenObjects.registerBase(factory, client, classification, width, height, 64, 40, false, name);
    }

    private static <T extends Entity> EntityType<T> registerMob(EntityType.IFactory<T> factory, IClientSpawner<T> client, EntityClassification classification, float width, float height, String name, boolean velocity) {
        return RegenObjects.registerBase(factory, client, classification, width, height, 80, 3, velocity, name);
    }

    private static <T extends Entity> EntityType<T> registerNonSpawner(EntityType.IFactory<T> factory, EntityClassification classification, float width, float height, boolean velocity, String name) {
        return RegenObjects.registerNoSpawnerBase(factory, classification, width, height, 64, 40, velocity, name);
    }

    private static <C extends GenerationSettings, T extends ChunkGenerator<C>> ChunkGeneratorType<C, T> registerChunkGeneratorType(IChunkGeneratorFactory<C, T> factoryIn, Supplier<C> settingsIn, boolean canUseForBuffet) {
        ChunkGeneratorType type = new ChunkGeneratorType(factoryIn, canUseForBuffet, settingsIn);
        return type;
    }

    private static ModDimension registerDimensions(ModDimension type) {
        return type;
    }

    static {
        itemGroup = ItemGroups.REGEN_TAB;
        REGEN_DMG_ENERGY_EXPLOSION = new RegenDamageSource("regen_energy");
        REGEN_DMG_HEALING = new RegenDamageSource("regen_heal").func_76359_i();
        REGEN_DMG_CRITICAL = new RegenDamageSource("regen_crit").func_76359_i();
        REGEN_DMG_KILLED = new RegenDamageSource("regen_killed");
        REGEN_DMG_FORCED = new RegenDamageSource("forced").func_76359_i();
    }

    public static interface IClientSpawner<T> {
        public T spawn(World var1);
    }

    public static class Items {
        public static final DeferredRegister<Item> ITEMS = new DeferredRegister(ForgeRegistries.ITEMS, "regeneration");
        public static final RegistryObject<Item> FOB_WATCH = ITEMS.register("fob_watch", FobWatchItem::new);
        public static final RegistryObject<Item> HAND = ITEMS.register("hand", HandItem::new);
        public static final RegistryObject<Item> ARCH_PART = ITEMS.register("arch_part", ComponentItem::new);
        public static final RegistryObject<Item> GAL_INGOT = ITEMS.register("gal_ingot", IngotItem::new);
        public static final RegistryObject<Item> SEAL = ITEMS.register("rassilon_seal", SealItem::new);
        public static final RegistryObject<Item> DIAL = ITEMS.register("confession_dial", ConfessionDialItem::new);
        public static final RegistryObject<Item> RIFLE = ITEMS.register("time_lord_rifle", () -> new GunItem(30, 10, 10.0f));
        public static final RegistryObject<Item> PISTOL = ITEMS.register("time_lord_gun", () -> new GunItem(18, 5, 4.0f));
        public static final RegistryObject<Item> ROBES_CHEST = ITEMS.register("robes", () -> new DyeableClothingItem(EquipmentSlotType.CHEST));
        public static final RegistryObject<Item> ROBES_HEAD = ITEMS.register("robes_hat", () -> new DyeableClothingItem(EquipmentSlotType.HEAD));
        public static final RegistryObject<Item> GUARD_HEAD = ITEMS.register("guard_head", () -> new ClothingItem(EquipmentSlotType.HEAD));
        public static final RegistryObject<Item> GUARD_CHEST = ITEMS.register("guard_chest", () -> new ClothingItem(EquipmentSlotType.CHEST));
        public static final RegistryObject<Item> GUARD_LEGGINGS = ITEMS.register("guard_leggings", () -> new ClothingItem(EquipmentSlotType.LEGS));
        public static final RegistryObject<Item> GUARD_FEET = ITEMS.register("guard_feet", () -> new ClothingItem(EquipmentSlotType.FEET));
    }

    public static class WorldGenEntries {
        public static final GallifreyanTreeFeature TREES = new GallifreyanTreeFeature(NoFeatureConfig::func_214639_a);
        public static final FeatureSpikeyBoys SPIKEYS = new FeatureSpikeyBoys(NoFeatureConfig::func_214639_a);
        public static final SkullFeature SKULLS = new SkullFeature(ProbabilityConfig::func_214645_a);
        public static final GallifreyanHuts HUT = new GallifreyanHuts(NoFeatureConfig::func_214639_a);
    }

    public static class Dimensions {
        public static final DeferredRegister<ModDimension> DIMENSIONS = new DeferredRegister(ForgeRegistries.MOD_DIMENSIONS, "regeneration");
        public static final RegistryObject<ModDimension> GALLIFREY = DIMENSIONS.register("gallifrey", () -> RegenObjects.access$600(new DimSingle(GallifreyDimension::new)));
    }

    public static class ChunkGeneratorTypes {
        public static final DeferredRegister<ChunkGeneratorType<?, ?>> CHUNK_GENERATOR_TYPES = new DeferredRegister(ForgeRegistries.CHUNK_GENERATOR_TYPES, "regeneration");
        public static IChunkGeneratorFactory<OverworldGenSettings, GallifreyChunkGenerator> factory = GallifreyChunkGenerator::new;
        public static final RegistryObject<ChunkGeneratorType<OverworldGenSettings, GallifreyChunkGenerator>> GALLIFREY_CHUNKS = CHUNK_GENERATOR_TYPES.register("gallifrey_chunks", () -> RegenObjects.access$500(ChunkGeneratorTypes.factory, OverworldGenSettings::new, false));
    }

    public static class GallifreyBiomes {
        public static final DeferredRegister<Biome> BIOMES = new DeferredRegister(ForgeRegistries.BIOMES, "regeneration");
        public static final RegistryObject<Biome> GALLIFREY_MOUNTAINS = BIOMES.register("gallifreyan_mountains", GallifreyanMountainsBiome::new);
        public static final RegistryObject<Biome> GALLIFREYAN_RIVER = BIOMES.register("gallifreyan_river", GallifreyanRiver::new);
        public static final RegistryObject<Biome> GALLIFREYAN_OCEAN = BIOMES.register("gallifreyan_ocean", GallifreyanOcean::new);
        public static final RegistryObject<Biome> REDLANDS = BIOMES.register("redlands", GallifreyanRedLands::new);
        public static final RegistryObject<Biome> WASTELANDS = BIOMES.register("wastelands", GallifrayanWastelands::new);
        public static final RegistryObject<Biome> REDLANDS_FOREST = BIOMES.register("redlands_forest", GallifreyanRedlandsForest::new);
        public static final RegistryObject<Biome> WASTELANDS_MOUNTAINS = BIOMES.register("wasteland_mountains", GallifreyanWastelandsMountains::new);
        public static final RegistryObject<Biome> GOLDEN_FIELDS = BIOMES.register("golden_fields", GallifreyanGoldenFields::new);
        public static final RegistryObject<Biome> SNOWY = BIOMES.register("snowy", GallifreyanSnowFields::new);

        public static Biome[] getBiomes() {
            return new Biome[]{(Biome)GALLIFREY_MOUNTAINS.get(), (Biome)GALLIFREYAN_RIVER.get(), (Biome)GALLIFREYAN_OCEAN.get(), (Biome)REDLANDS.get(), (Biome)WASTELANDS.get(), (Biome)REDLANDS_FOREST.get(), (Biome)WASTELANDS_MOUNTAINS.get(), (Biome)GOLDEN_FIELDS.get(), (Biome)SNOWY.get()};
        }

        public static void registerBiomeTypes() {
            GallifreyBiomes.addBiomeTypes(GALLIFREY_MOUNTAINS, BiomeDictionary.Type.MOUNTAIN);
            GallifreyBiomes.addBiomeTypes(GALLIFREYAN_RIVER, BiomeDictionary.Type.RIVER);
            GallifreyBiomes.addBiomeTypes(GALLIFREYAN_OCEAN, BiomeDictionary.Type.OCEAN);
            GallifreyBiomes.addBiomeTypes(REDLANDS, BiomeDictionary.Type.PLAINS);
            GallifreyBiomes.addBiomeTypes(WASTELANDS, BiomeDictionary.Type.SANDY);
            GallifreyBiomes.addBiomeTypes(REDLANDS_FOREST, BiomeDictionary.Type.PLAINS);
        }

        public static void addBiomeTypes(RegistryObject<Biome> biome, BiomeDictionary.Type biomeType) {
            BiomeDictionary.addTypes((Biome)((Biome)biome.get()), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{biomeType});
        }
    }

    public static class EntityEntries {
        public static final DeferredRegister<EntityType<?>> ENTITIES = new DeferredRegister(ForgeRegistries.ENTITIES, "regeneration");
        public static RegistryObject<EntityType<OverrideEntity>> ITEM_OVERRIDE_ENTITY_TYPE = ENTITIES.register("item_override", () -> RegenObjects.access$400(OverrideEntity::new, EntityClassification.MISC, 0.5f, 0.2f, 128, 1, true, "item_override"));
        public static RegistryObject<EntityType<TimelordEntity>> TIMELORD = ENTITIES.register("timelord", () -> RegenObjects.access$400(TimelordEntity::new, EntityClassification.AMBIENT, 0.6f, 1.95f, 128, 1, true, "timelord"));
        public static RegistryObject<EntityType<LaserEntity>> LASER = ENTITIES.register("laser", () -> RegenObjects.access$300(LaserEntity::new, LaserEntity::new, EntityClassification.MISC, 0.5f, 0.5f, "laser", true));
    }

    public static class Containers {
        public static final DeferredRegister<ContainerType<?>> CONTAINERS = new DeferredRegister(ForgeRegistries.CONTAINERS, "regeneration");
        public static final RegistryObject<ContainerType<BioContainerContainer>> BIO_CONTAINER = CONTAINERS.register("bio_container", () -> IForgeContainerType.create((windowId, inv, data) -> {
            BlockPos pos = data.func_179259_c();
            return new BioContainerContainer(windowId, inv, Regeneration.proxy.getClientPlayer(), (HandInJarTile)Minecraft.func_71410_x().field_71441_e.func_175625_s(pos));
        }));
    }

    public static class Tiles {
        public static final DeferredRegister<TileEntityType<?>> TILES = new DeferredRegister(ForgeRegistries.TILE_ENTITIES, "regeneration");
        public static final RegistryObject<TileEntityType<HandInJarTile>> HAND_JAR = TILES.register("hand_jar", () -> RegenObjects.access$200(HandInJarTile::new, new Block[]{(Block)Blocks.HAND_JAR.get()}));
        public static final RegistryObject<TileEntityType<ArchTile>> ARCH = TILES.register("arch", () -> RegenObjects.access$200(ArchTile::new, new Block[]{(Block)Blocks.ARCH.get()}));
    }

    public static class Blocks {
        public static final DeferredRegister<Block> BLOCKS = new DeferredRegister(ForgeRegistries.BLOCKS, "regeneration");
        public static final DeferredRegister<Item> BLOCK_ITEMS = new DeferredRegister(ForgeRegistries.ITEMS, "regeneration");
        public static final RegistryObject<Block> HAND_JAR = BLOCKS.register("hand_jar", () -> RegenObjects.access$100((Block)new BlockHandInJar()));
        public static final RegistryObject<Block> ARCH = BLOCKS.register("arch", () -> RegenObjects.access$100((Block)new ArchBlock(Block.Properties.func_200945_a((Material)Material.field_76233_E).func_200948_a(1.25f, 10.0f))));
        public static final RegistryObject<Block> GAL_ORE = BLOCKS.register("gal_ore", () -> RegenObjects.access$100((Block)new OreBlock(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(3.0f, 3.0f))));
        public static final RegistryObject<Block> ZERO_ROOM = BLOCKS.register("zero_roundel_one", () -> RegenObjects.access$100(new ZeroRoomBlock(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(3.0f, 3.0f))));
        public static final RegistryObject<Block> ZERO_ROOM_TWO = BLOCKS.register("zero_roundel_two", () -> RegenObjects.access$100(new ZeroRoomBlock(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(3.0f, 3.0f))));
    }

    public static class Sounds {
        public static final DeferredRegister<SoundEvent> SOUNDS = new DeferredRegister(ForgeRegistries.SOUND_EVENTS, "regeneration");
        public static final RegistryObject<SoundEvent> FOB_WATCH = SOUNDS.register("fob_watch", () -> RegenObjects.access$000("fob_watch"));
        public static final RegistryObject<SoundEvent> FOB_WATCH_DIALOGUE = SOUNDS.register("fob_watch_dialogue", () -> RegenObjects.access$000("fob_watch_dialogue"));
        public static final RegistryObject<SoundEvent> CRITICAL_STAGE = SOUNDS.register("critical_stage", () -> RegenObjects.access$000("critical_stage"));
        public static final RegistryObject<SoundEvent> HEART_BEAT = SOUNDS.register("heart_beat", () -> RegenObjects.access$000("heart_beat"));
        public static final RegistryObject<SoundEvent> HAND_GLOW = SOUNDS.register("hand_glow", () -> RegenObjects.access$000("hand_glow"));
        public static final RegistryObject<SoundEvent> GRACE_HUM = SOUNDS.register("grace_hum", () -> RegenObjects.access$000("grace_hum"));
        public static final RegistryObject<SoundEvent> REGEN_BREATH = SOUNDS.register("regen_breath", () -> RegenObjects.access$000("regen_breath"));
        public static final RegistryObject<SoundEvent> ALARM = SOUNDS.register("alarm", () -> RegenObjects.access$000("alarm"));
        public static final RegistryObject<SoundEvent> JAR_BUBBLES = SOUNDS.register("jar_bubbles", () -> RegenObjects.access$000("jar_bubbles"));
        public static final RegistryObject<SoundEvent> REGENERATION_0 = SOUNDS.register("regeneration_0", () -> RegenObjects.access$000("regeneration_0"));
        public static final RegistryObject<SoundEvent> REGENERATION_1 = SOUNDS.register("regeneration_1", () -> RegenObjects.access$000("regeneration_1"));
        public static final RegistryObject<SoundEvent> REGENERATION_2 = SOUNDS.register("regeneration_2", () -> RegenObjects.access$000("regeneration_2"));
        public static final RegistryObject<SoundEvent> REGENERATION_3 = SOUNDS.register("regeneration_3", () -> RegenObjects.access$000("regeneration_3"));
        public static final RegistryObject<SoundEvent> REGENERATION_4 = SOUNDS.register("regeneration_4", () -> RegenObjects.access$000("regeneration_4"));
        public static final RegistryObject<SoundEvent> REGENERATION_5 = SOUNDS.register("regeneration_5", () -> RegenObjects.access$000("regeneration_5"));
        public static final RegistryObject<SoundEvent> REGENERATION_6 = SOUNDS.register("regeneration_6", () -> RegenObjects.access$000("regeneration_6"));
        public static final RegistryObject<SoundEvent> REGENERATION_7 = SOUNDS.register("regeneration_7", () -> RegenObjects.access$000("regeneration_7"));
        public static final RegistryObject<SoundEvent> STASER = SOUNDS.register("staser", () -> RegenObjects.access$000("staser"));
        public static final RegistryObject<SoundEvent> RIFLE = SOUNDS.register("rifle", () -> RegenObjects.access$000("rifle"));
    }
}

