/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.handlers.acting;

import java.util.ArrayList;
import java.util.List;
import me.swirtzly.regeneration.common.capability.IRegen;
import me.swirtzly.regeneration.handlers.acting.Acting;
import me.swirtzly.regeneration.handlers.acting.ClientActing;
import me.swirtzly.regeneration.handlers.acting.CommonActing;
import me.swirtzly.regeneration.network.NetworkDispatcher;
import me.swirtzly.regeneration.network.messages.UpdateStateMessage;
import net.minecraft.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class ActingForwarder {
    private static List<Acting> SERVER_HANDLERS = new ArrayList<Acting>();
    private static List<Acting> CLIENT_HANDLERS = new ArrayList<Acting>();

    public static void init() {
        ActingForwarder.register(CommonActing.INSTANCE, Dist.DEDICATED_SERVER);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ActingForwarder.register(ClientActing.INSTANCE, Dist.CLIENT);
        }
    }

    public static void register(Class<? extends Acting> handlerClass, Dist side) {
        try {
            ActingForwarder.register(handlerClass.newInstance(), side);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Error while instantiating acting handler", e);
        }
    }

    public static void register(Acting handler, Dist side) {
        (side == Dist.CLIENT ? CLIENT_HANDLERS : SERVER_HANDLERS).add(handler);
    }

    public static void onRegenTick(IRegen cap) {
        if (cap.getLivingEntity().field_70170_p.field_72995_K) {
            throw new IllegalStateException("'Posting' tick `event` from client (this is VERY wrong)");
        }
        for (Acting handler : SERVER_HANDLERS) {
            handler.onRegenTick(cap);
        }
    }

    public static void onEnterGrace(IRegen cap) {
        ActingForwarder.checkAndForward(cap, RegenEvent.ENTER_GRACE);
        for (Acting handler : SERVER_HANDLERS) {
            handler.onEnterGrace(cap);
        }
    }

    public static void onRegenFinish(IRegen cap) {
        ActingForwarder.checkAndForward(cap, RegenEvent.REGEN_FINISH);
        for (Acting handler : SERVER_HANDLERS) {
            handler.onRegenFinish(cap);
        }
    }

    public static void onRegenTrigger(IRegen cap) {
        ActingForwarder.checkAndForward(cap, RegenEvent.REGEN_TRIGGER);
        for (Acting handler : SERVER_HANDLERS) {
            handler.onRegenTrigger(cap);
        }
    }

    public static void onGoCritical(IRegen cap) {
        ActingForwarder.checkAndForward(cap, RegenEvent.CRITICAL_START);
        for (Acting handler : SERVER_HANDLERS) {
            handler.onGoCritical(cap);
        }
    }

    public static void onHandsStartGlowing(IRegen cap) {
        ActingForwarder.checkAndForward(cap, RegenEvent.HAND_GLOW_START);
        for (Acting handler : SERVER_HANDLERS) {
            handler.onHandsStartGlowing(cap);
        }
    }

    public static void onPerformingPost(IRegen cap) {
        ActingForwarder.checkAndForward(cap, RegenEvent.PERFORM_POST);
        for (Acting handler : SERVER_HANDLERS) {
            handler.onPerformingPost(cap);
        }
    }

    public static void onClient(RegenEvent event, IRegen cap) {
        for (Acting handler : CLIENT_HANDLERS) {
            switch (event) {
                case ENTER_GRACE: {
                    handler.onEnterGrace(cap);
                    break;
                }
                case REGEN_FINISH: {
                    handler.onRegenFinish(cap);
                    break;
                }
                case REGEN_TRIGGER: {
                    handler.onRegenTrigger(cap);
                    break;
                }
                case CRITICAL_START: {
                    handler.onGoCritical(cap);
                    break;
                }
                case HAND_GLOW_START: {
                    handler.onHandsStartGlowing(cap);
                    break;
                }
                case PERFORM_POST: {
                    handler.onPerformingPost(cap);
                }
            }
        }
    }

    private static void checkAndForward(IRegen cap, RegenEvent event) {
        if (cap.getLivingEntity().field_70170_p.field_72995_K) {
            throw new IllegalStateException("'Posting' \"acting\" `event` from client");
        }
        NetworkDispatcher.sendPacketToAll(new UpdateStateMessage((Entity)cap.getLivingEntity(), event.name()));
    }

    public static enum RegenEvent {
        ENTER_GRACE,
        REGEN_FINISH,
        REGEN_TRIGGER,
        CRITICAL_START,
        PERFORM_POST,
        HAND_GLOW_START;

    }
}

