/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.handlers.acting;

import me.swirtzly.regeneration.RegenConfig;
import me.swirtzly.regeneration.client.skinhandling.SkinManipulation;
import me.swirtzly.regeneration.common.capability.IRegen;
import me.swirtzly.regeneration.handlers.RegenObjects;
import me.swirtzly.regeneration.handlers.acting.Acting;
import me.swirtzly.regeneration.util.client.ClientUtil;
import me.swirtzly.regeneration.util.common.PlayerUtil;
import me.swirtzly.regeneration.util.common.RegenUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.HandSide;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TranslationTextComponent;

class ClientActing
implements Acting {
    public static final Acting INSTANCE = new ClientActing();

    private ClientActing() {
    }

    @Override
    public void onRegenTick(IRegen cap) {
    }

    @Override
    public void onEnterGrace(IRegen cap) {
        ClientUtil.playSound(cap.getLivingEntity(), ((SoundEvent)RegenObjects.Sounds.HEART_BEAT.get()).getRegistryName(), SoundCategory.PLAYERS, true, () -> !cap.getState().isGraceful(), 0.2f);
        ClientUtil.playSound(cap.getLivingEntity(), ((SoundEvent)RegenObjects.Sounds.GRACE_HUM.get()).getRegistryName(), SoundCategory.AMBIENT, true, () -> cap.getState() != PlayerUtil.RegenState.GRACE, 1.5f);
    }

    @Override
    public void onHandsStartGlowing(IRegen cap) {
        ClientUtil.playSound(cap.getLivingEntity(), ((SoundEvent)RegenObjects.Sounds.HAND_GLOW.get()).getRegistryName(), SoundCategory.PLAYERS, true, () -> !cap.areHandsGlowing(), 1.0f);
    }

    @Override
    public void onRegenFinish(IRegen cap) {
        if (((Boolean)RegenConfig.CLIENT.changeHand.get()).booleanValue() && cap.getLivingEntity().func_110124_au() == Minecraft.func_71410_x().field_71439_g.func_110124_au()) {
            ClientUtil.createToast(new TranslationTextComponent("regeneration.toast.regenerated", new Object[0]), new TranslationTextComponent("regeneration.toast.regenerations_left", new Object[]{cap.getRegenerationsLeft()}));
            Minecraft.func_71410_x().field_71474_y.field_186715_A = RegenUtil.randomEnum(HandSide.class);
            Minecraft.func_71410_x().field_71474_y.func_82879_c();
        }
    }

    @Override
    public void onPerformingPost(IRegen cap) {
    }

    @Override
    public void onRegenTrigger(IRegen cap) {
        if (Minecraft.func_71410_x().field_71439_g.func_110124_au().equals(cap.getLivingEntity().func_110124_au())) {
            SkinManipulation.sendSkinUpdate(cap.getLivingEntity().field_70170_p.field_73012_v, (PlayerEntity)cap.getLivingEntity());
        }
    }

    @Override
    public void onGoCritical(IRegen cap) {
        if (Minecraft.func_71410_x().field_71439_g.func_110124_au().equals(cap.getLivingEntity().func_110124_au())) {
            ClientUtil.createToast(new TranslationTextComponent("regeneration.toast.enter_critical", new Object[0]), new TranslationTextComponent("regeneration.toast.enter_critical.sub", new Object[]{(Integer)RegenConfig.COMMON.criticalPhaseLength.get() / 60}));
            ClientUtil.playSound(cap.getLivingEntity(), ((SoundEvent)RegenObjects.Sounds.CRITICAL_STAGE.get()).getRegistryName(), SoundCategory.PLAYERS, true, () -> cap.getState() != PlayerUtil.RegenState.GRACE_CRIT, 1.0f);
        }
    }
}

