/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.handlers.acting;

import java.util.Random;
import java.util.UUID;
import me.swirtzly.regeneration.RegenConfig;
import me.swirtzly.regeneration.common.advancements.TriggerManager;
import me.swirtzly.regeneration.common.capability.IRegen;
import me.swirtzly.regeneration.common.traits.TraitManager;
import me.swirtzly.regeneration.handlers.RegenObjects;
import me.swirtzly.regeneration.handlers.acting.Acting;
import me.swirtzly.regeneration.network.NetworkDispatcher;
import me.swirtzly.regeneration.network.messages.PlaySFXMessage;
import me.swirtzly.regeneration.util.common.PlayerUtil;
import me.swirtzly.regeneration.util.common.RegenUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TranslationTextComponent;

class CommonActing
implements Acting {
    public static final Acting INSTANCE = new CommonActing();
    private final UUID SLOWNESS_ID = UUID.fromString("f9aa2c36-f3f3-4d76-a148-86d6f2c87782");
    private final UUID MAX_HEALTH_ID = UUID.fromString("5d6f0ba2-1286-46fc-b896-461c5cfd99cc");
    private final double HEART_REDUCTION = 0.5;
    private final double SPEED_REDUCTION = 0.35;
    private final AttributeModifier slownessModifier = new AttributeModifier(this.SLOWNESS_ID, "slow", -0.35, AttributeModifier.Operation.MULTIPLY_BASE);
    private final AttributeModifier heartModifier = new AttributeModifier(this.MAX_HEALTH_ID, "short-heart", -0.5, AttributeModifier.Operation.MULTIPLY_BASE);

    public static SoundEvent getRandomSound(Random random, IRegen cap) {
        SoundEvent[] SOUNDS = cap.getRegenType().create().getRegeneratingSounds();
        return SOUNDS[random.nextInt(SOUNDS.length)];
    }

    @Override
    public void onRegenTick(IRegen cap) {
        LivingEntity player = cap.getLivingEntity();
        float stateProgress = (float)cap.getStateManager().getStateProgress();
        switch (cap.getState()) {
            case POST: {
                if (player.field_70173_aa % 210 != 0) break;
                PlayerUtil.applyPotionIfAbsent(player, PlayerUtil.POTIONS.get(player.field_70170_p.field_73012_v.nextInt(PlayerUtil.POTIONS.size())), player.field_70170_p.field_73012_v.nextInt(400), 1, false, false);
                break;
            }
            case REGENERATING: {
                float dm = Math.max(1.0f, (float)(player.field_70170_p.func_175659_aa().func_151525_a() + 1) / 3.0f);
                player.func_70691_i(stateProgress * 0.3f * dm);
                player.func_85034_r(0);
                break;
            }
            case GRACE_CRIT: {
                float nauseaPercentage = 0.5f;
                if (stateProgress > nauseaPercentage) {
                    PlayerUtil.applyPotionIfAbsent(player, Effects.field_76431_k, (int)((float)((Integer)RegenConfig.COMMON.criticalPhaseLength.get() * 20) * (1.0f - nauseaPercentage) * 1.5f), 0, false, false);
                }
                PlayerUtil.applyPotionIfAbsent(player, Effects.field_76437_t, (int)((float)((Integer)RegenConfig.COMMON.criticalPhaseLength.get() * 20) * (1.0f - stateProgress)), 0, false, false);
                if (!(player.field_70170_p.field_73012_v.nextDouble() < (double)((float)((Integer)RegenConfig.COMMON.criticalDamageChance.get()).intValue() / 100.0f))) break;
                player.func_70097_a(RegenObjects.REGEN_DMG_CRITICAL, player.field_70170_p.field_73012_v.nextFloat() + 0.5f);
                break;
            }
            case GRACE: {
                float weaknessPercentage = 0.5f;
                if (!(stateProgress > weaknessPercentage)) break;
                PlayerUtil.applyPotionIfAbsent(player, Effects.field_76437_t, (int)((float)((Integer)RegenConfig.COMMON.gracePhaseLength.get() * 20) * (1.0f - weaknessPercentage) + (float)((Integer)RegenConfig.COMMON.criticalPhaseLength.get() * 20)), 0, false, false);
                break;
            }
            case ALIVE: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown state " + (Object)((Object)cap.getState()));
            }
        }
    }

    @Override
    public void onEnterGrace(IRegen cap) {
        LivingEntity player = cap.getLivingEntity();
        RegenUtil.explodeKnockback((Entity)player, player.field_70170_p, player.func_180425_c(), (Double)RegenConfig.COMMON.regenerativeKnockback.get() / 2.0, (Integer)RegenConfig.COMMON.regenKnockbackRange.get());
        player.func_110149_m(player.func_110138_aP() * 0.5f);
        if (!player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_180374_a(this.heartModifier)) {
            player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(this.heartModifier);
        }
        TraitManager.IDna dna = TraitManager.getDnaEntry(cap.getTrait());
        dna.onRemoved(cap);
        cap.setDnaActive(false);
        player.func_70606_j(player.func_110138_aP());
    }

    @Override
    public void onHandsStartGlowing(IRegen cap) {
        PlayerUtil.sendMessage(cap.getLivingEntity(), new TranslationTextComponent("regeneration.messages.regen_warning", new Object[0]), true);
    }

    @Override
    public void onGoCritical(IRegen cap) {
        if (cap.getLivingEntity() instanceof ServerPlayerEntity) {
            TriggerManager.CRITICAL.trigger((ServerPlayerEntity)cap.getLivingEntity());
        }
        if (!cap.getLivingEntity().func_110148_a(SharedMonsterAttributes.field_111263_d).func_180374_a(this.slownessModifier)) {
            cap.getLivingEntity().func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(this.slownessModifier);
        }
    }

    @Override
    public void onRegenFinish(IRegen cap) {
        LivingEntity player = cap.getLivingEntity();
        if (cap.getLivingEntity() instanceof ServerPlayerEntity) {
            TriggerManager.FIRST_REGENERATION.trigger((ServerPlayerEntity)cap.getLivingEntity());
        }
        player.func_195064_c(new EffectInstance(Effects.field_76428_l, (Integer)RegenConfig.COMMON.postRegenerationDuration.get() * 2, (Integer)RegenConfig.COMMON.postRegenerationLevel.get() - 1, false, false));
        player.func_70606_j(player.func_110138_aP());
        player.func_110149_m((float)((Integer)RegenConfig.COMMON.absorbtionLevel.get() * 2));
        cap.setTrait(TraitManager.getRandomDna(player.field_70170_p.field_73012_v).getRegistryName());
        TraitManager.IDna newDna = TraitManager.getDnaEntry(cap.getTrait());
        newDna.onAdded(cap);
        cap.setDnaActive(true);
        PlayerUtil.sendMessage(player, new TranslationTextComponent(newDna.getLangKey(), new Object[0]), true);
        cap.setNextSkin(RegenUtil.NO_SKIN);
    }

    @Override
    public void onPerformingPost(IRegen cap) {
        PlayerUtil.handleCutOffhand(cap.getLivingEntity());
    }

    @Override
    public void onRegenTrigger(IRegen cap) {
        LivingEntity player = cap.getLivingEntity();
        NetworkDispatcher.sendPacketToAll(new PlaySFXMessage(CommonActing.getRandomSound(player.field_70170_p.field_73012_v, cap).getRegistryName(), player.func_110124_au()));
        player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_188479_b(this.MAX_HEALTH_ID);
        player.func_110148_a(SharedMonsterAttributes.field_111263_d).func_188479_b(this.SLOWNESS_ID);
        player.func_70606_j(Math.max(player.func_110143_aJ(), 8.0f));
        player.func_110149_m(0.0f);
        player.func_70066_B();
        player.func_184226_ay();
        player.func_195061_cb();
        player.func_184210_p();
        if (player instanceof PlayerEntity) {
            PlayerEntity playerEntity = (PlayerEntity)player;
            if (((Boolean)RegenConfig.COMMON.resetHunger.get()).booleanValue()) {
                playerEntity.func_71024_bL().func_75114_a(20);
            }
        }
        if (((Boolean)RegenConfig.COMMON.resetOxygen.get()).booleanValue()) {
            player.func_70050_g(300);
        }
        cap.extractRegeneration(1);
    }
}

