/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.network;

import me.swirtzly.regeneration.network.messages.ForceRegenerationMessage;
import me.swirtzly.regeneration.network.messages.InvalidatePlayerDataMessage;
import me.swirtzly.regeneration.network.messages.NextSkinMessage;
import me.swirtzly.regeneration.network.messages.PlaySFXMessage;
import me.swirtzly.regeneration.network.messages.RegenerateMessage;
import me.swirtzly.regeneration.network.messages.SyncDataMessage;
import me.swirtzly.regeneration.network.messages.SyncRegenDataToClientMessage;
import me.swirtzly.regeneration.network.messages.ThirdPersonMessage;
import me.swirtzly.regeneration.network.messages.UpdateColorMessage;
import me.swirtzly.regeneration.network.messages.UpdateSkinMapMessage;
import me.swirtzly.regeneration.network.messages.UpdateSkinMessage;
import me.swirtzly.regeneration.network.messages.UpdateStateMessage;
import me.swirtzly.regeneration.network.messages.UpdateTypeMessage;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class NetworkDispatcher {
    private static final String PROTOCOL_VERSION = Integer.toString(1);
    public static final SimpleChannel INSTANCE = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("regeneration", "main_channel")).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();

    public static void init() {
        int id = 0;
        INSTANCE.registerMessage(id++, UpdateColorMessage.class, UpdateColorMessage::encode, UpdateColorMessage::decode, UpdateColorMessage.Handler::handle);
        INSTANCE.registerMessage(id++, ThirdPersonMessage.class, ThirdPersonMessage::encode, ThirdPersonMessage::decode, ThirdPersonMessage.Handler::handle);
        INSTANCE.registerMessage(id++, UpdateStateMessage.class, UpdateStateMessage::encode, UpdateStateMessage::decode, UpdateStateMessage.Handler::handle);
        INSTANCE.registerMessage(id++, RegenerateMessage.class, RegenerateMessage::encode, RegenerateMessage::decode, RegenerateMessage.Handler::handle);
        INSTANCE.registerMessage(id++, SyncDataMessage.class, SyncDataMessage::encode, SyncDataMessage::decode, SyncDataMessage.Handler::handle);
        INSTANCE.registerMessage(id++, SyncRegenDataToClientMessage.class, SyncRegenDataToClientMessage::encode, SyncRegenDataToClientMessage::decode, SyncRegenDataToClientMessage.Handler::handle);
        INSTANCE.registerMessage(id++, UpdateSkinMessage.class, UpdateSkinMessage::encode, UpdateSkinMessage::decode, UpdateSkinMessage.Handler::handle);
        INSTANCE.registerMessage(id++, InvalidatePlayerDataMessage.class, InvalidatePlayerDataMessage::encode, InvalidatePlayerDataMessage::decode, InvalidatePlayerDataMessage.Handler::handle);
        INSTANCE.registerMessage(id++, PlaySFXMessage.class, PlaySFXMessage::encode, PlaySFXMessage::decode, PlaySFXMessage.Handler::handle);
        INSTANCE.registerMessage(id++, UpdateSkinMapMessage.class, UpdateSkinMapMessage::encode, UpdateSkinMapMessage::decode, UpdateSkinMapMessage.Handler::handle);
        INSTANCE.registerMessage(id++, ForceRegenerationMessage.class, ForceRegenerationMessage::encode, ForceRegenerationMessage::decode, ForceRegenerationMessage.Handler::handle);
        INSTANCE.registerMessage(id++, NextSkinMessage.class, NextSkinMessage::encode, NextSkinMessage::decode, NextSkinMessage.Handler::handle);
        INSTANCE.registerMessage(id++, UpdateTypeMessage.class, UpdateTypeMessage::encode, UpdateTypeMessage::decode, UpdateTypeMessage.Handler::handle);
    }

    public static void sendToServer(Object msg) {
        INSTANCE.sendToServer(msg);
    }

    public static void sendTo(Object msg, ServerPlayerEntity player) {
        if (!(player instanceof FakePlayer)) {
            INSTANCE.sendTo(msg, player.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public static void sendPacketToDimension(DimensionType dimensionType, Object packet) {
        for (ServerPlayerEntity player : ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v()) {
            if (player.field_71093_bK != dimensionType) continue;
            NetworkDispatcher.sendTo(packet, player);
        }
    }

    public static void sendPacketToAll(Object packet) {
        for (ServerPlayerEntity player : ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v()) {
            NetworkDispatcher.sendTo(packet, player);
        }
    }
}

