/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.network.messages;

import java.util.function.Supplier;
import me.swirtzly.regeneration.client.skinhandling.SkinInfo;
import me.swirtzly.regeneration.common.capability.RegenCap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class NextSkinMessage {
    private boolean isAlex;
    private String encodedSkin;

    public NextSkinMessage(String encodedSkin, boolean isAlex) {
        this.encodedSkin = encodedSkin;
        this.isAlex = isAlex;
    }

    public static void encode(NextSkinMessage message, PacketBuffer packetBuffer) {
        packetBuffer.func_180714_a(message.encodedSkin);
        packetBuffer.writeBoolean(message.isAlex);
    }

    public static NextSkinMessage decode(PacketBuffer buffer) {
        return new NextSkinMessage(buffer.func_150789_c(Short.MAX_VALUE), buffer.readBoolean());
    }

    public static class Handler {
        public static void handle(NextSkinMessage message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().getSender().func_184102_h().func_213165_a(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                RegenCap.get((Entity)player).ifPresent(data -> {
                    data.setNextSkin(message.encodedSkin);
                    data.setNextSkinType(message.isAlex ? SkinInfo.SkinType.ALEX : SkinInfo.SkinType.STEVE);
                    data.synchronise();
                });
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

