/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.network.messages;

import java.util.UUID;
import java.util.function.Supplier;
import me.swirtzly.regeneration.common.capability.RegenCap;
import me.swirtzly.regeneration.util.client.ClientUtil;
import me.swirtzly.regeneration.util.common.PlayerUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.network.NetworkEvent;

public class PlaySFXMessage {
    private ResourceLocation sound;
    private UUID playerUUID;

    public PlaySFXMessage(ResourceLocation sound, UUID playerUUID) {
        this.playerUUID = playerUUID;
        this.sound = sound;
    }

    public static void encode(PlaySFXMessage message, PacketBuffer buffer) {
        buffer.func_192572_a(message.sound);
        buffer.func_179252_a(message.playerUUID);
    }

    public static PlaySFXMessage decode(PacketBuffer buffer) {
        return new PlaySFXMessage(buffer.func_192575_l(), buffer.func_179253_g());
    }

    public static class Handler {
        public static void handle(PlaySFXMessage message, Supplier<NetworkEvent.Context> ctx) {
            Minecraft.func_71410_x().func_213165_a(() -> {
                PlayerEntity player = Minecraft.func_71410_x().field_71441_e.func_217371_b(message.playerUUID);
                if (player != null) {
                    RegenCap.get((Entity)player).ifPresent(data -> ClientUtil.playSound(player, message.sound, SoundCategory.PLAYERS, true, () -> !data.getState().equals((Object)PlayerUtil.RegenState.REGENERATING), 1.0f));
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

