/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.network.messages;

import java.util.function.Supplier;
import me.swirtzly.regeneration.common.capability.IRegen;
import me.swirtzly.regeneration.common.capability.RegenCap;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class SyncDataMessage {
    private final Entity player;
    private final DimensionType dimensionType;

    public SyncDataMessage(Entity player) {
        this.player = player;
        this.dimensionType = player.field_70170_p.field_73011_w.func_186058_p();
    }

    public static void encode(SyncDataMessage message, PacketBuffer packetBuffer) {
        packetBuffer.writeInt(message.player.func_145782_y());
        packetBuffer.func_192572_a(message.dimensionType.getRegistryName());
    }

    public static SyncDataMessage decode(PacketBuffer buffer) {
        int entityID = buffer.readInt();
        DimensionType type = DimensionType.func_193417_a((ResourceLocation)buffer.func_192575_l());
        if (ServerLifecycleHooks.getCurrentServer().func_71218_a(type) == null) {
            return new SyncDataMessage(ServerLifecycleHooks.getCurrentServer().func_71218_a(type).func_73045_a(entityID));
        }
        return null;
    }

    public static class Handler {
        public static void handle(SyncDataMessage message, Supplier<NetworkEvent.Context> ctx) {
            Entity player = message.player;
            ctx.get().getSender().func_184102_h().func_213165_a(() -> {
                if (player != null) {
                    RegenCap.get(player).ifPresent(IRegen::synchronise);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

