/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.network.messages;

import java.util.function.Supplier;
import me.swirtzly.regeneration.client.skinhandling.SkinInfo;
import me.swirtzly.regeneration.common.capability.IRegen;
import me.swirtzly.regeneration.common.capability.RegenCap;
import me.swirtzly.regeneration.network.NetworkDispatcher;
import me.swirtzly.regeneration.network.messages.InvalidatePlayerDataMessage;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class UpdateSkinMessage {
    private final boolean isAlex;
    private final String encodedSkin;

    public UpdateSkinMessage(String pixelData, boolean isAlex) {
        this.isAlex = isAlex;
        this.encodedSkin = pixelData;
    }

    public static void encode(UpdateSkinMessage skin, PacketBuffer buf) {
        buf.func_180714_a(skin.encodedSkin);
        buf.writeBoolean(skin.isAlex);
    }

    public static UpdateSkinMessage decode(PacketBuffer buf) {
        return new UpdateSkinMessage(buf.func_150789_c(Short.MAX_VALUE), buf.readBoolean());
    }

    public static class Handler {
        public static void handle(UpdateSkinMessage message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().getSender().func_184102_h().func_213165_a(() -> RegenCap.get((Entity)((NetworkEvent.Context)ctx.get()).getSender()).ifPresent(arg_0 -> Handler.lambda$null$0(message, (Supplier)ctx, arg_0)));
            ctx.get().setPacketHandled(true);
        }

        private static /* synthetic */ void lambda$null$0(UpdateSkinMessage message, Supplier ctx, IRegen cap) {
            cap.setEncodedSkin(message.encodedSkin);
            cap.setSkinType(message.isAlex ? SkinInfo.SkinType.ALEX.name() : SkinInfo.SkinType.STEVE.name());
            cap.synchronise();
            NetworkDispatcher.sendPacketToAll(new InvalidatePlayerDataMessage(((NetworkEvent.Context)ctx.get()).getSender().func_110124_au()));
        }
    }
}

