/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.proxy;

import java.util.Map;
import me.swirtzly.animateme.AnimationManager;
import me.swirtzly.regeneration.client.RegenKeyBinds;
import me.swirtzly.regeneration.client.animation.GeneralAnimations;
import me.swirtzly.regeneration.client.gui.BioContainerScreen;
import me.swirtzly.regeneration.client.rendering.layers.HandsLayer;
import me.swirtzly.regeneration.client.rendering.layers.RegenerationLayer;
import me.swirtzly.regeneration.client.rendering.model.GuardModel;
import me.swirtzly.regeneration.client.rendering.model.RobeModel;
import me.swirtzly.regeneration.client.rendering.tiles.ArchRender;
import me.swirtzly.regeneration.client.rendering.tiles.HandTileRenderer;
import me.swirtzly.regeneration.client.rendering.types.FieryRenderer;
import me.swirtzly.regeneration.client.rendering.types.TypeLayFadeRenderer;
import me.swirtzly.regeneration.client.skinhandling.SkinManipulation;
import me.swirtzly.regeneration.common.tiles.ArchTile;
import me.swirtzly.regeneration.common.tiles.HandInJarTile;
import me.swirtzly.regeneration.handlers.ClientHandler;
import me.swirtzly.regeneration.handlers.RegenObjects;
import me.swirtzly.regeneration.proxy.CommonProxy;
import me.swirtzly.regeneration.util.common.FileUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class ClientProxy
extends CommonProxy {
    private static final RobeModel ROBES = new RobeModel();
    private static final GuardModel GUARD_HEAD = new GuardModel(EquipmentSlotType.HEAD);
    private static final GuardModel GUARD_CHEST = new GuardModel(EquipmentSlotType.CHEST);
    private static final GuardModel GUARD_LEGGINGS = new GuardModel(EquipmentSlotType.LEGS);
    private static final GuardModel GUARD_FEET = new GuardModel(EquipmentSlotType.FEET);

    @Override
    public void preInit() {
        super.preInit();
    }

    @Override
    public void init() {
        super.init();
        ScreenManager.func_216911_a((ContainerType)((ContainerType)RegenObjects.Containers.BIO_CONTAINER.get()), BioContainerScreen::new);
    }

    @Override
    public void postInit() {
        if (FMLEnvironment.dist == Dist.DEDICATED_SERVER) {
            return;
        }
        super.postInit();
        RegenKeyBinds.init();
        Map skinMap = Minecraft.func_71410_x().func_175598_ae().getSkinMap();
        for (PlayerRenderer renderPlayer : skinMap.values()) {
            renderPlayer.func_177094_a((LayerRenderer)new RegenerationLayer((LivingRenderer)renderPlayer));
            renderPlayer.func_177094_a((LayerRenderer)new HandsLayer((IEntityRenderer)renderPlayer));
        }
        FileUtil.doSetupOnThread();
        MinecraftForge.EVENT_BUS.register((Object)new SkinManipulation());
        MinecraftForge.EVENT_BUS.register((Object)new ClientHandler());
        AnimationManager.registerAnimations(new GeneralAnimations(), new FieryRenderer(), new TypeLayFadeRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(HandInJarTile.class, (TileEntityRenderer)new HandTileRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(ArchTile.class, (TileEntityRenderer)new ArchRender());
    }

    @Override
    public void closeGui() {
        Minecraft.func_71410_x().func_147108_a(null);
    }

    @Override
    public World getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    @Override
    public PlayerEntity getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public static BipedModel getArmorModel(ItemStack item) {
        if (item.func_77973_b().getRegistryName().toString().contains("robes")) {
            return ROBES;
        }
        if (item.func_77973_b() == RegenObjects.Items.GUARD_HEAD.get()) {
            return GUARD_HEAD;
        }
        if (item.func_77973_b() == RegenObjects.Items.GUARD_CHEST.get()) {
            return GUARD_CHEST;
        }
        if (item.func_77973_b() == RegenObjects.Items.GUARD_LEGGINGS.get()) {
            return GUARD_LEGGINGS;
        }
        if (item.func_77973_b() == RegenObjects.Items.GUARD_FEET.get()) {
            return GUARD_FEET;
        }
        return GUARD_HEAD;
    }
}

