/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.util.client;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import java.nio.FloatBuffer;
import me.swirtzly.regeneration.util.common.PlayerUtil;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.RendererModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.opengl.GL11;

public class RenderUtil {
    private static final ResourceLocation VIGNETTE_TEX_PATH = new ResourceLocation("regeneration", "textures/misc/vignette.png");
    public static float renderTick = Minecraft.func_71410_x().func_184121_ak();
    private static float lastBrightnessX = GLX.lastBrightnessX;
    private static float lastBrightnessY = GLX.lastBrightnessY;

    public static void setLightmapTextureCoords(float x, float y) {
        lastBrightnessX = GLX.lastBrightnessX;
        lastBrightnessY = GLX.lastBrightnessY;
        GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)x, (float)y);
    }

    public static void restoreLightMap() {
        GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)lastBrightnessX, (float)lastBrightnessY);
    }

    public static void drawGlowingLine(Vec3d start, Vec3d end, float thickness, Vec3d color, float alpha) {
        if (start == null || end == null) {
            return;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bb = tessellator.func_178180_c();
        int smoothFactor = Minecraft.func_71410_x().field_71474_y.field_74348_k.func_216572_a();
        int layers = 10 + smoothFactor * 20;
        GlStateManager.pushMatrix();
        GlStateManager.disableTexture();
        start = start.func_186678_a(-1.0);
        end = end.func_186678_a(-1.0);
        GlStateManager.translated((double)(-start.field_72450_a), (double)(-start.field_72448_b), (double)(-start.field_72449_c));
        start = end.func_178788_d(start);
        end = end.func_178788_d(end);
        double x = end.field_72450_a - start.field_72450_a;
        double y = end.field_72448_b - start.field_72448_b;
        double z = end.field_72449_c - start.field_72449_c;
        double diff = MathHelper.func_76133_a((double)(x * x + z * z));
        float yaw = (float)(Math.atan2(z, x) * 180.0 / Math.PI) - 90.0f;
        float pitch = (float)(-(Math.atan2(y, diff) * 180.0 / Math.PI));
        GlStateManager.rotatef((float)(-yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        for (int layer = 0; layer <= layers; ++layer) {
            if (layer < layers) {
                GlStateManager.color4f((float)((float)color.field_72450_a), (float)((float)color.field_72448_b), (float)((float)color.field_72449_c), (float)(1.0f / (float)layers / 2.0f));
                GlStateManager.depthMask((boolean)false);
            } else {
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                GlStateManager.depthMask((boolean)true);
            }
            double size = (double)thickness + (layer < layers ? (double)layer * (1.25 / (double)layers) : 0.0);
            double d = (layer < layers ? 1.0 - (double)layer * (1.0 / (double)layers) : 0.0) * 0.1;
            double width = 0.0625 * size;
            double height = 0.0625 * size;
            double length = start.func_72438_d(end) + d;
            bb.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            bb.func_181662_b(-width, height, length).func_181675_d();
            bb.func_181662_b(width, height, length).func_181675_d();
            bb.func_181662_b(width, height, -d).func_181675_d();
            bb.func_181662_b(-width, height, -d).func_181675_d();
            bb.func_181662_b(width, -height, -d).func_181675_d();
            bb.func_181662_b(width, -height, length).func_181675_d();
            bb.func_181662_b(-width, -height, length).func_181675_d();
            bb.func_181662_b(-width, -height, -d).func_181675_d();
            bb.func_181662_b(-width, -height, -d).func_181675_d();
            bb.func_181662_b(-width, -height, length).func_181675_d();
            bb.func_181662_b(-width, height, length).func_181675_d();
            bb.func_181662_b(-width, height, -d).func_181675_d();
            bb.func_181662_b(width, height, length).func_181675_d();
            bb.func_181662_b(width, -height, length).func_181675_d();
            bb.func_181662_b(width, -height, -d).func_181675_d();
            bb.func_181662_b(width, height, -d).func_181675_d();
            bb.func_181662_b(width, -height, length).func_181675_d();
            bb.func_181662_b(width, height, length).func_181675_d();
            bb.func_181662_b(-width, height, length).func_181675_d();
            bb.func_181662_b(-width, -height, length).func_181675_d();
            bb.func_181662_b(width, -height, -d).func_181675_d();
            bb.func_181662_b(width, height, -d).func_181675_d();
            bb.func_181662_b(-width, height, -d).func_181675_d();
            bb.func_181662_b(-width, -height, -d).func_181675_d();
            tessellator.func_78381_a();
        }
        GlStateManager.enableTexture();
        GlStateManager.popMatrix();
    }

    public static void setupRenderLightning() {
        GlStateManager.pushMatrix();
        GlStateManager.disableTexture();
        GlStateManager.disableLighting();
        GlStateManager.disableCull();
        GlStateManager.enableBlend();
        GlStateManager.enableAlphaTest();
        GlStateManager.blendFunc((int)GlStateManager.SourceFactor.SRC_ALPHA.value, (int)GlStateManager.SourceFactor.CONSTANT_ALPHA.value);
        GlStateManager.alphaFunc((int)516, (float)0.003921569f);
        RenderUtil.setLightmapTextureCoords(240.0f, 240.0f);
    }

    public static void finishRenderLightning() {
        RenderUtil.restoreLightMap();
        GlStateManager.enableLighting();
        GlStateManager.enableTexture();
        GlStateManager.alphaFunc((int)516, (float)0.1f);
        GlStateManager.disableBlend();
        GlStateManager.disableAlphaTest();
        GlStateManager.popMatrix();
    }

    public static void renderVignette(Vec3d color, float alpha, PlayerUtil.RegenState state) {
        GlStateManager.color4f((float)((float)color.field_72450_a), (float)((float)color.field_72448_b), (float)((float)color.field_72449_c), (float)alpha);
        GlStateManager.disableAlphaTest();
        GlStateManager.depthMask((boolean)false);
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(VIGNETTE_TEX_PATH);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        MainWindow scaledRes = Minecraft.func_71410_x().field_195558_d;
        int z = -89;
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b(0.0, (double)scaledRes.func_198087_p(), (double)z).func_187315_a(0.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b((double)scaledRes.func_198107_o(), (double)scaledRes.func_198087_p(), (double)z).func_187315_a(1.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b((double)scaledRes.func_198107_o(), 0.0, (double)z).func_187315_a(1.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b(0.0, 0.0, (double)z).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.depthMask((boolean)true);
        GlStateManager.enableAlphaTest();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static double calculateColorBrightness(Vec3d c) {
        float r = (float)c.field_72450_a;
        float g = (float)c.field_72448_b;
        float b = (float)c.field_72449_c;
        r = (double)r <= 0.03928 ? r / 12.92f : (float)Math.pow(((double)r + 0.055) / 1.055, 2.4);
        g = (double)g <= 0.03928 ? g / 12.92f : (float)Math.pow(((double)g + 0.055) / 1.055, 2.4);
        b = (double)b <= 0.03928 ? b / 12.92f : (float)Math.pow(((double)b + 0.055) / 1.055, 2.4);
        return 0.2126 * (double)r + 0.7152 * (double)g + 0.0722 * (double)b;
    }

    public static void drawModelToGui(EntityModel model, int xPos, int yPos, float scale, float rotation) {
        GlStateManager.pushMatrix();
        GlStateManager.enableDepthTest();
        GlStateManager.enableBlend();
        GL11.glBlendFunc((int)770, (int)771);
        GlStateManager.translatef((float)xPos, (float)yPos, (float)100.0f);
        GlStateManager.rotatef((float)-25.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.rotatef((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74520_c();
        GlStateManager.lightModel((int)2899, (FloatBuffer)RenderHelper.func_74521_a((float)0.75f, (float)0.75f, (float)0.75f, (float)1.0f));
        GlStateManager.scalef((float)(38.0f * scale), (float)(34.0f * scale), (float)(38.0f * scale));
        GlStateManager.scalef((float)-1.0f, (float)1.0f, (float)1.0f);
        model.func_78088_a((Entity)Minecraft.func_71410_x().field_71439_g, 0.0f, 0.0f, (float)Minecraft.func_71410_x().field_71439_g.field_70173_aa, 0.0f, 0.0f, 0.0625f);
        RenderHelper.func_74518_a();
        GlStateManager.disableBlend();
        GlStateManager.disableDepthTest();
        GlStateManager.popMatrix();
    }

    public static void copyModelAngles(RendererModel src, RendererModel dest) {
        dest.field_78795_f = src.field_78795_f;
        dest.field_78796_g = src.field_78796_g;
        dest.field_78808_h = src.field_78808_h;
        dest.field_78800_c = src.field_78800_c;
        dest.field_78797_d = src.field_78797_d;
        dest.field_78798_e = src.field_78798_e;
    }

    public static void drawRect(int left, int top, int right, int bottom, float red, float green, float blue, float alpha) {
        if (left < right) {
            int i = left;
            left = right;
            right = i;
        }
        if (top < bottom) {
            int j = top;
            top = bottom;
            bottom = j;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        GlStateManager.enableBlend();
        GlStateManager.disableTexture();
        GlStateManager.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        GlStateManager.color4f((float)red, (float)green, (float)blue, (float)alpha);
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferBuilder.func_181662_b((double)left, (double)bottom, 0.0).func_181675_d();
        bufferBuilder.func_181662_b((double)right, (double)bottom, 0.0).func_181675_d();
        bufferBuilder.func_181662_b((double)right, (double)top, 0.0).func_181675_d();
        bufferBuilder.func_181662_b((double)left, (double)top, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.enableTexture();
        GlStateManager.disableBlend();
    }
}

