/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.util.common;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import me.swirtzly.regeneration.RegenConfig;
import me.swirtzly.regeneration.Regeneration;
import me.swirtzly.regeneration.client.image.ImageDownloader;
import me.swirtzly.regeneration.common.skin.HandleSkins;
import me.swirtzly.regeneration.util.client.ClientUtil;
import me.swirtzly.regeneration.util.client.SkinDownloadManager;
import me.swirtzly.regeneration.util.common.RegenUtil;
import org.apache.commons.io.FileUtils;

public class FileUtil {
    public static void handleDownloads() throws IOException {
        String[] links;
        if (!((Boolean)RegenConfig.CLIENT.downloadInteralSkins.get()).booleanValue() || !RegenUtil.doesHaveInternet()) {
            return;
        }
        String PACKS_URL = "https://raw.githubusercontent.com/Swirtzly/Regeneration/skins/index.json";
        for (String link : links = (String[])Regeneration.GSON.fromJson(FileUtil.getJsonFromURL(PACKS_URL), String[].class)) {
            FileUtil.unzipSkinPack(link);
        }
    }

    public static void createDefaultFolders() throws IOException {
        if (!HandleSkins.SKIN_DIRECTORY.exists()) {
            FileUtils.forceMkdir((File)HandleSkins.SKIN_DIRECTORY);
        }
        if (!HandleSkins.SKIN_DIRECTORY_ALEX.exists()) {
            FileUtils.forceMkdir((File)HandleSkins.SKIN_DIRECTORY_ALEX);
        }
        if (!HandleSkins.SKIN_DIRECTORY_STEVE.exists()) {
            FileUtils.forceMkdir((File)HandleSkins.SKIN_DIRECTORY_STEVE);
        }
    }

    public static void downloadSkins(URL url, String filename, File alexDir, File steveDir) throws IOException {
        File file;
        URLConnection uc = url.openConnection();
        uc.connect();
        uc = url.openConnection();
        uc.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.75 Safari/537.36");
        Regeneration.LOG.warn("Downloading Skin from: {}", (Object)url.toString());
        BufferedImage img = ImageIO.read(uc.getInputStream());
        img = ClientUtil.ImageFixer.convertSkinTo64x64(img);
        File file2 = file = ImageDownloader.isAlexSkin(img) ? alexDir : steveDir;
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!steveDir.exists()) {
            steveDir.mkdirs();
        }
        if (!alexDir.exists()) {
            alexDir.mkdirs();
        }
        Regeneration.LOG.warn("Saving Skin to: {}", (Object)file.getPath());
        ImageIO.write((RenderedImage)img, "png", new File(file, filename + ".png"));
    }

    public static void doSetupOnThread() {
        AtomicBoolean notDownloaded = new AtomicBoolean(true);
        new Thread(() -> {
            while (notDownloaded.get()) {
                try {
                    FileUtil.createDefaultFolders();
                    FileUtil.handleDownloads();
                    SkinDownloadManager.downloadTrendingSkins();
                    SkinDownloadManager.downloadPreviousSkins();
                    notDownloaded.set(false);
                }
                catch (Exception e) {
                    Regeneration.LOG.error("Regeneration Mod: Failed to download skins! Check your internet connection and ensure you are playing in online mode!");
                    Regeneration.LOG.error(e.getMessage());
                }
            }
        }, "Regeneration Download Daemon").start();
    }

    public static void unzipSkinPack(String url) throws IOException {
        File tempZip = new File(HandleSkins.SKIN_DIRECTORY + "/temp/" + System.currentTimeMillis() + ".zip");
        Regeneration.LOG.info("Downloading " + url + " to " + tempZip.getAbsolutePath());
        FileUtils.copyURLToFile((URL)new URL(url), (File)tempZip);
        try (ZipFile file = new ZipFile(tempZip);){
            FileSystem fileSystem = FileSystems.getDefault();
            Enumeration<? extends ZipEntry> entries = file.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) {
                    Files.createDirectories(fileSystem.getPath(HandleSkins.SKIN_DIRECTORY + File.separator + entry.getName(), new String[0]), new FileAttribute[0]);
                    continue;
                }
                InputStream is = file.getInputStream(entry);
                BufferedInputStream bis = new BufferedInputStream(is);
                String uncompressedFileName = HandleSkins.SKIN_DIRECTORY + File.separator + entry.getName();
                Path uncompressedFilePath = fileSystem.getPath(uncompressedFileName, new String[0]);
                Regeneration.LOG.info("Extracting file: " + uncompressedFilePath);
                File temp = uncompressedFilePath.toFile();
                if (temp.exists()) {
                    Regeneration.LOG.info("Recreating: " + uncompressedFilePath);
                    temp.delete();
                }
                Files.createFile(uncompressedFilePath, new FileAttribute[0]);
                FileOutputStream fileOutput = new FileOutputStream(uncompressedFileName);
                while (bis.available() > 0) {
                    fileOutput.write(bis.read());
                }
                fileOutput.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (tempZip.exists()) {
            FileUtils.forceDelete((File)tempZip.getParentFile());
        }
    }

    public static String getJsonFromURL(String URL2) {
        URL url = null;
        try {
            url = new URL(URL2);
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            String line = FileUtil.bufferedReaderToString(in);
            line = line.replace("<pre>", "");
            line = line.replace("</pre>", "");
            return line;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String bufferedReaderToString(BufferedReader e) {
        StringBuilder builder = new StringBuilder();
        String aux = "";
        try {
            while ((aux = e.readLine()) != null) {
                builder.append(aux);
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return builder.toString();
    }
}

