/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.util.common;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import me.swirtzly.regeneration.RegenConfig;
import me.swirtzly.regeneration.Regeneration;
import me.swirtzly.regeneration.api.ZeroRoomEvent;
import me.swirtzly.regeneration.common.block.RegenTags;
import me.swirtzly.regeneration.common.block.ZeroRoomBlock;
import me.swirtzly.regeneration.common.capability.RegenCap;
import me.swirtzly.regeneration.common.item.HandItem;
import me.swirtzly.regeneration.handlers.RegenObjects;
import me.swirtzly.regeneration.network.NetworkDispatcher;
import me.swirtzly.regeneration.network.messages.ThirdPersonMessage;
import me.swirtzly.regeneration.network.messages.UpdateSkinMapMessage;
import me.swirtzly.regeneration.util.common.RegenUtil;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.HandSide;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.registries.ForgeRegistries;

public class PlayerUtil {
    private static final Random RAND = new Random();
    public static ArrayList<Effect> POTIONS = new ArrayList();

    public static void updateModel(EnumChoices choice) {
        NetworkDispatcher.INSTANCE.sendToServer((Object)new UpdateSkinMapMessage(choice.name()));
    }

    public static void createPostList() {
        for (String potionName : (List)RegenConfig.COMMON.postRegenEffects.get()) {
            Effect potion = (Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation(potionName));
            if (potion != null) {
                POTIONS.add(potion);
                Regeneration.LOG.info("ADDED: " + potionName);
                continue;
            }
            Regeneration.LOG.error(potionName + " is not a Valid Potion/Effect! Not adding this time around!");
        }
    }

    public static void lookAt(double px, double py, double pz, PlayerEntity me) {
        double dirx = (double)me.func_180425_c().func_177958_n() - px;
        double diry = (double)me.func_180425_c().func_177956_o() - py;
        double dirz = (double)me.func_180425_c().func_177952_p() - pz;
        double len = Math.sqrt(dirx * dirx + diry * diry + dirz * dirz);
        double pitch = Math.asin(diry /= len);
        double yaw = Math.atan2(dirz /= len, dirx /= len);
        pitch = pitch * 180.0 / Math.PI;
        yaw = yaw * 180.0 / Math.PI;
        me.field_70125_A = (float)pitch;
        me.field_70177_z = (float)(yaw += 90.0);
    }

    public static void sendMessage(LivingEntity livingEntity, String message, boolean hotBar) {
        if (!(livingEntity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)livingEntity;
        if (!player.field_70170_p.field_72995_K) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent(message, new Object[0]), hotBar);
        }
    }

    public static void sendMessage(LivingEntity livingEntity, TranslationTextComponent translation, boolean hotBar) {
        if (!(livingEntity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)livingEntity;
        if (!player.field_70170_p.field_72995_K) {
            player.func_146105_b((ITextComponent)translation, hotBar);
        }
    }

    public static void sendMessageToAll(TranslationTextComponent translation) {
        List players = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v();
        players.forEach(playerMP -> PlayerUtil.sendMessage((LivingEntity)playerMP, translation, false));
    }

    public static void setPerspective(ServerPlayerEntity player, boolean thirdperson, boolean resetPitch) {
        NetworkDispatcher.sendTo(new ThirdPersonMessage(thirdperson), player);
    }

    public static void createHand(LivingEntity player) {
        RegenCap.get((Entity)player).ifPresent(data -> {
            if (!data.getEncodedSkin().equalsIgnoreCase(RegenUtil.NO_SKIN) && player instanceof PlayerEntity) {
                ItemStack hand = new ItemStack((IItemProvider)RegenObjects.Items.HAND.get());
                HandItem.setTextureString(hand, data.getEncodedSkin());
                HandItem.setSkinType(hand, data.getSkinType().name());
                HandItem.setOwner(hand, player.func_110124_au());
                HandItem.setTimeCreated(hand, System.currentTimeMillis());
                HandItem.setTrait(hand, data.getTrait().toString());
                data.setDroppedHand(true);
                data.setCutOffHand(player.func_184591_cq() == HandSide.LEFT ? HandSide.RIGHT : HandSide.LEFT);
                data.setDroppedHand(true);
                InventoryHelper.func_180173_a((World)player.field_70170_p, (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (ItemStack)hand);
            }
        });
    }

    public static boolean applyPotionIfAbsent(LivingEntity player, Effect potion, int length, int amplifier, boolean ambient, boolean showParticles) {
        if (potion == null) {
            return false;
        }
        if (player.func_70660_b(potion) == null) {
            player.func_195064_c(new EffectInstance(potion, length, amplifier, ambient, showParticles));
            return true;
        }
        return false;
    }

    public static boolean isSharp(ItemStack stack) {
        return stack.func_77973_b().func_206844_a(RegenTags.SHARP_ITEMS);
    }

    public static void handleCutOffhand(LivingEntity player) {
        RegenCap.get((Entity)player).ifPresent(data -> {
            if (data.hasDroppedHand() && !player.func_184592_cb().func_190926_b()) {
                player.func_199701_a_(player.func_184592_cb());
                player.func_184201_a(EquipmentSlotType.OFFHAND, new ItemStack((IItemProvider)Items.field_190931_a));
            }
        });
    }

    public static boolean isZeroRoom(LivingEntity livingEntity) {
        AxisAlignedBB box = livingEntity.func_174813_aQ().func_186662_g(25.0);
        Iterator iterator = BlockPos.func_218281_b((BlockPos)new BlockPos(box.field_72336_d, box.field_72337_e, box.field_72334_f), (BlockPos)new BlockPos(box.field_72340_a, box.field_72338_b, box.field_72339_c)).iterator();
        while (iterator.hasNext()) {
            boolean isTardis;
            BlockPos pos = (BlockPos)iterator.next();
            BlockState blockState = livingEntity.field_70170_p.func_180495_p(pos);
            if (!(blockState.func_177230_c() instanceof ZeroRoomBlock) || !(isTardis = livingEntity.field_70170_p.field_73011_w.getClass().getName().contains("TardisDimension"))) continue;
            ZeroRoomEvent zeroRoomEvent = new ZeroRoomEvent(livingEntity);
            MinecraftForge.EVENT_BUS.post((Event)zeroRoomEvent);
            if (zeroRoomEvent.isCanceled()) continue;
            return true;
        }
        return false;
    }

    public static boolean isAboveZeroGrid(LivingEntity livingEntity) {
        BlockPos livingPos = livingEntity.func_180425_c().func_177977_b();
        AxisAlignedBB grid = new AxisAlignedBB(livingPos.func_177978_c().func_177976_e(), livingPos.func_177968_d().func_177974_f());
        Iterator iterator = BlockPos.func_218281_b((BlockPos)new BlockPos(grid.field_72336_d, grid.field_72337_e, grid.field_72334_f), (BlockPos)new BlockPos(grid.field_72340_a, grid.field_72338_b, grid.field_72339_c)).iterator();
        while (iterator.hasNext()) {
            BlockPos pos = (BlockPos)iterator.next();
            BlockState state = livingEntity.field_70170_p.func_180495_p(pos);
            if (state.func_177230_c() instanceof ZeroRoomBlock) continue;
            return false;
        }
        return true;
    }

    public static enum RegenState {
        ALIVE,
        GRACE,
        GRACE_CRIT,
        POST,
        REGENERATING;


        public boolean isGraceful() {
            return this == GRACE || this == GRACE_CRIT;
        }

        public static enum Transition {
            HAND_GLOW_START,
            HAND_GLOW_TRIGGER,
            ENTER_CRITICAL,
            CRITICAL_DEATH,
            FINISH_REGENERATION,
            END_POST;

        }
    }

    public static enum EnumChoices implements RegenUtil.IEnum
    {
        ALEX(true),
        STEVE(false),
        EITHER(true);

        private final boolean isAlex;

        private EnumChoices(boolean isAlex) {
            this.isAlex = isAlex;
        }

        public boolean isAlex() {
            if (this == EITHER) {
                return RAND.nextBoolean();
            }
            return this.isAlex;
        }
    }
}

