/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.util.common;

import java.net.Socket;
import java.util.Random;
import java.util.UUID;
import me.swirtzly.regeneration.RegenConfig;
import me.swirtzly.regeneration.Regeneration;
import me.swirtzly.regeneration.handlers.RegenObjects;
import me.swirtzly.regeneration.util.common.FileUtil;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class RegenUtil {
    public static String[] TIMELORD_NAMES = new String[]{"Timelord"};
    private static final Random rand = new Random();
    public static String NO_SKIN = "no_skin";

    public static String[] downloadNames() {
        String[] names = (String[])Regeneration.GSON.fromJson(FileUtil.getJsonFromURL("https://raw.githubusercontent.com/Swirtzly/Regeneration/skins/timelord-names.json"), String[].class);
        if (names == null) {
            return new String[]{"TIMELORD"};
        }
        return names;
    }

    public static boolean isSlimSkin(UUID playerUUID) {
        return (playerUUID.hashCode() & 1) == 1;
    }

    public static <T extends Enum<?>> T randomEnum(Class<T> clazz) {
        int x = rand.nextInt(((Enum[])clazz.getEnumConstants()).length);
        return (T)((Enum[])clazz.getEnumConstants())[x];
    }

    public static float randFloat(float min, float max) {
        return rand.nextFloat() * (max - min) + min;
    }

    public static void genCrater(World world, BlockPos pos, int radius) {
        for (int x = pos.func_177958_n() - radius; x < pos.func_177958_n() + radius; ++x) {
            for (int y = pos.func_177956_o() - radius; y < pos.func_177956_o() + radius; ++y) {
                for (int z = pos.func_177952_p() - radius; z < pos.func_177952_p() + radius; ++z) {
                    BlockState block;
                    double squareDistance = Math.pow(x - pos.func_177958_n(), 2.0) + Math.pow(y - pos.func_177956_o(), 2.0) + Math.pow(z - pos.func_177952_p(), 2.0);
                    if (!(squareDistance <= Math.pow(radius, 2.0)) || (block = world.func_180495_p(new BlockPos(x, y, z))).func_177230_c() == Blocks.field_150357_h) continue;
                    BlockPos blockPos = new BlockPos(x, y, z);
                    if (!(block.func_185887_b((IBlockReader)world, blockPos) < 3.0f)) continue;
                    if (!world.field_72995_K) {
                        TileEntity tileEntity;
                        if (world.func_175625_s(new BlockPos(x, y, z)) != null && (tileEntity = world.func_175625_s(new BlockPos(x, y, z))) instanceof IInventory) {
                            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((IInventory)tileEntity));
                            world.func_175666_e(pos, block.func_177230_c());
                        }
                        InventoryHelper.func_180173_a((World)world, (double)x, (double)y, (double)z, (ItemStack)new ItemStack((IItemProvider)block.func_177230_c()));
                    }
                    world.func_175656_a(new BlockPos(x, y, z), Blocks.field_150350_a.func_176223_P());
                }
            }
        }
    }

    public static void regenerationExplosion(LivingEntity player) {
        RegenUtil.explodeKnockback((Entity)player, player.field_70170_p, player.func_180425_c(), (Double)RegenConfig.COMMON.regenerativeKnockback.get(), (Integer)RegenConfig.COMMON.regenKnockbackRange.get());
        RegenUtil.explodeKill((Entity)player, player.field_70170_p, player.func_180425_c(), (Integer)RegenConfig.COMMON.regenerativeKillRange.get());
    }

    public static void explodeKill(Entity exploder, World world, BlockPos pos, int range) {
        world.func_72839_b(exploder, RegenUtil.getReach(pos, range)).forEach(entity -> {
            if (entity instanceof CreatureEntity && entity.func_184222_aU() || entity instanceof PlayerEntity) {
                entity.func_70097_a(RegenObjects.REGEN_DMG_ENERGY_EXPLOSION, Float.MAX_VALUE);
            }
        });
    }

    public static AxisAlignedBB getReach(BlockPos pos, int range) {
        return new AxisAlignedBB(pos.func_177981_b(range).func_177964_d(range).func_177985_f(range), pos.func_177979_c(range).func_177970_e(range).func_177965_g(range));
    }

    public static void explodeKnockback(Entity exploder, World world, BlockPos pos, double knockback, int range) {
        world.func_72839_b(exploder, RegenUtil.getReach(pos, range)).forEach(entity -> {
            if (entity instanceof LivingEntity && exploder.func_70089_S()) {
                LivingEntity victim = (LivingEntity)entity;
                if (entity instanceof PlayerEntity && !((Boolean)RegenConfig.COMMON.regenerationKnocksbackPlayers.get()).booleanValue() || !victim.func_184222_aU()) {
                    return;
                }
                float densMod = 1.0f;
                int xr = (int)(-(victim.field_70165_t - exploder.field_70165_t));
                int zr = (int)(-(victim.field_70161_v - exploder.field_70161_v));
                victim.func_70653_a(exploder, (float)(knockback * (double)densMod), (double)xr, (double)zr);
            }
        });
    }

    public static boolean doesHaveInternet() {
        try {
            Socket socket = new Socket("www.google.com", 80);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static interface IEnum<E extends Enum<E>> {
        public int ordinal();

        default public E next() {
            Enum[] ies = this.getAllValues();
            return (E)(this.ordinal() != ies.length - 1 ? ies[this.ordinal() + 1] : null);
        }

        default public E previous() {
            return (E)(this.ordinal() != 0 ? this.getAllValues()[this.ordinal() - 1] : null);
        }

        default public E[] getAllValues() {
            IEnum[] ies = (IEnum[])this.getClass().getEnumConstants();
            return (Enum[])ies;
        }
    }
}

