/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.util.common;

public class ScheduledAction {
    private final Runnable callback;
    protected long currentTick;
    protected long scheduledTick;

    public ScheduledAction(Runnable callback, long inTicks) {
        if (inTicks < 0L) {
            throw new IllegalArgumentException("Can't schedule an action in the past (would be in " + inTicks + ")");
        }
        this.callback = callback;
        this.scheduledTick = inTicks;
    }

    public boolean tick() {
        if (this.scheduledTick == -1L) {
            return false;
        }
        if (this.currentTick == this.scheduledTick) {
            this.callback.run();
            this.scheduledTick = -1L;
            return true;
        }
        if (this.currentTick > this.scheduledTick) {
            throw new IllegalStateException("Task wasn't executed at " + this.scheduledTick + ", but we're on " + this.currentTick);
        }
        ++this.currentTick;
        return false;
    }

    public void cancel() {
        this.scheduledTick = -1L;
    }

    @Deprecated
    public long getTicksLeft() {
        if (this.scheduledTick == -1L) {
            return -1L;
        }
        return this.scheduledTick - this.currentTick;
    }

    public double getProgress() {
        return (double)this.currentTick / (double)this.scheduledTick;
    }
}

