/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Map;
import me.swirtzly.regen.client.RKeybinds;
import me.swirtzly.regen.client.rendering.entity.ItemOverrideRenderer;
import me.swirtzly.regen.client.rendering.entity.TimelordRenderer;
import me.swirtzly.regen.client.rendering.layers.HandLayer;
import me.swirtzly.regen.client.rendering.layers.RenderRegenLayer;
import me.swirtzly.regen.client.skin.CommonSkin;
import me.swirtzly.regen.common.entities.TimelordEntity;
import me.swirtzly.regen.common.item.FobWatchItem;
import me.swirtzly.regen.common.objects.REntities;
import me.swirtzly.regen.common.objects.RItems;
import me.swirtzly.regen.common.objects.RSounds;
import me.swirtzly.regen.common.regen.IRegen;
import me.swirtzly.regen.common.regen.RegenCap;
import me.swirtzly.regen.common.regen.RegenStorage;
import me.swirtzly.regen.common.regen.acting.ActingForwarder;
import me.swirtzly.regen.config.RegenConfig;
import me.swirtzly.regen.data.EnglishLangGen;
import me.swirtzly.regen.data.RRecipeGen;
import me.swirtzly.regen.data.RSoundsGen;
import me.swirtzly.regen.network.NetworkDispatcher;
import me.swirtzly.regen.util.PlayerUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.BipedRenderer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="regen")
public class Regeneration {
    public static final Logger LOG = LogManager.getLogger((String)"Regeneration");
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public Regeneration() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doCommonStuff);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
        NetworkDispatcher.setUp();
        PlayerUtil.setupPotions();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, RegenConfig.COMMON_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, RegenConfig.CLIENT_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, RegenConfig.SKIN_SPEC, "regen-skin.toml");
    }

    private void doCommonStuff(FMLCommonSetupEvent event) {
        CapabilityManager.INSTANCE.register(IRegen.class, (Capability.IStorage)new RegenStorage(), RegenCap::new);
        ActingForwarder.init();
        GlobalEntityTypeAttributes.put((EntityType)((EntityType)REntities.TIMELORD.get()), (AttributeModifierMap)TimelordEntity.createAttributes().func_233813_a_());
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        Map skinMap = Minecraft.func_71410_x().func_175598_ae().getSkinMap();
        for (PlayerRenderer renderPlayer : skinMap.values()) {
            renderPlayer.func_177094_a((LayerRenderer)new HandLayer((IEntityRenderer)renderPlayer));
            renderPlayer.func_177094_a((LayerRenderer)new RenderRegenLayer((IEntityRenderer)renderPlayer));
        }
        Minecraft.func_71410_x().func_175598_ae().field_78729_o.forEach((entityType, entityRenderer) -> {
            if (entityRenderer instanceof BipedRenderer) {
                ((BipedRenderer)entityRenderer).func_177094_a((LayerRenderer)new RenderRegenLayer((IEntityRenderer)entityRenderer));
                ((BipedRenderer)entityRenderer).func_177094_a((LayerRenderer)new HandLayer((IEntityRenderer)entityRenderer));
            }
        });
        CommonSkin.doSetupOnThread();
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)REntities.ITEM_OVERRIDE_ENTITY_TYPE.get()), ItemOverrideRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)REntities.TIMELORD.get()), TimelordRenderer::new);
        RKeybinds.init();
        ItemModelsProperties.func_239418_a_((Item)((Item)RItems.FOB.get()), (ResourceLocation)new ResourceLocation("regen", "is_open"), (stack, p_call_2_, p_call_3_) -> {
            if (FobWatchItem.getStackTag(stack) == null || !FobWatchItem.getStackTag(stack).func_74764_b("is_open")) {
                return 0.0f;
            }
            return FobWatchItem.getOpen(stack);
        });
        ItemModelsProperties.func_239418_a_((Item)((Item)RItems.FOB.get()), (ResourceLocation)new ResourceLocation("regen", "is_gold"), (stack, p_call_2_, p_call_3_) -> {
            if (FobWatchItem.getStackTag(stack) == null || !FobWatchItem.getStackTag(stack).func_74764_b("is_gold")) {
                return 0.0f;
            }
            return FobWatchItem.getEngrave(stack);
        });
    }

    @SubscribeEvent
    public void onGatherData(GatherDataEvent e) {
        DataGenerator generator = e.getGenerator();
        generator.func_200390_a((IDataProvider)new EnglishLangGen(generator));
        generator.func_200390_a((IDataProvider)new RSoundsGen(generator));
        generator.func_200390_a((IDataProvider)new RRecipeGen(generator));
    }

    @SubscribeEvent
    public void onRegisterNewRegistries(RegistryEvent.NewRegistry e) {
        RSounds.SOUNDS.register(FMLJavaModLoadingContext.get().getModEventBus());
        RItems.ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        REntities.ENTITIES.register(FMLJavaModLoadingContext.get().getModEventBus());
    }
}

