/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regen.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import me.swirtzly.regen.Regeneration;
import me.swirtzly.regen.client.gui.BlankContainer;
import me.swirtzly.regen.common.regen.RegenCap;
import me.swirtzly.regen.common.regen.transitions.TransitionType;
import me.swirtzly.regen.network.NetworkDispatcher;
import me.swirtzly.regen.network.messages.ColorChangeMessage;
import me.swirtzly.regen.util.RConstants;
import me.swirtzly.regen.util.RegenUtil;
import me.swirtzly.regen.util.RenderHelp;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.gui.widget.Slider;

public class ColorScreen
extends ContainerScreen
implements Slider.ISlider {
    private static final ResourceLocation background = new ResourceLocation("regen", "textures/gui/customizer_background.png");
    private static Slider slidePrimaryRed;
    private static Slider slidePrimaryGreen;
    private static Slider slidePrimaryBlue;
    private static Slider slideSecondaryRed;
    private static Slider slideSecondaryGreen;
    private static Slider slideSecondaryBlue;
    private TextFieldWidget inputPrimaryColor;
    private TextFieldWidget inputSecondColor;
    private Vector3d initialPrimary;
    private Vector3d initialSecondary;

    public ColorScreen() {
        super((Container)new BlankContainer(), Minecraft.func_71410_x().field_71439_g.field_71071_by, (ITextComponent)new TranslationTextComponent("regeneration.gui.color_gui"));
        this.field_146999_f = 176;
        this.field_147000_g = 186;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        int cx = (this.field_230708_k_ - this.field_146999_f) / 2;
        int cy = (this.field_230709_l_ - this.field_147000_g) / 2;
        RegenCap.get((LivingEntity)this.getMinecraft().field_71439_g).ifPresent(data -> {
            this.initialPrimary = data.getPrimaryColors();
            this.initialSecondary = data.getSecondaryColors();
        });
        float primaryRed = (float)this.initialPrimary.field_72450_a;
        float primaryGreen = (float)this.initialPrimary.field_72448_b;
        float primaryBlue = (float)this.initialPrimary.field_72449_c;
        float secondaryRed = (float)this.initialSecondary.field_72450_a;
        float secondaryGreen = (float)this.initialSecondary.field_72448_b;
        float secondaryBlue = (float)this.initialSecondary.field_72449_c;
        int btnW = 60;
        int btnH = 18;
        int sliderW = 70;
        int sliderH = 20;
        this.func_230480_a_((Widget)new Button(cx + 25, cy + 125, 60, 18, (ITextComponent)new TranslationTextComponent("regeneration.gui.undo"), button -> {
            slidePrimaryRed.setValue(this.initialPrimary.field_72450_a);
            slidePrimaryGreen.setValue(this.initialPrimary.field_72448_b);
            slidePrimaryBlue.setValue(this.initialPrimary.field_72449_c);
            slideSecondaryRed.setValue(this.initialSecondary.field_72450_a);
            slideSecondaryGreen.setValue(this.initialSecondary.field_72448_b);
            slideSecondaryBlue.setValue(this.initialSecondary.field_72449_c);
        }));
        this.getMinecraft().field_195559_v.func_197967_a(true);
        this.inputPrimaryColor = new TextFieldWidget(this.field_230712_o_, cx + 25, cy + 21, 60, 18, this.inputPrimaryColor, (ITextComponent)new TranslationTextComponent("Input"));
        this.inputSecondColor = new TextFieldWidget(this.field_230712_o_, cx + 90, cy + 21, 60, 18, this.inputPrimaryColor, (ITextComponent)new TranslationTextComponent("Input"));
        this.func_230480_a_((Widget)this.inputPrimaryColor);
        this.func_230480_a_((Widget)this.inputSecondColor);
        this.func_230480_a_((Widget)new Button(cx + 25, cy + 145, 60, 18, (ITextComponent)new TranslationTextComponent("regeneration.gui.input_color"), button -> {
            float blue;
            float green;
            float red;
            Color color;
            String primaryColorText = this.inputPrimaryColor.func_146179_b();
            String secondColourText = this.inputSecondColor.func_146179_b();
            if (!primaryColorText.startsWith("#") && !primaryColorText.isEmpty()) {
                primaryColorText = "#" + primaryColorText;
                this.inputPrimaryColor.func_146180_a(primaryColorText);
            }
            if (!secondColourText.startsWith("#") && !secondColourText.isEmpty()) {
                secondColourText = "#" + secondColourText;
                this.inputSecondColor.func_146180_a(secondColourText);
            }
            try {
                color = Color.decode(primaryColorText);
                red = (float)color.getRed() / 255.0f;
                green = (float)color.getGreen() / 255.0f;
                blue = (float)color.getBlue() / 255.0f;
                slidePrimaryRed.setValue((double)red);
                slidePrimaryGreen.setValue((double)green);
                slidePrimaryBlue.setValue((double)blue);
                this.onChangeSliderValue(null);
            }
            catch (Exception e) {
                Regeneration.LOG.error(primaryColorText + ", is not a valid Color! [Primary Colour]");
            }
            try {
                color = Color.decode(secondColourText);
                red = (float)color.getRed() / 255.0f;
                green = (float)color.getGreen() / 255.0f;
                blue = (float)color.getBlue() / 255.0f;
                slideSecondaryRed.setValue((double)red);
                slideSecondaryGreen.setValue((double)green);
                slideSecondaryBlue.setValue((double)blue);
                this.onChangeSliderValue(null);
            }
            catch (Exception e) {
                Regeneration.LOG.error(secondColourText + ", is not a valid Color! [Secondary Colour]");
            }
        }));
        this.func_230480_a_((Widget)new Button(cx + 90, cy + 145, 60, 18, (ITextComponent)new TranslationTextComponent("regeneration.gui.close"), button -> Minecraft.func_71410_x().func_147108_a(null)));
        this.func_230480_a_((Widget)new Button(cx + 90, cy + 125, 60, 18, (ITextComponent)new TranslationTextComponent("regeneration.gui.default"), button -> {
            RegenCap.get((LivingEntity)Minecraft.func_71410_x().field_71439_g).ifPresent(data -> {
                TransitionType regenType = data.getTransitionType().get();
                slidePrimaryRed.setValue(regenType.getDefaultPrimaryColor().field_72450_a);
                slidePrimaryGreen.setValue(regenType.getDefaultPrimaryColor().field_72448_b);
                slidePrimaryBlue.setValue(regenType.getDefaultPrimaryColor().field_72449_c);
                slideSecondaryRed.setValue(regenType.getDefaultSecondaryColor().field_72450_a);
                slideSecondaryGreen.setValue(regenType.getDefaultSecondaryColor().field_72448_b);
                slideSecondaryBlue.setValue(regenType.getDefaultSecondaryColor().field_72449_c);
            });
            this.onChangeSliderValue(null);
        }));
        slidePrimaryRed = new Slider(cx + 10, cy + 65, 70, 20, (ITextComponent)new TranslationTextComponent("regeneration.gui.red"), StringTextComponent.field_240750_d_, 0.0, 1.0, (double)primaryRed, true, true, button -> {}, (Slider.ISlider)this);
        slidePrimaryGreen = new Slider(cx + 10, cy + 84, 70, 20, (ITextComponent)new TranslationTextComponent("regeneration.gui.green"), StringTextComponent.field_240750_d_, 0.0, 1.0, (double)primaryGreen, true, true, p_onPress_1_ -> {}, (Slider.ISlider)this);
        slidePrimaryBlue = new Slider(cx + 10, cy + 103, 70, 20, (ITextComponent)new TranslationTextComponent("regeneration.gui.blue"), StringTextComponent.field_240750_d_, 0.0, 1.0, (double)primaryBlue, true, true, p_onPress_1_ -> {}, (Slider.ISlider)this);
        slideSecondaryRed = new Slider(cx + 96, cy + 65, 70, 20, (ITextComponent)new TranslationTextComponent("regeneration.gui.red"), StringTextComponent.field_240750_d_, 0.0, 1.0, (double)secondaryRed, true, true, p_onPress_1_ -> {}, (Slider.ISlider)this);
        slideSecondaryGreen = new Slider(cx + 96, cy + 84, 70, 20, (ITextComponent)new TranslationTextComponent("regeneration.gui.green"), StringTextComponent.field_240750_d_, 0.0, 1.0, (double)secondaryGreen, true, true, p_onPress_1_ -> {}, (Slider.ISlider)this);
        slideSecondaryBlue = new Slider(cx + 96, cy + 103, 70, 20, (ITextComponent)new TranslationTextComponent("regeneration.gui.blue"), StringTextComponent.field_240750_d_, 0.0, 1.0, (double)secondaryBlue, true, true, p_onPress_1_ -> {}, (Slider.ISlider)this);
        this.func_230480_a_((Widget)slidePrimaryRed);
        this.func_230480_a_((Widget)slidePrimaryGreen);
        this.func_230480_a_((Widget)slidePrimaryBlue);
        this.func_230480_a_((Widget)slideSecondaryRed);
        this.func_230480_a_((Widget)slideSecondaryGreen);
        this.func_230480_a_((Widget)slideSecondaryBlue);
        this.func_230480_a_((Widget)this.inputPrimaryColor);
        this.func_230480_a_((Widget)this.inputSecondColor);
        this.inputPrimaryColor.func_146180_a(RegenUtil.colorToHex(new Color((float)slidePrimaryRed.getValue(), (float)slidePrimaryGreen.getValue(), (float)slidePrimaryBlue.getValue())));
        this.inputSecondColor.func_146180_a(RegenUtil.colorToHex(new Color((float)slideSecondaryRed.getValue(), (float)slideSecondaryGreen.getValue(), (float)slideSecondaryBlue.getValue())));
    }

    protected void func_230451_b_(MatrixStack p_230451_1_, int p_230451_2_, int p_230451_3_) {
        this.field_230712_o_.func_243248_b(p_230451_1_, this.field_230704_d_, (float)this.field_238742_p_, (float)this.field_238743_q_, 0x404040);
    }

    public void onChangeSliderValue(Slider slider) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74776_a(RConstants.PRIMARY_RED, (float)slidePrimaryRed.getValue());
        nbt.func_74776_a(RConstants.PRIMARY_GREEN, (float)slidePrimaryGreen.getValue());
        nbt.func_74776_a(RConstants.PRIMARY_BLUE, (float)slidePrimaryBlue.getValue());
        nbt.func_74776_a(RConstants.SECONDARY_RED, (float)slideSecondaryRed.getValue());
        nbt.func_74776_a(RConstants.SECONDARY_GREEN, (float)slideSecondaryGreen.getValue());
        nbt.func_74776_a(RConstants.SECONDARY_BLUE, (float)slideSecondaryBlue.getValue());
        NetworkDispatcher.NETWORK_CHANNEL.sendToServer((Object)new ColorChangeMessage(nbt));
        this.inputPrimaryColor.func_146180_a(RegenUtil.colorToHex(new Color((float)slidePrimaryRed.getValue(), (float)slidePrimaryGreen.getValue(), (float)slidePrimaryBlue.getValue())));
        this.inputSecondColor.func_146180_a(RegenUtil.colorToHex(new Color((float)slideSecondaryRed.getValue(), (float)slideSecondaryGreen.getValue(), (float)slideSecondaryBlue.getValue())));
    }

    protected void func_230450_a_(MatrixStack p_230450_1_, float p_230450_2_, int p_230450_3_, int p_230450_4_) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.field_230706_i_ != null) {
            this.field_230706_i_.func_110434_K().func_110577_a(background);
            int i = (this.field_230708_k_ - this.field_146999_f) / 2;
            int j = (this.field_230709_l_ - this.field_147000_g) / 2;
            this.func_238474_b_(p_230450_1_, i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        }
        int cx = (this.field_230708_k_ - this.field_146999_f) / 2;
        int cy = (this.field_230709_l_ - this.field_147000_g) / 2;
        RenderHelp.drawRect(cx + 10, cy + 44, cx + 81, cy + 61, 0.1f, 0.1f, 0.1f, 1.0f);
        RenderHelp.drawRect(cx + 11, cy + 45, cx + 80, cy + 60, (float)slidePrimaryRed.getValue(), (float)slidePrimaryGreen.getValue(), (float)slidePrimaryBlue.getValue(), 1.0f);
        RenderHelp.drawRect(cx + 95, cy + 44, cx + 166, cy + 61, 0.1f, 0.1f, 0.1f, 1.0f);
        RenderHelp.drawRect(cx + 96, cy + 45, cx + 165, cy + 60, (float)slideSecondaryRed.getValue(), (float)slideSecondaryGreen.getValue(), (float)slideSecondaryBlue.getValue(), 1.0f);
        RegenCap.get((LivingEntity)this.getMinecraft().field_71439_g).ifPresent(cap -> {
            String str = new TranslationTextComponent("regeneration.gui.primary").getString();
            int length = this.getMinecraft().field_71466_p.func_78256_a(str);
            this.field_230712_o_.func_243248_b(p_230450_1_, (ITextComponent)new StringTextComponent(str), (float)cx + 45.0f - (float)(length / 2), (float)(cy + 49), 0x404040);
            str = new TranslationTextComponent("regeneration.gui.secondary").getString();
            length = this.field_230712_o_.func_78256_a(str);
            this.field_230712_o_.func_243248_b(p_230450_1_, (ITextComponent)new StringTextComponent(str), (float)(cx + 131 - length / 2), (float)(cy + 49), 0x404040);
        });
    }
}

