/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regen.client.skin;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import me.swirtzly.regen.Regeneration;
import me.swirtzly.regen.client.skin.ClientSkin;
import me.swirtzly.regen.client.skin.SkinHandler;
import me.swirtzly.regen.config.RegenConfig;
import me.swirtzly.regen.util.PlayerUtil;
import me.swirtzly.regen.util.RegenUtil;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;

public class CommonSkin {
    public static final File SKIN_DIRECTORY = new File((String)RegenConfig.COMMON.skinDir.get() + "/Regeneration Data/skins/");
    public static final File SKIN_DIRECTORY_STEVE = new File(SKIN_DIRECTORY, "/steve");
    public static final File SKIN_DIRECTORY_ALEX = new File(SKIN_DIRECTORY, "/alex");

    public static ResourceLocation fileTotexture(File file) {
        NativeImage nativeImage = null;
        try {
            nativeImage = NativeImage.func_195713_a((InputStream)new FileInputStream(file));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return SkinHandler.loadImage(nativeImage);
    }

    public static File chooseRandomSkin(Random rand, boolean isAlex) {
        File skins = isAlex ? SKIN_DIRECTORY_ALEX : SKIN_DIRECTORY_STEVE;
        Collection folderFiles = FileUtils.listFiles((File)skins, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
        folderFiles.removeIf(file -> !file.getName().endsWith(".png") || !CommonSkin.isActuallyAImage(file));
        return (File)folderFiles.toArray()[rand.nextInt(folderFiles.size())];
    }

    public static boolean isActuallyAImage(File file) {
        String mimetype = null;
        try {
            mimetype = Files.probeContentType(file.toPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return mimetype != null && mimetype.split("/")[0].equals("image");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String> getSkins(String downloadUrl) throws IOException {
        ArrayList<String> skins = new ArrayList<String>();
        try (BufferedReader br = null;){
            String line;
            URL url = new URL(downloadUrl);
            URLConnection uc = url.openConnection();
            uc.connect();
            uc = url.openConnection();
            uc.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.75 Safari/537.36");
            br = new BufferedReader(new InputStreamReader(uc.getInputStream()));
            while ((line = br.readLine()) != null) {
                if (!line.contains("<a href=\"/skin/")) continue;
                String downloadLine = line.replaceAll("<a href=\"/skin/", "").replaceAll("\">", "").replaceAll("        ", "");
                skins.add("https://namemc.com/texture/" + downloadLine + ".png");
            }
        }
        return skins;
    }

    public static void createDefaultFolders() throws IOException {
        if (!SKIN_DIRECTORY.exists()) {
            FileUtils.forceMkdir((File)SKIN_DIRECTORY);
        }
        if (!SKIN_DIRECTORY_ALEX.exists()) {
            FileUtils.forceMkdir((File)SKIN_DIRECTORY_ALEX);
        }
        if (!SKIN_DIRECTORY_STEVE.exists()) {
            FileUtils.forceMkdir((File)SKIN_DIRECTORY_STEVE);
        }
    }

    public static void downloadSkins(URL url, String filename, File alexDir, File steveDir) throws IOException {
        File file;
        URLConnection uc = url.openConnection();
        uc.connect();
        uc = url.openConnection();
        uc.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.75 Safari/537.36");
        Regeneration.LOG.warn("Downloading Skin from: {}", (Object)url.toString());
        BufferedImage img = ImageIO.read(uc.getInputStream());
        File file2 = file = CommonSkin.isAlexSkin(img) ? alexDir : steveDir;
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!steveDir.exists()) {
            steveDir.mkdirs();
        }
        if (!alexDir.exists()) {
            alexDir.mkdirs();
        }
        Regeneration.LOG.warn("Saving Skin to: {}", (Object)file.getPath());
        ImageIO.write((RenderedImage)img, "png", new File(file, filename + ".png"));
    }

    public static void handleDownloads() throws IOException {
        if (!((Boolean)RegenConfig.SKIN.downloadInteralSkins.get()).booleanValue() || !RegenUtil.doesHaveInternet()) {
            return;
        }
        File drWhoDir = new File(SKIN_DIRECTORY_ALEX + "/doctor_who");
        long attr = drWhoDir.lastModified();
        if (System.currentTimeMillis() - attr >= 86400000L || Objects.requireNonNull(drWhoDir.list()).length == 0) {
            String[] links;
            Regeneration.LOG.info("Re-Downloading Internal Skins");
            String PACKS_URL = "https://raw.githubusercontent.com/Swirtzly/Regeneration/skins/index.json";
            for (String link : links = (String[])Regeneration.GSON.fromJson(RegenUtil.getJsonFromURL(PACKS_URL), String[].class)) {
                CommonSkin.unzipSkinPack(link);
            }
        }
    }

    public static boolean isAlexSkin(BufferedImage image) {
        return CommonSkin.hasAlpha(55, 20, image) && CommonSkin.hasAlpha(55, 21, image) && CommonSkin.hasAlpha(55, 22, image) && CommonSkin.hasAlpha(55, 23, image) && CommonSkin.hasAlpha(55, 24, image) && CommonSkin.hasAlpha(55, 25, image) && CommonSkin.hasAlpha(55, 26, image) && CommonSkin.hasAlpha(55, 27, image) && CommonSkin.hasAlpha(55, 28, image) && CommonSkin.hasAlpha(55, 29, image) && CommonSkin.hasAlpha(55, 30, image) && CommonSkin.hasAlpha(55, 31, image) && CommonSkin.hasAlpha(54, 20, image) && CommonSkin.hasAlpha(54, 21, image) && CommonSkin.hasAlpha(54, 22, image) && CommonSkin.hasAlpha(54, 23, image) && CommonSkin.hasAlpha(54, 24, image) && CommonSkin.hasAlpha(54, 25, image) && CommonSkin.hasAlpha(54, 26, image) && CommonSkin.hasAlpha(54, 27, image) && CommonSkin.hasAlpha(54, 28, image) && CommonSkin.hasAlpha(54, 29, image) && CommonSkin.hasAlpha(54, 30, image) && CommonSkin.hasAlpha(54, 31, image) || CommonSkin.hasAlpha(46, 52, image) && CommonSkin.hasAlpha(46, 53, image) && CommonSkin.hasAlpha(46, 54, image) && CommonSkin.hasAlpha(46, 54, image) && CommonSkin.hasAlpha(46, 55, image) && CommonSkin.hasAlpha(46, 56, image) && CommonSkin.hasAlpha(46, 57, image) && CommonSkin.hasAlpha(46, 58, image) && CommonSkin.hasAlpha(46, 59, image) && CommonSkin.hasAlpha(46, 60, image) && CommonSkin.hasAlpha(46, 61, image) && CommonSkin.hasAlpha(46, 63, image) && CommonSkin.hasAlpha(46, 53, image);
    }

    public static boolean hasAlpha(int x, int y, BufferedImage image) {
        int pixel = image.getRGB(x, y);
        return pixel >> 24 == 0 || (pixel & 0xFFFFFF) == 0;
    }

    public static void doSetupOnThread() {
        AtomicBoolean notDownloaded = new AtomicBoolean(true);
        new Thread(() -> {
            while (notDownloaded.get()) {
                try {
                    CommonSkin.createDefaultFolders();
                    CommonSkin.handleDownloads();
                    ClientSkin.downloadTrendingSkins();
                    ClientSkin.downloadPreviousSkins();
                    notDownloaded.set(false);
                }
                catch (Exception e) {
                    Regeneration.LOG.error("Regeneration Mod: Failed to download skins! Check your internet connection and ensure you are playing in online mode!");
                    Regeneration.LOG.error(e.getMessage());
                }
            }
        }, "regen Download Daemon").start();
    }

    public static void unzipSkinPack(String url) throws IOException {
        File tempZip = new File(SKIN_DIRECTORY + "/temp/" + System.currentTimeMillis() + ".zip");
        Regeneration.LOG.info("Downloading " + url + " to " + tempZip.getAbsolutePath());
        FileUtils.copyURLToFile((URL)new URL(url), (File)tempZip);
        try (ZipFile file = new ZipFile(tempZip);){
            FileSystem fileSystem = FileSystems.getDefault();
            Enumeration<? extends ZipEntry> entries = file.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) {
                    Files.createDirectories(fileSystem.getPath(SKIN_DIRECTORY + File.separator + entry.getName(), new String[0]), new FileAttribute[0]);
                    continue;
                }
                InputStream is = file.getInputStream(entry);
                BufferedInputStream bis = new BufferedInputStream(is);
                String uncompressedFileName = SKIN_DIRECTORY + File.separator + entry.getName();
                Path uncompressedFilePath = fileSystem.getPath(uncompressedFileName, new String[0]);
                Regeneration.LOG.info("Extracting file: " + uncompressedFilePath);
                File temp = uncompressedFilePath.toFile();
                if (temp.exists()) {
                    Regeneration.LOG.info("Recreating: " + uncompressedFilePath);
                    temp.delete();
                }
                Files.createFile(uncompressedFilePath, new FileAttribute[0]);
                FileOutputStream fileOutput = new FileOutputStream(uncompressedFileName);
                while (bis.available() > 0) {
                    fileOutput.write(bis.read());
                }
                fileOutput.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (tempZip.exists()) {
            FileUtils.forceDelete((File)tempZip.getParentFile());
        }
    }

    public static List<File> listAllSkins(PlayerUtil.SkinType choices) {
        ArrayList<File> resultList = new ArrayList<File>();
        File directory = null;
        switch (choices) {
            case EITHER: {
                directory = SKIN_DIRECTORY;
                break;
            }
            case ALEX: {
                directory = SKIN_DIRECTORY_ALEX;
                break;
            }
            case STEVE: {
                directory = SKIN_DIRECTORY_STEVE;
            }
        }
        try {
            Files.find(Paths.get(directory.toString(), new String[0]), Integer.MAX_VALUE, (filePath, fileAttr) -> fileAttr.isRegularFile(), new FileVisitOption[0]).forEach(file -> resultList.add(file.toFile()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return resultList;
    }
}

