/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regen.client.skin;

import com.google.common.base.MoreObjects;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.swirtzly.regen.common.regen.RegenCap;
import me.swirtzly.regen.network.NetworkDispatcher;
import me.swirtzly.regen.network.messages.SkinMessage;
import me.swirtzly.regen.util.RegenUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;

public class SkinHandler {
    public static final HashMap<UUID, ResourceLocation> PLAYER_SKINS = new HashMap();

    public static void tick(AbstractClientPlayerEntity playerEntity) {
        RegenCap.get((LivingEntity)playerEntity).ifPresent(iRegen -> {
            NativeImage skinImage;
            boolean forceUpdate = false;
            byte[] skin = iRegen.getSkin();
            UUID uuid = playerEntity.func_110124_au();
            boolean validSkin = iRegen.isSkinValidForUse();
            if ((validSkin && !SkinHandler.hasPlayerSkin(uuid) || iRegen.getTicksAnimating() >= 140) && (skinImage = SkinHandler.genSkinNative(skin)) != null) {
                SkinHandler.addPlayerSkin(playerEntity.func_110124_au(), SkinHandler.loadImage(skinImage));
                forceUpdate = true;
            }
            if (!validSkin) {
                SkinHandler.removePlayerSkin(playerEntity.func_110124_au());
                forceUpdate = true;
            }
            if (forceUpdate || playerEntity.field_70173_aa < 20) {
                ResourceLocation skinTexture = SkinHandler.getSkinToUse(playerEntity);
                SkinHandler.setPlayerSkin(playerEntity, skinTexture);
            }
            boolean isAlex = false;
            if (iRegen.isSkinValidForUse()) {
                isAlex = iRegen.isAlexSkinCurrently();
            } else {
                playerEntity.field_175157_a.func_178841_j();
                isAlex = playerEntity.field_175157_a.func_178851_f().contentEquals("slim");
            }
            SkinHandler.setPlayerSkinType(playerEntity, isAlex);
        });
    }

    public static void setPlayerSkinType(AbstractClientPlayerEntity player, boolean isAlex) {
        NetworkPlayerInfo playerInfo = player.field_175157_a;
        if (playerInfo == null) {
            return;
        }
        playerInfo.field_178863_g = isAlex ? "slim" : "default";
    }

    public static void sendResetMessage() {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            player.field_175157_a.func_178841_j();
            boolean isAlex = player.field_175157_a.func_178851_f().equals("slim");
            NetworkDispatcher.NETWORK_CHANNEL.sendToServer((Object)new SkinMessage(new byte[0], isAlex));
        }
    }

    public static ResourceLocation loadImage(NativeImage nativeImage) {
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        return textureManager.func_110578_a("player_", new DynamicTexture(nativeImage));
    }

    public static NativeImage genSkinNative(byte[] skinArray) {
        try {
            return NativeImage.func_195713_a((InputStream)new ByteArrayInputStream(skinArray));
        }
        catch (IOException e) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)e, (String)"Regeneration Skin Creation");
            crashreport = RegenUtil.crashReport(crashreport);
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Skin Creation");
            crashreportcategory.func_71507_a("Skin bytes", (Object)Arrays.toString(skinArray));
            throw new ReportedException(crashreport);
        }
    }

    public static void setPlayerSkin(AbstractClientPlayerEntity player, ResourceLocation texture) {
        if (player.func_110306_p().equals((Object)texture)) {
            return;
        }
        NetworkPlayerInfo playerInfo = player.field_175157_a;
        if (playerInfo == null) {
            return;
        }
        Map playerTextures = playerInfo.field_187107_a;
        playerTextures.put(MinecraftProfileTexture.Type.SKIN, texture);
        if (texture == null) {
            playerInfo.field_178864_d = false;
        }
    }

    public static boolean hasPlayerSkin(UUID uuid) {
        return PLAYER_SKINS.containsKey(uuid);
    }

    public static void addPlayerSkin(UUID uuid, ResourceLocation texture) {
        PLAYER_SKINS.put(uuid, texture);
    }

    public static void removePlayerSkin(UUID uuid) {
        PLAYER_SKINS.remove(uuid);
    }

    public static ResourceLocation getSkinToUse(AbstractClientPlayerEntity playerEntity) {
        if (PLAYER_SKINS.containsKey(playerEntity.func_146103_bH().getId())) {
            return PLAYER_SKINS.get(playerEntity.func_146103_bH().getId());
        }
        NetworkPlayerInfo info = playerEntity.field_175157_a;
        info.field_178864_d = false;
        info.func_178841_j();
        return (ResourceLocation)MoreObjects.firstNonNull(info.field_187107_a.get(MinecraftProfileTexture.Type.SKIN), (Object)DefaultPlayerSkin.func_177334_a((UUID)info.field_178867_a.getId()));
    }
}

