/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regen.common.entities;

import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.swirtzly.regen.common.item.SolidItem;
import me.swirtzly.regen.common.objects.REntities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class OverrideEntity
extends Entity {
    private static final DataParameter<ItemStack> ITEM = EntityDataManager.func_187226_a(OverrideEntity.class, (IDataSerializer)DataSerializers.field_187196_f);
    private UUID thrower;
    private UUID owner;
    private int health = 5;

    public OverrideEntity(EntityType<? extends OverrideEntity> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    public OverrideEntity(World world) {
        this((EntityType<? extends OverrideEntity>)((EntityType)REntities.ITEM_OVERRIDE_ENTITY_TYPE.get()), world);
    }

    public OverrideEntity(World worldIn, double x, double y, double z) {
        this((EntityType<? extends OverrideEntity>)((EntityType)REntities.ITEM_OVERRIDE_ENTITY_TYPE.get()), worldIn);
        this.func_70107_b(x, y, z);
        this.field_70177_z = this.field_70146_Z.nextFloat() * 360.0f;
        this.func_213293_j(this.field_70146_Z.nextDouble() * 0.2 - 0.1, 0.2, this.field_70146_Z.nextDouble() * 0.2 - 0.1);
    }

    public OverrideEntity(World worldIn, double x, double y, double z, ItemStack stack) {
        this(worldIn, x, y, z);
        this.setItem(stack);
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public void func_70088_a() {
        this.func_184212_Q().func_187214_a(ITEM, (Object)ItemStack.field_190927_a);
    }

    public ITextComponent func_200200_C_() {
        ITextComponent itextcomponent = this.func_200201_e();
        return itextcomponent != null ? itextcomponent : new TranslationTextComponent(this.getItem().func_77977_a());
    }

    public EntitySize func_213305_a(Pose poseIn) {
        Item item = this.getItem().func_77973_b();
        if (item instanceof SolidItem) {
            EntitySize size = ((SolidItem)item).getEntitySize(this, this.getItem());
            return size != null ? size : super.func_213305_a(poseIn);
        }
        return super.func_213305_a(poseIn);
    }

    public ActionResultType func_184199_a(PlayerEntity player, Vector3d vec, Hand hand) {
        if (player.func_184586_b(hand).func_190926_b() && this.func_70089_S()) {
            player.func_184611_a(hand, this.getItem());
            this.func_70106_y();
            return ActionResultType.SUCCESS;
        }
        return super.func_184199_a(player, vec, hand);
    }

    public void func_70071_h_() {
        if (this.getItem().func_77978_p() == null || this.getItem().func_77978_p().isEmpty() || !this.getItem().func_190926_b() && !this.getItem().func_77978_p().func_74764_b("live")) {
            this.func_70106_y();
            return;
        }
        if (this.getItem().func_77973_b() instanceof SolidItem && ((SolidItem)this.getItem().func_77973_b()).onSolidEntityItemUpdate(this)) {
            return;
        }
        if (this.getItem().func_190926_b()) {
            this.func_70106_y();
        } else {
            double d0;
            int i;
            super.func_70071_h_();
            this.field_70169_q = this.func_226277_ct_();
            this.field_70167_r = this.func_226278_cu_();
            this.field_70166_s = this.func_226281_cx_();
            Vector3d vec3d = this.func_213322_ci();
            if (this.func_208600_a((ITag)FluidTags.field_206959_a)) {
                this.applyFloatMotion();
            } else if (!this.func_189652_ae()) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.04, 0.0));
            }
            if (this.field_70170_p.field_72995_K) {
                this.field_70145_X = false;
            } else {
                boolean bl = this.field_70145_X = !this.field_70170_p.func_226668_i_((Entity)this);
                if (this.field_70145_X) {
                    this.func_213282_i(this.func_226277_ct_(), (this.func_174813_aQ().field_72338_b + this.func_174813_aQ().field_72337_e) / 2.0, this.func_226281_cx_());
                }
            }
            if (!this.field_70122_E || OverrideEntity.func_213296_b((Vector3d)this.func_213322_ci()) > (double)1.0E-5f || (this.field_70173_aa + this.func_145782_y()) % 4 == 0) {
                this.func_213315_a(MoverType.SELF, this.func_213322_ci());
                float f = 0.98f;
                if (this.field_70122_E) {
                    BlockPos pos = new BlockPos(this.func_226277_ct_(), this.func_174813_aQ().field_72338_b - 1.0, this.func_226281_cx_());
                    f = this.field_70170_p.func_180495_p(pos).getSlipperiness((IWorldReader)this.field_70170_p, pos, (Entity)this) * 0.98f;
                }
                this.func_213317_d(this.func_213322_ci().func_216372_d((double)f, 0.98, (double)f));
                if (this.field_70122_E) {
                    this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, -0.5, 1.0));
                }
            }
            boolean flag = MathHelper.func_76128_c((double)this.field_70169_q) != MathHelper.func_76128_c((double)this.func_226277_ct_()) || MathHelper.func_76128_c((double)this.field_70167_r) != MathHelper.func_76128_c((double)this.func_226278_cu_()) || MathHelper.func_76128_c((double)this.field_70166_s) != MathHelper.func_76128_c((double)this.func_226281_cx_());
            int n = i = flag ? 2 : 40;
            if (this.field_70173_aa % i == 0 && this.field_70170_p.func_204610_c(new BlockPos(this.func_213303_ch())).func_206884_a((ITag)FluidTags.field_206960_b)) {
                this.func_213293_j((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f, 0.2f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
                this.func_184185_a(SoundEvents.field_187658_bx, 0.4f, 2.0f + this.field_70146_Z.nextFloat() * 0.4f);
            }
            this.field_70160_al |= this.func_233566_aG_();
            if (!this.field_70170_p.field_72995_K && (d0 = this.func_213322_ci().func_178788_d(vec3d).func_189985_c()) > 0.01) {
                this.field_70160_al = true;
            }
            if (this.getItem().func_190926_b()) {
                this.func_70106_y();
            }
        }
    }

    private void applyFloatMotion() {
        Vector3d vec3d = this.func_213322_ci();
        this.func_213293_j(vec3d.field_72450_a * (double)0.99f, vec3d.field_72448_b + (double)(vec3d.field_72448_b < (double)0.06f ? 5.0E-4f : 0.0f), vec3d.field_72449_c * (double)0.99f);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.field_70170_p.field_72995_K || this.func_70089_S()) {
            return false;
        }
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.getItem().func_190926_b() && this.getItem().func_77973_b() == Items.field_151156_bN && source.func_94541_c()) {
            return false;
        }
        this.func_70018_K();
        this.health = (int)((float)this.health - amount);
        if (this.health <= 0) {
            this.func_70106_y();
        }
        return false;
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.health = compound.func_74765_d("Health");
        if (compound.func_150297_b("Owner", 10)) {
            this.owner = NBTUtil.func_186860_b((INBT)compound.func_74775_l("Owner"));
        }
        if (compound.func_150297_b("Thrower", 10)) {
            this.thrower = NBTUtil.func_186860_b((INBT)compound.func_74775_l("Thrower"));
        }
        CompoundNBT compoundnbt = compound.func_74775_l("Item");
        this.setItem(ItemStack.func_199557_a((CompoundNBT)compoundnbt));
        if (this.getItem().func_190926_b()) {
            this.func_70106_y();
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74777_a("Health", (short)this.health);
        if (this.getThrowerId() != null) {
            compound.func_186854_a("Thrower", this.getThrowerId());
        }
        if (this.getOwnerId() != null) {
            compound.func_186854_a("Owner", this.getOwnerId());
        }
        if (!this.getItem().func_190926_b()) {
            compound.func_218657_a("Item", (INBT)this.getItem().func_77955_b(new CompoundNBT()));
        }
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean func_70075_an() {
        return false;
    }

    public boolean func_70067_L() {
        return true;
    }

    public ItemStack getItem() {
        return (ItemStack)this.func_184212_Q().func_187225_a(ITEM);
    }

    public void setItem(ItemStack stack) {
        this.func_184212_Q().func_187227_b(ITEM, (Object)stack);
    }

    @Nullable
    public UUID getOwnerId() {
        return this.owner;
    }

    public void setOwnerId(@Nullable UUID ownerUUID) {
        this.owner = ownerUUID;
    }

    @Nullable
    public UUID getThrowerId() {
        return this.thrower;
    }

    public void setThrowerId(@Nullable UUID throwerUUID) {
        this.thrower = throwerUUID;
    }
}

