/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regen.common.entities;

import java.io.File;
import me.swirtzly.regen.client.skin.CommonSkin;
import me.swirtzly.regen.common.objects.REntities;
import me.swirtzly.regen.common.regen.IRegen;
import me.swirtzly.regen.common.regen.RegenCap;
import me.swirtzly.regen.common.regen.state.RegenStates;
import me.swirtzly.regen.common.regen.transitions.TransitionTypes;
import me.swirtzly.regen.util.RConstants;
import me.swirtzly.regen.util.RegenUtil;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public class TimelordEntity
extends CreatureEntity {
    private static final DataParameter<String> TYPE = EntityDataManager.func_187226_a(TimelordEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Boolean> SWINGING_ARMS = EntityDataManager.func_187226_a(TimelordEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private final SwimmerPathNavigator waterNavigator;
    private final GroundPathNavigator groundNavigator;

    public TimelordEntity(World world) {
        this((EntityType<TimelordEntity>)((EntityType)REntities.TIMELORD.get()), world);
    }

    public TimelordEntity(EntityType<TimelordEntity> entityEntityType, World world) {
        super(entityEntityType, world);
        this.waterNavigator = new SwimmerPathNavigator((MobEntity)this, world);
        this.groundNavigator = new GroundPathNavigator((MobEntity)this, world);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233819_b_, 35.0).func_233815_a_(Attributes.field_233821_d_, (double)0.23f).func_233815_a_(Attributes.field_233823_f_, 3.0).func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233826_i_, 2.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(TYPE, (Object)(this.field_70146_Z.nextBoolean() ? TimelordType.COUNCIL.name() : TimelordType.GUARD.name()));
        this.func_184212_Q().func_187214_a(SWINGING_ARMS, (Object)false);
    }

    public void func_205343_av() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70613_aW() && this.func_70090_H()) {
                this.field_70699_by = this.waterNavigator;
                this.func_204711_a(true);
            } else {
                this.field_70699_by = this.groundNavigator;
                this.func_204711_a(false);
            }
        }
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, (double)1.2f, true));
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.applyEntityAI();
    }

    protected void applyEntityAI() {
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[]{TimelordEntity.class}));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, ZombieEntity.class, false));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, SkeletonEntity.class, false));
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        if (!worldIn.func_201670_d()) {
            RegenCap.get((LivingEntity)this).ifPresent(data -> {
                data.addRegens(worldIn.func_201674_k().nextInt(12));
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_74776_a(RConstants.PRIMARY_RED, (float)this.field_70146_Z.nextInt(255) / 255.0f);
                nbt.func_74776_a(RConstants.PRIMARY_GREEN, (float)this.field_70146_Z.nextInt(255) / 255.0f);
                nbt.func_74776_a(RConstants.PRIMARY_BLUE, (float)this.field_70146_Z.nextInt(255) / 255.0f);
                nbt.func_74776_a(RConstants.SECONDARY_RED, (float)this.field_70146_Z.nextInt(255) / 255.0f);
                nbt.func_74776_a(RConstants.SECONDARY_GREEN, (float)this.field_70146_Z.nextInt(255) / 255.0f);
                nbt.func_74776_a(RConstants.SECONDARY_BLUE, (float)this.field_70146_Z.nextInt(255) / 255.0f);
                data.readStyle(nbt);
                data.setTransitionType(TransitionTypes.getRandomType());
                this.initSkin((IRegen)data);
            });
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void initSkin(IRegen data) {
        File file = CommonSkin.chooseRandomSkin(this.field_70170_p.field_73012_v, this.field_70146_Z.nextBoolean());
        data.setSkin(RegenUtil.fileToBytes(file));
        data.setAlexSkin(true);
        data.syncToClients(null);
    }

    public TimelordType getTimelordType() {
        String type = (String)this.func_184212_Q().func_187225_a(TYPE);
        for (TimelordType value : TimelordType.values()) {
            if (!value.name().equals(type)) continue;
            return value;
        }
        return TimelordType.GUARD;
    }

    public void setTimelordType(TimelordType type) {
        this.func_184212_Q().func_187227_b(TYPE, (Object)type.name());
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        RegenCap.get((LivingEntity)this).ifPresent(data -> {
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70173_aa < 20) {
                    data.syncToClients(null);
                }
                if (data.getCurrentState() == RegenStates.REGENERATING) {
                    if (data.getTicksAnimating() == 100) {
                        this.initSkin((IRegen)data);
                    }
                    this.func_94061_f(true);
                    this.func_184224_h(true);
                } else {
                    this.func_94061_f(false);
                    this.func_184224_h(false);
                }
            }
        });
    }

    public void func_174812_G() {
        this.func_70106_y();
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74778_a("timelord_type", this.getTimelordType().name());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("timelord_type")) {
            this.setTimelordType(TimelordType.valueOf(compound.func_74779_i("timelord_type")));
        }
    }

    public static enum TimelordType {
        COUNCIL("timelord"),
        GUARD("guards");

        private final String name;

        private TimelordType(String guard) {
            this.name = guard;
        }

        public String getName() {
            return this.name;
        }
    }
}

