/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regen.common.item;

import me.swirtzly.regen.Regeneration;
import me.swirtzly.regen.common.entities.OverrideEntity;
import me.swirtzly.regen.common.item.SolidItem;
import me.swirtzly.regen.common.objects.RItems;
import me.swirtzly.regen.common.objects.RSounds;
import me.swirtzly.regen.common.regen.IRegen;
import me.swirtzly.regen.common.regen.RegenCap;
import me.swirtzly.regen.common.regen.state.RegenStates;
import me.swirtzly.regen.config.RegenConfig;
import me.swirtzly.regen.util.ClientUtil;
import me.swirtzly.regen.util.PlayerUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class FobWatchItem
extends SolidItem {
    public FobWatchItem() {
        super(new Item.Properties().setNoRepair().func_200916_a(RItems.MAIN).func_200917_a(1));
    }

    public static CompoundNBT getStackTag(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new CompoundNBT());
            stack.func_77978_p().func_74768_a("open", 0);
            stack.func_77978_p().func_74768_a("engrave", field_77697_d.nextInt(2));
        }
        return stack.func_77978_p();
    }

    public static int getEngrave(ItemStack stack) {
        return FobWatchItem.getStackTag(stack).func_74762_e("engrave");
    }

    public static void setEngrave(ItemStack stack, int engrave) {
        FobWatchItem.getStackTag(stack).func_74768_a("engrave", engrave);
    }

    public static int getOpen(ItemStack stack) {
        return FobWatchItem.getStackTag(stack).func_74762_e("open");
    }

    public static void setOpen(ItemStack stack, int amount) {
        FobWatchItem.getStackTag(stack).func_74768_a("open", amount);
    }

    public void func_77622_d(ItemStack stack, World worldIn, PlayerEntity playerIn) {
        super.func_77622_d(stack, worldIn, playerIn);
        this.setDamage(stack, 0);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new CompoundNBT());
            stack.func_77978_p().func_74757_a("live", true);
        } else {
            stack.func_77978_p().func_74757_a("live", true);
        }
        if (FobWatchItem.getOpen(stack) == 1 && entityIn.field_70173_aa % 600 == 0) {
            FobWatchItem.setOpen(stack, 0);
        }
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        IRegen cap = (IRegen)RegenCap.get((LivingEntity)player).orElseGet(null);
        if (!player.func_225608_bj_()) {
            if (this.getDamage(stack) == ((Integer)RegenConfig.COMMON.regenCapacity.get()).intValue()) {
                return this.msgUsageFailed(player, "regeneration.messages.transfer.empty_watch", stack);
            }
            if (cap.getRegens() == ((Integer)RegenConfig.COMMON.regenCapacity.get()).intValue()) {
                return this.msgUsageFailed(player, "regeneration.messages.transfer.max_regens", stack);
            }
            int supply = (Integer)RegenConfig.COMMON.regenCapacity.get() - this.getDamage(stack);
            int needed = (Integer)RegenConfig.COMMON.regenCapacity.get() - cap.getRegens();
            int used = Math.min(supply, needed);
            if (cap.canRegenerate()) {
                FobWatchItem.setOpen(stack, 1);
                PlayerUtil.sendMessage((LivingEntity)player, new TranslationTextComponent("regeneration.messages.gained_regens", new Object[]{used}), true);
            } else if (!world.field_72995_K) {
                FobWatchItem.setOpen(stack, 1);
                PlayerUtil.sendMessage((LivingEntity)player, new TranslationTextComponent("regeneration.messages.now_timelord"), true);
            }
            if (used < 0) {
                Regeneration.LOG.warn(player.func_200200_C_().getString() + ": Fob watch used <0 regens (supply: " + supply + ", needed:" + needed + ", used:" + used + ", capacity:" + RegenConfig.COMMON.regenCapacity.get() + ", damage:" + this.getDamage(stack) + ", regens:" + cap.getRegens());
            }
            this.setDamage(stack, stack.func_77952_i() + used);
            if (world.field_72995_K) {
                FobWatchItem.setOpen(stack, 1);
                ClientUtil.playPositionedSoundRecord((SoundEvent)RSounds.FOB_WATCH.get(), 1.0f, 2.0f);
            } else {
                cap.addRegens(used);
            }
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        if (!cap.canRegenerate()) {
            return this.msgUsageFailed(player, "regeneration.messages.transfer.no_regens", stack);
        }
        if (cap.getCurrentState() != RegenStates.ALIVE) {
            return this.msgUsageFailed(player, "regeneration.messages.not_alive", stack);
        }
        if (this.getDamage(stack) == 0) {
            return this.msgUsageFailed(player, "regeneration.messages.transfer.full_watch", stack);
        }
        this.setDamage(stack, this.getDamage(stack) - 1);
        PlayerUtil.sendMessage((LivingEntity)player, "regeneration.messages.transfer.success", true);
        if (world.field_72995_K) {
            ClientUtil.playPositionedSoundRecord(SoundEvents.field_187646_bt, 5.0f, 2.0f);
        } else {
            FobWatchItem.setOpen(stack, 1);
            cap.extractRegens(1);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    private ActionResult<ItemStack> msgUsageFailed(PlayerEntity player, String message, ItemStack stack) {
        PlayerUtil.sendMessage((LivingEntity)player, message, true);
        return ActionResult.func_226251_d_((Object)stack);
    }

    @Override
    public boolean onSolidEntityItemUpdate(OverrideEntity itemOverride) {
        if (!itemOverride.field_70170_p.field_72995_K) {
            return false;
        }
        ItemStack itemStack = itemOverride.getItem();
        if (itemStack.func_77973_b() == this && this.getDamage(itemStack) != ((Integer)RegenConfig.COMMON.regenCapacity.get()).intValue() && (itemOverride.field_70173_aa % 5000 == 0 || itemOverride.field_70173_aa == 2)) {
            ClientUtil.playSound((Object)itemOverride, ((SoundEvent)RSounds.FOB_WATCH_DIALOGUE.get()).getRegistryName(), SoundCategory.AMBIENT, false, () -> !itemOverride.func_70089_S(), 1.5f);
        }
        return true;
    }

    public int getMaxDamage(ItemStack stack) {
        return (Integer)RegenConfig.COMMON.regenCapacity.get();
    }
}

