/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regen.common.objects;

import me.swirtzly.regen.common.entities.OverrideEntity;
import me.swirtzly.regen.common.entities.TimelordEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class REntities {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"regen");
    public static RegistryObject<EntityType<OverrideEntity>> ITEM_OVERRIDE_ENTITY_TYPE = ENTITIES.register("item_override", () -> REntities.registerNoSpawnerBase(OverrideEntity::new, EntityClassification.MISC, 0.5f, 0.2f, 128, 1, true, "item_override"));
    public static RegistryObject<EntityType<TimelordEntity>> TIMELORD = ENTITIES.register("timelord", () -> REntities.registerNoSpawnerBase(TimelordEntity::new, EntityClassification.MISC, 0.6f, 1.95f, 128, 1, true, "timelord"));

    private static <T extends Entity> EntityType<T> registerNoSpawnerBase(EntityType.IFactory<T> factory, EntityClassification classification, float width, float height, int trackingRange, int updateFreq, boolean sendUpdate, String name) {
        ResourceLocation loc = new ResourceLocation("regen", name);
        EntityType.Builder builder = EntityType.Builder.func_220322_a(factory, (EntityClassification)classification);
        builder.setShouldReceiveVelocityUpdates(sendUpdate);
        builder.setTrackingRange(trackingRange);
        builder.setUpdateInterval(updateFreq);
        builder.func_220321_a(width, height);
        return builder.func_206830_a(loc.toString());
    }

    private static <T extends Entity> EntityType<T> registerBase(EntityType.IFactory<T> factory, IClientSpawner<T> client, EntityClassification classification, float width, float height, int trackingRange, int updateFreq, boolean sendUpdate, String name) {
        ResourceLocation loc = new ResourceLocation("regen", name);
        EntityType.Builder builder = EntityType.Builder.func_220322_a(factory, (EntityClassification)classification);
        builder.setShouldReceiveVelocityUpdates(sendUpdate);
        builder.setTrackingRange(trackingRange);
        builder.setUpdateInterval(updateFreq);
        builder.func_220321_a(width, height);
        builder.setCustomClientFactory((spawnEntity, world) -> (Entity)client.spawn((World)world));
        return builder.func_206830_a(loc.toString());
    }

    private static <T extends Entity> EntityType<T> registerFireImmuneBase(EntityType.IFactory<T> factory, IClientSpawner<T> client, EntityClassification classification, float width, float height, int trackingRange, int updateFreq, boolean sendUpdate, String name) {
        ResourceLocation loc = new ResourceLocation("regen", name);
        EntityType.Builder builder = EntityType.Builder.func_220322_a(factory, (EntityClassification)classification);
        builder.setShouldReceiveVelocityUpdates(sendUpdate);
        builder.setTrackingRange(trackingRange);
        builder.setUpdateInterval(updateFreq);
        builder.func_220320_c();
        builder.func_220321_a(width, height);
        builder.setCustomClientFactory((spawnEntity, world) -> (Entity)client.spawn((World)world));
        EntityType type = builder.func_206830_a(loc.toString());
        return type;
    }

    private static <T extends Entity> EntityType<T> registerFireResistMob(EntityType.IFactory<T> factory, IClientSpawner<T> client, EntityClassification classification, float width, float height, String name, boolean velocity) {
        return REntities.registerFireImmuneBase(factory, client, classification, width, height, 80, 3, velocity, name);
    }

    private static <T extends Entity> EntityType<T> registerStatic(EntityType.IFactory<T> factory, IClientSpawner<T> client, EntityClassification classification, float width, float height, String name) {
        return REntities.registerBase(factory, client, classification, width, height, 64, 40, false, name);
    }

    private static <T extends Entity> EntityType<T> registerMob(EntityType.IFactory<T> factory, IClientSpawner<T> client, EntityClassification classification, float width, float height, String name, boolean velocity) {
        return REntities.registerBase(factory, client, classification, width, height, 80, 3, velocity, name);
    }

    private static <T extends Entity> EntityType<T> registerNonSpawner(EntityType.IFactory<T> factory, EntityClassification classification, float width, float height, boolean velocity, String name) {
        return REntities.registerNoSpawnerBase(factory, classification, width, height, 64, 40, velocity, name);
    }

    public static interface IClientSpawner<T> {
        public T spawn(World var1);
    }
}

