/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regen.common.regen;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.swirtzly.regen.common.regen.IRegen;
import me.swirtzly.regen.common.regen.acting.ActingForwarder;
import me.swirtzly.regen.common.regen.state.IStateManager;
import me.swirtzly.regen.common.regen.state.RegenStates;
import me.swirtzly.regen.common.regen.transitions.TransitionTypes;
import me.swirtzly.regen.config.RegenConfig;
import me.swirtzly.regen.network.NetworkDispatcher;
import me.swirtzly.regen.network.messages.SyncMessage;
import me.swirtzly.regen.util.PlayerUtil;
import me.swirtzly.regen.util.RConstants;
import me.swirtzly.regen.util.RegenSources;
import me.swirtzly.regen.util.schedule.RegenScheduledAction;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import org.apache.commons.lang3.tuple.Pair;

public class RegenCap
implements IRegen {
    @CapabilityInject(value=IRegen.class)
    public static final Capability<IRegen> CAPABILITY = null;
    private final StateManager stateManager;
    private final LivingEntity livingEntity;
    private boolean didSetup = false;
    private float primaryRed = 0.93f;
    private float primaryGreen = 0.61f;
    private float primaryBlue = 0.0f;
    private float secondaryRed = 1.0f;
    private float secondaryGreen = 0.5f;
    private float secondaryBlue = 0.18f;
    private boolean isAlex = false;
    private byte[] skinArray = new byte[0];
    private int regensLeft = 0;
    private int ticksAnimating = 0;
    private String deathMessage = "";
    private RegenStates currentState = RegenStates.ALIVE;
    private TransitionTypes transitionType = TransitionTypes.FIERY;
    private boolean areHandsGlowing = false;
    private PlayerUtil.SkinType preferredSkinType = PlayerUtil.SkinType.ALEX;
    private boolean nextSkinTypeAlex = false;
    private byte[] nextSkin = new byte[0];

    public RegenCap() {
        this.livingEntity = null;
        this.stateManager = null;
    }

    public RegenCap(LivingEntity livingEntity) {
        this.livingEntity = livingEntity;
        this.stateManager = !livingEntity.field_70170_p.field_72995_K ? new StateManager() : null;
    }

    @Nonnull
    public static LazyOptional<IRegen> get(LivingEntity player) {
        return player.getCapability(CAPABILITY, null);
    }

    @Override
    public int getRegens() {
        return this.regensLeft;
    }

    @Override
    public void setRegens(int regens) {
        this.regensLeft = regens;
    }

    @Override
    public void tick() {
        if (!this.livingEntity.field_70170_p.field_72995_K) {
            if (!this.didSetup) {
                this.syncToClients(null);
                this.didSetup = true;
            }
            if (this.currentState != RegenStates.ALIVE && this.stateManager != null) {
                this.stateManager.tick();
            }
            if (this.currentState == RegenStates.REGENERATING) {
                ++this.ticksAnimating;
                this.transitionType.get().onUpdateMidRegen(this);
                this.syncToClients(null);
            } else {
                this.ticksAnimating = 0;
            }
        }
    }

    @Override
    public int getTicksAnimating() {
        return this.ticksAnimating;
    }

    @Override
    public void setAnimationTicks(int ticksAnimating) {
        this.ticksAnimating = ticksAnimating;
    }

    @Override
    public boolean canRegenerate() {
        return this.getRegens() > 0 && this.livingEntity.func_226278_cu_() > 0.0;
    }

    @Override
    public boolean areHandsGlowing() {
        return this.areHandsGlowing;
    }

    @Override
    public RegenStates getCurrentState() {
        return this.currentState;
    }

    @Override
    public StateManager getStateManager() {
        return this.stateManager;
    }

    @Override
    public void readStyle(CompoundNBT colors) {
        this.primaryRed = colors.func_74760_g(RConstants.PRIMARY_RED);
        this.primaryGreen = colors.func_74760_g(RConstants.PRIMARY_GREEN);
        this.primaryBlue = colors.func_74760_g(RConstants.PRIMARY_BLUE);
        this.secondaryRed = colors.func_74760_g(RConstants.SECONDARY_RED);
        this.secondaryGreen = colors.func_74760_g(RConstants.SECONDARY_GREEN);
        this.secondaryBlue = colors.func_74760_g(RConstants.SECONDARY_BLUE);
    }

    @Override
    public CompoundNBT getOrWriteStyle() {
        CompoundNBT colors = new CompoundNBT();
        colors.func_74776_a(RConstants.PRIMARY_RED, this.primaryRed);
        colors.func_74776_a(RConstants.PRIMARY_GREEN, this.primaryGreen);
        colors.func_74776_a(RConstants.PRIMARY_BLUE, this.primaryBlue);
        colors.func_74776_a(RConstants.SECONDARY_RED, this.secondaryRed);
        colors.func_74776_a(RConstants.SECONDARY_GREEN, this.secondaryGreen);
        colors.func_74776_a(RConstants.SECONDARY_BLUE, this.secondaryBlue);
        return colors;
    }

    @Override
    public void extractRegens(int amount) {
        this.regensLeft -= amount;
    }

    @Override
    public void addRegens(int amount) {
        this.regensLeft += amount;
    }

    @Override
    public LivingEntity getLiving() {
        return this.livingEntity;
    }

    @Override
    public void syncToClients(@Nullable ServerPlayerEntity serverPlayerEntity) {
        if (this.livingEntity != null && this.livingEntity.field_70170_p.field_72995_K) {
            throw new IllegalStateException("Don't sync client -> server");
        }
        this.areHandsGlowing = this.getCurrentState().isGraceful() && this.stateManager.handGlowTimer.getTransition() == RegenStates.Transition.HAND_GLOW_TRIGGER;
        CompoundNBT nbt = this.serializeNBT();
        nbt.func_82580_o("state_manager");
        if (serverPlayerEntity == null) {
            NetworkDispatcher.NETWORK_CHANNEL.send(PacketDistributor.DIMENSION.with(() -> this.livingEntity.func_130014_f_().func_234923_W_()), (Object)new SyncMessage(this.livingEntity.func_145782_y(), nbt));
        } else {
            NetworkDispatcher.NETWORK_CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayerEntity), (Object)new SyncMessage(this.livingEntity.func_145782_y(), nbt));
        }
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT compoundNBT = new CompoundNBT();
        compoundNBT.func_74768_a(RConstants.REGENS_LEFT, this.regensLeft);
        compoundNBT.func_74778_a(RConstants.CURRENT_STATE, this.currentState.name());
        compoundNBT.func_74768_a(RConstants.ANIMATION_TICKS, this.ticksAnimating);
        compoundNBT.func_74778_a("transition_type", this.transitionType.get().getRegistryName().toString());
        compoundNBT.func_74778_a("model_pref", this.preferredSkinType.name());
        compoundNBT.func_74757_a("is_alex", this.isAlexSkinCurrently());
        compoundNBT.func_74757_a("glowing", this.areHandsGlowing());
        compoundNBT.func_74757_a("next_is_alex", this.isNextSkinTypeAlex());
        if (this.isSkinValidForUse()) {
            compoundNBT.func_74773_a("skin", this.skinArray);
        }
        if (this.isNextSkinValid()) {
            compoundNBT.func_74773_a("next_skin", this.nextSkin);
        }
        if (!this.livingEntity.field_70170_p.field_72995_K && this.stateManager != null) {
            compoundNBT.func_218657_a("state_manager", (INBT)this.stateManager.serializeNBT());
        }
        compoundNBT.func_218657_a("colors", (INBT)this.getOrWriteStyle());
        return compoundNBT;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.setRegens(nbt.func_74762_e(RConstants.REGENS_LEFT));
        this.currentState = nbt.func_74764_b(RConstants.CURRENT_STATE) ? RegenStates.valueOf(nbt.func_74779_i(RConstants.CURRENT_STATE)) : RegenStates.ALIVE;
        this.setAnimationTicks(nbt.func_74762_e(RConstants.ANIMATION_TICKS));
        this.setSkin(nbt.func_74770_j("skin"));
        this.setNextSkin(nbt.func_74770_j("next_skin"));
        this.setAlexSkin(nbt.func_74767_n("is_alex"));
        this.setNextSkinType(nbt.func_74767_n("next_is_alex"));
        this.areHandsGlowing = nbt.func_74767_n("glowing");
        if (nbt.func_74764_b("model_pref")) {
            this.setPreferredModel(PlayerUtil.SkinType.valueOf(nbt.func_74779_i("model_pref")));
        }
        if (nbt.func_74764_b("transition_type")) {
            this.transitionType = (TransitionTypes)TransitionTypes.REGISTRY.getValue(new ResourceLocation(nbt.func_74779_i("transition_type")));
        }
        if (nbt.func_74764_b("state_manager") && this.stateManager != null) {
            this.stateManager.deserializeNBT((CompoundNBT)nbt.func_74781_a("state_manager"));
        }
        if (nbt.func_74764_b("colors")) {
            this.readStyle((CompoundNBT)nbt.func_74781_a("colors"));
        }
    }

    @Override
    public TransitionTypes getTransitionType() {
        return this.transitionType;
    }

    @Override
    public void setTransitionType(TransitionTypes transitionType) {
        this.transitionType = transitionType;
    }

    @Override
    public String getDeathMessage() {
        return this.deathMessage;
    }

    @Override
    public void setDeathMessage(String deathMessage) {
        this.deathMessage = deathMessage;
    }

    @Override
    public void regen() {
        if (this.stateManager != null) {
            this.stateManager.triggerRegeneration();
        }
    }

    @Override
    public byte[] getSkin() {
        return this.skinArray;
    }

    @Override
    public void setSkin(byte[] skin) {
        this.skinArray = skin;
    }

    @Override
    public boolean isSkinValidForUse() {
        return !Arrays.equals(this.skinArray, new byte[0]);
    }

    @Override
    public Vector3d getPrimaryColors() {
        return new Vector3d((double)this.primaryRed, (double)this.primaryGreen, (double)this.primaryBlue);
    }

    @Override
    public Vector3d getSecondaryColors() {
        return new Vector3d((double)this.secondaryRed, (double)this.secondaryGreen, (double)this.secondaryBlue);
    }

    @Override
    public boolean isAlexSkinCurrently() {
        return this.isAlex;
    }

    @Override
    public void setAlexSkin(boolean isAlex) {
        this.isAlex = isAlex;
    }

    @Override
    public PlayerUtil.SkinType getPreferredModel() {
        return this.preferredSkinType;
    }

    @Override
    public void setPreferredModel(PlayerUtil.SkinType skinType) {
        this.preferredSkinType = skinType;
    }

    @Override
    public byte[] getNextSkin() {
        return this.nextSkin;
    }

    @Override
    public void setNextSkin(byte[] bytes) {
        this.nextSkin = bytes;
    }

    @Override
    public boolean isNextSkinValid() {
        return !Arrays.equals(this.nextSkin, new byte[0]);
    }

    @Override
    public void setNextSkinType(boolean isAlex) {
        this.nextSkinTypeAlex = isAlex;
    }

    @Override
    public boolean isNextSkinTypeAlex() {
        return this.nextSkinTypeAlex;
    }

    public class StateManager
    implements IStateManager {
        private final Map<RegenStates.Transition, Runnable> transitionCallbacks = new HashMap<RegenStates.Transition, Runnable>();
        private RegenScheduledAction nextTransition;
        private RegenScheduledAction handGlowTimer;

        private StateManager() {
            this.transitionCallbacks.put(RegenStates.Transition.ENTER_CRITICAL, this::enterCriticalPhase);
            this.transitionCallbacks.put(RegenStates.Transition.CRITICAL_DEATH, () -> this.midSequenceKill(true));
            this.transitionCallbacks.put(RegenStates.Transition.FINISH_REGENERATION, this::finishRegeneration);
            this.transitionCallbacks.put(RegenStates.Transition.END_POST, this::endPost);
            Runnable err = () -> {
                throw new IllegalStateException("Can't use HAND_GLOW_* transitions as state transitions");
            };
            this.transitionCallbacks.put(RegenStates.Transition.HAND_GLOW_START, err);
            this.transitionCallbacks.put(RegenStates.Transition.HAND_GLOW_TRIGGER, err);
        }

        private void scheduleTransitionInTicks(RegenStates.Transition transition, long inTicks) {
            if (this.nextTransition != null && this.nextTransition.getTicksLeft() > 0L) {
                throw new IllegalStateException("Overwriting non-completed/cancelled transition: \n Attempted Transition: " + transition.name() + "\n Current: " + this.nextTransition.transition.name() + "\n Affected Player: " + RegenCap.this.livingEntity.func_200200_C_());
            }
            if (transition == RegenStates.Transition.HAND_GLOW_START || transition == RegenStates.Transition.HAND_GLOW_TRIGGER) {
                throw new IllegalStateException("Can't use HAND_GLOW_* transitions as state transitions");
            }
            this.nextTransition = new RegenScheduledAction(transition, RegenCap.this.livingEntity, this.transitionCallbacks.get((Object)transition), inTicks);
        }

        private void scheduleTransitionInSeconds(RegenStates.Transition transition, long inSeconds) {
            this.scheduleTransitionInTicks(transition, inSeconds * 20L);
        }

        private void scheduleNextHandGlow() {
            if (RegenCap.this.currentState.isGraceful() && this.handGlowTimer.getTicksLeft() > 0L) {
                throw new IllegalStateException("Overwriting running hand-glow timer with new next hand glow");
            }
            this.handGlowTimer = new RegenScheduledAction(RegenStates.Transition.HAND_GLOW_START, RegenCap.this.livingEntity, this::scheduleHandGlowTrigger, (Integer)RegenConfig.COMMON.handGlowInterval.get() * 20);
            RegenCap.this.syncToClients(null);
        }

        private void scheduleHandGlowTrigger() {
            if (RegenCap.this.currentState.isGraceful() && this.handGlowTimer.getTicksLeft() > 0L) {
                throw new IllegalStateException("Overwriting running hand-glow timer with trigger timer prematurely");
            }
            this.handGlowTimer = new RegenScheduledAction(RegenStates.Transition.HAND_GLOW_TRIGGER, RegenCap.this.livingEntity, this::triggerRegeneration, (Integer)RegenConfig.COMMON.handGlowTriggerDelay.get() * 20);
            ActingForwarder.onHandsStartGlowing(RegenCap.this);
            RegenCap.this.syncToClients(null);
        }

        @Override
        public boolean onKilled(DamageSource source) {
            if (source == DamageSource.field_76368_d || source == DamageSource.field_191291_g) {
                return false;
            }
            if (RegenCap.this.currentState == RegenStates.ALIVE) {
                if (!RegenCap.this.canRegenerate()) {
                    return false;
                }
                this.scheduleTransitionInSeconds(RegenStates.Transition.ENTER_CRITICAL, ((Integer)RegenConfig.COMMON.gracePhaseLength.get()).intValue());
                this.scheduleHandGlowTrigger();
                RegenCap.this.currentState = RegenStates.GRACE;
                RegenCap.this.syncToClients(null);
                ActingForwarder.onEnterGrace(RegenCap.this);
                return true;
            }
            if (RegenCap.this.currentState == RegenStates.GRACE) {
                this.triggerRegeneration();
                return true;
            }
            if (RegenCap.this.currentState == RegenStates.REGENERATING) {
                this.nextTransition.cancel();
                this.midSequenceKill(false);
                return false;
            }
            if (RegenCap.this.currentState == RegenStates.POST || RegenCap.this.currentState == RegenStates.GRACE_CRIT) {
                RegenCap.this.currentState = RegenStates.ALIVE;
                this.nextTransition.cancel();
                if (source == RegenSources.REGEN_DMG_FORCED) {
                    this.triggerRegeneration();
                    return true;
                }
                this.midSequenceKill(RegenCap.this.currentState == RegenStates.GRACE_CRIT);
                return false;
            }
            throw new IllegalStateException("Unknown state: " + (Object)((Object)RegenCap.this.currentState));
        }

        @Override
        public void onPunchEntity(LivingHurtEvent event) {
            LivingEntity entity = event.getEntityLiving();
            if (RegenCap.this.currentState.isGraceful() && entity.func_110143_aJ() < entity.func_110138_aP() && RegenCap.this.areHandsGlowing() && RegenCap.this.livingEntity.func_225608_bj_()) {
                float healthNeeded = entity.func_110138_aP() - entity.func_110143_aJ();
                entity.func_70691_i(healthNeeded);
                if (RegenCap.this.livingEntity instanceof PlayerEntity) {
                    PlayerUtil.sendMessage(RegenCap.this.livingEntity, new TranslationTextComponent("regeneration.messages.healed", new Object[]{entity.func_200200_C_()}), true);
                }
                event.setAmount(0.0f);
                RegenCap.this.livingEntity.func_70097_a(RegenSources.REGEN_DMG_HEALING, healthNeeded);
            }
        }

        @Override
        public void onPunchBlock(PlayerInteractEvent.LeftClickBlock e) {
            if (RegenCap.this.currentState.isGraceful() && RegenCap.this.areHandsGlowing()) {
                BlockState block = e.getWorld().func_180495_p(e.getPos());
                if (block.func_177230_c() == Blocks.field_150433_aE || block.func_177230_c() == Blocks.field_196604_cC) {
                    e.getWorld().func_184133_a(null, e.getPos(), SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                this.handGlowTimer.cancel();
                this.scheduleNextHandGlow();
                if (!((RegenCap)RegenCap.this).livingEntity.field_70170_p.field_72995_K && RegenCap.this.livingEntity instanceof PlayerEntity) {
                    PlayerUtil.sendMessage(RegenCap.this.livingEntity, new TranslationTextComponent("regeneration.messages.regen_delayed"), true);
                }
                e.setCanceled(true);
            }
        }

        private void tick() {
            if (((RegenCap)RegenCap.this).livingEntity.field_70170_p.field_72995_K) {
                throw new IllegalStateException("Ticking state manager on the client");
            }
            if (RegenCap.this.currentState == RegenStates.ALIVE) {
                throw new IllegalStateException("Ticking dormant state manager (state == ALIVE)");
            }
            if (RegenCap.this.currentState.isGraceful()) {
                this.handGlowTimer.tick();
            }
            ActingForwarder.onRegenTick(RegenCap.this);
            if (this.nextTransition != null) {
                this.nextTransition.tick();
            }
            if (RegenCap.this.currentState == RegenStates.POST) {
                ActingForwarder.onPerformingPost(RegenCap.this);
            }
        }

        private void triggerRegeneration() {
            RegenCap.this.currentState = RegenStates.REGENERATING;
            if (((Boolean)RegenConfig.COMMON.sendRegenDeathMessages.get()).booleanValue() && RegenCap.this.livingEntity instanceof PlayerEntity) {
                TranslationTextComponent text = new TranslationTextComponent("regeneration.messages.regen_death_msg", new Object[]{RegenCap.this.livingEntity.func_200200_C_()});
                text.func_230530_a_(text.func_150256_b().func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new StringTextComponent(RegenCap.this.getDeathMessage()))));
                PlayerUtil.sendMessageToAll(text);
            }
            this.nextTransition.cancel();
            if (RegenCap.this.currentState.isGraceful()) {
                this.handGlowTimer.cancel();
            }
            this.scheduleTransitionInTicks(RegenStates.Transition.FINISH_REGENERATION, RegenCap.this.transitionType.get().getAnimationLength());
            ActingForwarder.onRegenTrigger(RegenCap.this);
            RegenCap.this.transitionType.get().onStartRegeneration(RegenCap.this);
            RegenCap.this.syncToClients(null);
        }

        private void enterCriticalPhase() {
            RegenCap.this.currentState = RegenStates.GRACE_CRIT;
            this.scheduleTransitionInSeconds(RegenStates.Transition.CRITICAL_DEATH, ((Integer)RegenConfig.COMMON.criticalPhaseLength.get()).intValue());
            ActingForwarder.onGoCritical(RegenCap.this);
            RegenCap.this.syncToClients(null);
        }

        private void midSequenceKill(boolean isGrace) {
            RegenCap.this.currentState = RegenStates.ALIVE;
            this.nextTransition = null;
            this.handGlowTimer = null;
            RegenCap.this.transitionType.get().onFinishRegeneration(RegenCap.this);
            if (isGrace) {
                RegenCap.this.livingEntity.func_70097_a(RegenSources.REGEN_DMG_CRITICAL, 2.1474836E9f);
            } else {
                RegenCap.this.livingEntity.func_70097_a(RegenSources.REGEN_DMG_KILLED, 2.1474836E9f);
            }
            if (((Boolean)RegenConfig.COMMON.loseRegensOnDeath.get()).booleanValue()) {
                RegenCap.this.extractRegens(RegenCap.this.getRegens());
            }
            RegenCap.this.setSkin(new byte[0]);
            RegenCap.this.syncToClients(null);
        }

        private void endPost() {
            RegenCap.this.currentState = RegenStates.ALIVE;
            RegenCap.this.syncToClients(null);
            this.nextTransition = null;
            if (RegenCap.this.livingEntity instanceof PlayerEntity) {
                PlayerUtil.sendMessage(RegenCap.this.livingEntity, new TranslationTextComponent("regeneration.messages.post_ended"), true);
            }
        }

        private void finishRegeneration() {
            RegenCap.this.currentState = RegenStates.POST;
            this.scheduleTransitionInSeconds(RegenStates.Transition.END_POST, ((RegenCap)RegenCap.this).livingEntity.field_70170_p.field_73012_v.nextInt(300));
            this.handGlowTimer = null;
            RegenCap.this.transitionType.get().onFinishRegeneration(RegenCap.this);
            ActingForwarder.onRegenFinish(RegenCap.this);
            RegenCap.this.syncToClients(null);
        }

        @Override
        @Deprecated
        public Pair<RegenStates.Transition, Long> getScheduledEvent() {
            return this.nextTransition == null ? null : Pair.of((Object)((Object)this.nextTransition.transition), (Object)this.nextTransition.getTicksLeft());
        }

        @Override
        @Deprecated
        public void fastForward() {
            while (!this.nextTransition.tick()) {
            }
        }

        @Override
        @Deprecated
        public void fastForwardHandGlow() {
            while (!this.handGlowTimer.tick()) {
            }
        }

        @Override
        public double getStateProgress() {
            if (this.nextTransition != null) {
                return this.nextTransition.getProgress();
            }
            return 0.0;
        }

        public CompoundNBT serializeNBT() {
            CompoundNBT nbt = new CompoundNBT();
            if (this.nextTransition != null && this.nextTransition.getTicksLeft() >= 0L) {
                nbt.func_74778_a("transitionId", this.nextTransition.transition.toString());
                nbt.func_74772_a("transitionInTicks", this.nextTransition.getTicksLeft());
            }
            if (this.handGlowTimer != null && this.handGlowTimer.getTicksLeft() >= 0L) {
                nbt.func_74778_a("handGlowState", this.handGlowTimer.transition.toString());
                nbt.func_74772_a("handGlowScheduledTicks", this.handGlowTimer.getTicksLeft());
            }
            return nbt;
        }

        public void deserializeNBT(CompoundNBT nbt) {
            if (nbt.func_74764_b("transitionId")) {
                this.scheduleTransitionInTicks(RegenStates.Transition.valueOf(nbt.func_74779_i("transitionId")), nbt.func_74763_f("transitionInTicks"));
            }
            if (nbt.func_74764_b("handGlowState")) {
                Runnable callback;
                RegenStates.Transition transition = RegenStates.Transition.valueOf(nbt.func_74779_i("handGlowState"));
                if (transition == RegenStates.Transition.HAND_GLOW_START) {
                    callback = this::scheduleHandGlowTrigger;
                } else if (transition == RegenStates.Transition.HAND_GLOW_TRIGGER) {
                    callback = this::triggerRegeneration;
                } else {
                    throw new IllegalStateException("Illegal hand glow timer transition");
                }
                this.handGlowTimer = new RegenScheduledAction(transition, RegenCap.this.livingEntity, callback, nbt.func_74763_f("handGlowScheduledTicks"));
            }
        }
    }
}

