/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regen.common.regen.acting;

import java.io.File;
import me.swirtzly.regen.Regeneration;
import me.swirtzly.regen.client.skin.CommonSkin;
import me.swirtzly.regen.client.skin.SkinHandler;
import me.swirtzly.regen.common.objects.RSounds;
import me.swirtzly.regen.common.regen.IRegen;
import me.swirtzly.regen.common.regen.acting.Acting;
import me.swirtzly.regen.common.regen.state.RegenStates;
import me.swirtzly.regen.config.RegenConfig;
import me.swirtzly.regen.network.NetworkDispatcher;
import me.swirtzly.regen.network.messages.SkinMessage;
import me.swirtzly.regen.util.ClientUtil;
import me.swirtzly.regen.util.RegenUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TranslationTextComponent;

class ClientActing
implements Acting {
    public static final Acting INSTANCE = new ClientActing();

    private ClientActing() {
    }

    @Override
    public void onRegenTick(IRegen cap) {
    }

    @Override
    public void onEnterGrace(IRegen cap) {
        ClientUtil.playSound(cap.getLiving(), ((SoundEvent)RSounds.HEART_BEAT.get()).getRegistryName(), SoundCategory.PLAYERS, true, () -> !cap.getCurrentState().isGraceful(), 0.2f);
        ClientUtil.playSound(cap.getLiving(), ((SoundEvent)RSounds.GRACE_HUM.get()).getRegistryName(), SoundCategory.AMBIENT, true, () -> cap.getCurrentState() != RegenStates.GRACE, 1.5f);
    }

    @Override
    public void onHandsStartGlowing(IRegen cap) {
        ClientUtil.playSound(cap.getLiving(), ((SoundEvent)RSounds.HAND_GLOW.get()).getRegistryName(), SoundCategory.PLAYERS, true, () -> !cap.areHandsGlowing(), 1.0f);
    }

    @Override
    public void onRegenFinish(IRegen cap) {
    }

    @Override
    public void onPerformingPost(IRegen cap) {
    }

    @Override
    public void onRegenTrigger(IRegen cap) {
        if (Minecraft.func_71410_x().field_71439_g.func_110124_au().equals(cap.getLiving().func_110124_au())) {
            if (((Boolean)RegenConfig.CLIENT.changeMySkin.get()).booleanValue()) {
                if (cap.isNextSkinValid()) {
                    NetworkDispatcher.NETWORK_CHANNEL.sendToServer((Object)new SkinMessage(cap.getNextSkin(), cap.isNextSkinTypeAlex()));
                    return;
                }
                File file = CommonSkin.chooseRandomSkin(cap.getLiving().func_70681_au(), cap.getPreferredModel().isAlex());
                boolean isAlex = file.getAbsolutePath().contains(CommonSkin.SKIN_DIRECTORY_ALEX.getAbsolutePath());
                Regeneration.LOG.info("Choosen Skin: " + file);
                NetworkDispatcher.NETWORK_CHANNEL.sendToServer((Object)new SkinMessage(RegenUtil.fileToBytes(file), isAlex));
            } else {
                SkinHandler.sendResetMessage();
            }
        }
    }

    @Override
    public void onGoCritical(IRegen cap) {
        if (Minecraft.func_71410_x().field_71439_g.func_110124_au().equals(cap.getLiving().func_110124_au())) {
            ClientUtil.createToast(new TranslationTextComponent("regeneration.toast.enter_critical"), new TranslationTextComponent("regeneration.toast.enter_critical.sub", new Object[]{(Integer)RegenConfig.COMMON.criticalPhaseLength.get() / 60}));
            ClientUtil.playSound(cap.getLiving(), ((SoundEvent)RSounds.CRITICAL_STAGE.get()).getRegistryName(), SoundCategory.PLAYERS, true, () -> cap.getCurrentState() != RegenStates.GRACE_CRIT, 1.0f);
        }
    }
}

