/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regen.common.regen.transitions;

import java.util.Iterator;
import me.swirtzly.regen.client.rendering.transitions.FieryTransitionRenderer;
import me.swirtzly.regen.common.objects.RSounds;
import me.swirtzly.regen.common.regen.IRegen;
import me.swirtzly.regen.common.regen.transitions.TransitionType;
import me.swirtzly.regen.config.RegenConfig;
import me.swirtzly.regen.network.NetworkDispatcher;
import me.swirtzly.regen.network.messages.POVMessage;
import me.swirtzly.regen.util.PlayerUtil;
import net.minecraft.block.FireBlock;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Explosion;
import net.minecraftforge.fml.network.PacketDistributor;

public class FieryTransition
implements TransitionType<FieryTransitionRenderer> {
    @Override
    public void onUpdateMidRegen(IRegen capability) {
        LivingEntity livingEntity = capability.getLiving();
        livingEntity.func_70066_B();
        if (!livingEntity.field_70170_p.field_72995_K && capability.getLiving() instanceof ServerPlayerEntity) {
            NetworkDispatcher.NETWORK_CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)capability.getLiving()), (Object)new POVMessage(PointOfView.THIRD_PERSON_FRONT));
        }
        if (livingEntity.field_70170_p.field_72995_K) {
            return;
        }
        BlockPos livingPos = new BlockPos(livingEntity.func_213303_ch());
        if (livingEntity.field_70170_p.func_180495_p(livingPos).func_177230_c() instanceof FireBlock) {
            livingEntity.field_70170_p.func_217377_a(livingPos, false);
        }
        PlayerUtil.regenerationExplosion(livingEntity);
        double x = livingEntity.func_226277_ct_() + livingEntity.func_70681_au().nextGaussian() * 2.0;
        double y = livingEntity.func_226278_cu_() + 0.5 + livingEntity.func_70681_au().nextGaussian() * 2.0;
        double z = livingEntity.func_226281_cx_() + livingEntity.func_70681_au().nextGaussian() * 2.0;
        livingEntity.field_70170_p.func_217398_a((Entity)livingEntity, x, y, z, 0.1f, ((Boolean)RegenConfig.COMMON.fieryRegen.get()).booleanValue(), Explosion.Mode.NONE);
        Iterator iterator = BlockPos.func_218281_b((BlockPos)new BlockPos(livingEntity.func_213303_ch()).func_177978_c().func_177976_e(), (BlockPos)new BlockPos(livingEntity.func_213303_ch()).func_177968_d().func_177974_f()).iterator();
        while (iterator.hasNext()) {
            iterator.forEachRemaining(blockPos -> {
                if (livingEntity.field_70170_p.func_180495_p(blockPos).func_177230_c() instanceof FireBlock) {
                    livingEntity.field_70170_p.func_217377_a(blockPos, false);
                }
            });
        }
    }

    @Override
    public void onFinishRegeneration(IRegen capability) {
        if (capability.getLiving() instanceof ServerPlayerEntity) {
            NetworkDispatcher.NETWORK_CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)capability.getLiving()), (Object)new POVMessage(PointOfView.FIRST_PERSON));
        }
        capability.setAnimationTicks(0);
        capability.syncToClients(null);
    }

    @Override
    public int getAnimationLength() {
        return 280;
    }

    @Override
    public double getAnimationProgress(IRegen cap) {
        return Math.min(1.0, (double)cap.getTicksAnimating() / (double)this.getAnimationLength());
    }

    @Override
    public SoundEvent[] getRegeneratingSounds() {
        return new SoundEvent[]{(SoundEvent)RSounds.REGENERATION_0.get(), (SoundEvent)RSounds.REGENERATION_1.get(), (SoundEvent)RSounds.REGENERATION_2.get(), (SoundEvent)RSounds.REGENERATION_3.get(), (SoundEvent)RSounds.REGENERATION_4.get(), (SoundEvent)RSounds.REGENERATION_5.get(), (SoundEvent)RSounds.REGENERATION_6.get(), (SoundEvent)RSounds.REGENERATION_7.get()};
    }

    @Override
    public Vector3d getDefaultPrimaryColor() {
        return new Vector3d((double)0.93f, (double)0.61f, 0.0);
    }

    @Override
    public Vector3d getDefaultSecondaryColor() {
        return new Vector3d(1.0, 0.5, (double)0.18f);
    }

    @Override
    public ResourceLocation getRegistryName() {
        return new ResourceLocation("regen", "fiery");
    }

    @Override
    public FieryTransitionRenderer getRenderer() {
        return FieryTransitionRenderer.INSTANCE;
    }
}

