/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regen.common.regen.transitions;

import java.util.function.Supplier;
import me.swirtzly.regen.common.regen.transitions.FieryTransition;
import me.swirtzly.regen.common.regen.transitions.TransitionType;
import me.swirtzly.regen.common.regen.transitions.TroughtonTransition;
import me.swirtzly.regen.common.regen.transitions.WatcherTransition;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;

@Mod.EventBusSubscriber(modid="regen", bus=Mod.EventBusSubscriber.Bus.MOD)
public class TransitionTypes
extends ForgeRegistryEntry<TransitionTypes> {
    public static final TransitionTypes FIERY = new TransitionTypes(FieryTransition::new);
    public static final TransitionTypes TROUGHTON = new TransitionTypes(TroughtonTransition::new);
    public static final TransitionTypes WATCHER = new TransitionTypes(WatcherTransition::new);
    public static IForgeRegistry<TransitionTypes> REGISTRY;
    public static TransitionTypes[] TYPES;
    private Supplier<TransitionType> supplier;

    public TransitionTypes(Supplier<TransitionType> supplier) {
        this.supplier = supplier;
        this.setRegistryName(supplier.get().getRegistryName());
    }

    @SubscribeEvent
    public static void onRegisterNewRegistries(RegistryEvent.NewRegistry e) {
        REGISTRY = new RegistryBuilder().setName(new ResourceLocation("regen", "regeneration_types")).setType(TransitionTypes.class).setIDRange(0, 2048).create();
    }

    public static int getPosition(TransitionTypes rrRegenType) {
        for (int i = 0; i < TYPES.length; ++i) {
            if (TYPES[i] != rrRegenType) continue;
            return i;
        }
        return 0;
    }

    public static TransitionTypes getRandomType() {
        return TYPES[(int)(System.currentTimeMillis() % (long)TYPES.length)];
    }

    @SubscribeEvent
    public static void onRegisterTypes(RegistryEvent.Register<TransitionTypes> e) {
        e.getRegistry().registerAll((IForgeRegistryEntry[])new TransitionTypes[]{FIERY, TROUGHTON});
        TYPES = e.getRegistry().getValues().toArray(new TransitionTypes[0]);
    }

    public TransitionType get() {
        return this.supplier.get();
    }

    static {
        TYPES = new TransitionTypes[]{FIERY, TROUGHTON};
    }
}

