/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regen.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;

public abstract class BaseSoundsProvider
implements IDataProvider {
    private final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final Map<String, SoundEventBuilder> data = new TreeMap<String, SoundEventBuilder>();
    private final DataGenerator gen;
    private final String modid;

    public BaseSoundsProvider(DataGenerator gen, String modid) {
        this.gen = gen;
        this.modid = modid;
    }

    protected abstract void addSounds();

    public void func_200398_a(@Nonnull DirectoryCache cache) {
        this.data.clear();
        this.addSounds();
        if (!this.data.isEmpty()) {
            JsonObject jsonObject = new JsonObject();
            for (Map.Entry<String, SoundEventBuilder> entry : this.data.entrySet()) {
                jsonObject.add(entry.getKey(), entry.getValue().toJson());
            }
            try {
                IDataProvider.func_218426_a((Gson)this.GSON, (DirectoryCache)cache, (JsonElement)jsonObject, (Path)this.gen.func_200391_b().resolve("assets/" + this.modid + "/sounds.json"));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String func_200397_b() {
        return "Sounds";
    }

    protected void addSoundEvent(SoundEventBuilder soundEvent) {
        String path = soundEvent.getPath();
        if (this.data.containsKey(path)) {
            throw new RuntimeException("Sound event '" + path + "' has already been added.");
        }
        this.data.put(path, soundEvent);
    }

    public static class SoundBuilder {
        private final ResourceLocation fileLocation;
        private float volume = 1.0f;
        private float pitch = 1.0f;
        private int weight = 1;
        private boolean stream = false;
        private int attenuationDistance = 16;
        private boolean preload = false;
        private SoundType type = SoundType.SOUND;

        public SoundBuilder(ResourceLocation fileLocation) {
            this.fileLocation = fileLocation;
        }

        public ResourceLocation getFileLocation() {
            return this.fileLocation;
        }

        public SoundBuilder volume(float volume) {
            if (volume < 0.0f || volume > 1.0f) {
                throw new RuntimeException("Error volume for sound: '" + this.serializeLocation() + "' ,sound must be between 0.0 and 1.0 inclusive.");
            }
            this.volume = volume;
            return this;
        }

        public SoundBuilder pitch(float pitch) {
            this.pitch = pitch;
            return this;
        }

        public SoundBuilder weight(int weight) {
            if (weight < 1) {
                throw new RuntimeException("Error weight for sound: '" + this.serializeLocation() + "' ,weight must be at least 1.");
            }
            this.weight = weight;
            return this;
        }

        public SoundBuilder stream() {
            this.stream = true;
            return this;
        }

        public SoundBuilder attenuationDistance(int attenuationDistance) {
            if (attenuationDistance < 1) {
                throw new RuntimeException("Error attenuation distance for sound: '" + this.serializeLocation() + "' ,attenuation_distance must be at least 1.");
            }
            this.attenuationDistance = attenuationDistance;
            return this;
        }

        public SoundBuilder preload() {
            this.preload = true;
            return this;
        }

        public SoundBuilder type(SoundType type) {
            this.type = type;
            return this;
        }

        public JsonElement toJson() {
            JsonObject jsonObject = new JsonObject();
            boolean hasSettings = false;
            if (this.volume != 1.0f) {
                jsonObject.addProperty("volume", (Number)Float.valueOf(this.volume));
                hasSettings = true;
            }
            if (this.pitch != 1.0f) {
                jsonObject.addProperty("pitch", (Number)Float.valueOf(this.pitch));
                hasSettings = true;
            }
            if (this.weight != 1) {
                jsonObject.addProperty("weight", (Number)this.weight);
                hasSettings = true;
            }
            if (this.stream) {
                jsonObject.addProperty("stream", Boolean.valueOf(this.stream));
                hasSettings = true;
            }
            if (this.attenuationDistance != 16) {
                jsonObject.addProperty("attenuation_distance", (Number)this.attenuationDistance);
                hasSettings = true;
            }
            if (this.preload) {
                jsonObject.addProperty("preload", Boolean.valueOf(this.preload));
                hasSettings = true;
            }
            if (this.type != SoundType.SOUND) {
                jsonObject.addProperty("type", this.type.value);
                hasSettings = true;
            }
            if (hasSettings) {
                jsonObject.addProperty("name", this.serializeLocation());
                return jsonObject;
            }
            return new JsonPrimitive(this.serializeLocation());
        }

        private String serializeLocation() {
            if (this.fileLocation.func_110624_b().equals("minecraft")) {
                return this.fileLocation.func_110623_a();
            }
            return this.fileLocation.toString();
        }

        public static enum SoundType {
            SOUND("sound"),
            EVENT("event");

            private final String value;

            private SoundType(String value) {
                this.value = value;
            }
        }
    }

    public static class SoundEventBuilder {
        private final String path;
        private boolean replace;
        private String subtitle;
        private Map<ResourceLocation, SoundBuilder> soundBuilders = new HashMap<ResourceLocation, SoundBuilder>();

        public SoundEventBuilder(SoundEvent soundEvent) {
            this.path = soundEvent.getRegistryName().func_110623_a();
        }

        public static SoundEventBuilder create(SoundEvent soundEvent) {
            return new SoundEventBuilder(soundEvent);
        }

        public String getPath() {
            return this.path;
        }

        public SoundEventBuilder replace() {
            this.replace = true;
            return this;
        }

        public SoundEventBuilder subtitle(String subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        public SoundEventBuilder addSounds(SoundBuilder ... soundBuilders) {
            for (SoundBuilder soundBuilder : soundBuilders) {
                ResourceLocation location = soundBuilder.getFileLocation();
                if (this.soundBuilders.containsKey(location)) {
                    throw new RuntimeException("Sound '" + location + "' has already been added to this sound event.");
                }
                this.soundBuilders.put(location, soundBuilder);
            }
            return this;
        }

        public JsonElement toJson() {
            JsonObject jsonObject = new JsonObject();
            if (this.replace) {
                jsonObject.addProperty("replace", Boolean.valueOf(this.replace));
            }
            if (this.subtitle != null) {
                jsonObject.addProperty("subtitle", this.subtitle);
            }
            if (!this.soundBuilders.isEmpty()) {
                JsonArray sounds = new JsonArray();
                for (SoundBuilder soundBuilder : this.soundBuilders.values()) {
                    sounds.add(soundBuilder.toJson());
                }
                jsonObject.add("sounds", (JsonElement)sounds);
            }
            return jsonObject;
        }
    }
}

