/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regen.handlers;

import me.swirtzly.regen.Regeneration;
import me.swirtzly.regen.client.RKeybinds;
import me.swirtzly.regen.client.gui.PreferencesScreen;
import me.swirtzly.regen.client.rendering.entity.TimelordRenderer;
import me.swirtzly.regen.client.skin.SkinHandler;
import me.swirtzly.regen.common.regen.RegenCap;
import me.swirtzly.regen.common.regen.state.RegenStates;
import me.swirtzly.regen.common.regen.transitions.TransitionTypes;
import me.swirtzly.regen.util.RenderHelp;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effects;
import net.minecraft.util.MovementInput;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ClientEvents {
    private static final ResourceLocation BUTTON_TEX = new ResourceLocation("regen", "textures/gui/gui_button_customize.png");

    @SubscribeEvent
    public static void onGui(GuiScreenEvent.InitGuiEvent event) {
        if (event.getGui() instanceof InventoryScreen) {
            RegenCap.get((LivingEntity)Minecraft.func_71410_x().field_71439_g).ifPresent(data -> {
                if (data.canRegenerate()) {
                    event.addWidget((Widget)new ImageButton(((InventoryScreen)event.getGui()).getGuiLeft() + 134, event.getGui().field_230709_l_ / 2 - 22, 20, 20, 0, 0, 20, BUTTON_TEX, 32, 64, p_213088_1_ -> Minecraft.func_71410_x().func_147108_a((Screen)new PreferencesScreen())));
                }
            });
        }
    }

    @SubscribeEvent
    public static void onRenderPlayer(RenderPlayerEvent.Pre playerEvent) {
        SkinHandler.tick((AbstractClientPlayerEntity)playerEvent.getPlayer());
    }

    @SubscribeEvent
    public static void onRenderHand(RenderHandEvent event) {
        RegenCap.get((LivingEntity)Minecraft.func_71410_x().field_71439_g).ifPresent(iRegen -> iRegen.getTransitionType().get().getRenderer().firstPersonHand(event));
    }

    @SubscribeEvent
    public static void onTickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.START)) {
            return;
        }
        RKeybinds.tickKeybinds();
        if (Minecraft.func_71410_x().field_71441_e == null && SkinHandler.PLAYER_SKINS.size() > 0) {
            SkinHandler.PLAYER_SKINS.forEach((uuid, texture) -> Minecraft.func_71410_x().func_110434_K().func_147645_c(texture));
            SkinHandler.PLAYER_SKINS.clear();
            TimelordRenderer.TIMELORDS.forEach((uuid, texture) -> Minecraft.func_71410_x().func_110434_K().func_147645_c(texture));
            Regeneration.LOG.warn("Cleared Regeneration texture cache.");
        }
    }

    @SubscribeEvent
    public static void onColorFog(EntityViewRenderEvent.FogColors e) {
        Entity renderView = Minecraft.func_71410_x().func_175606_aa();
        if (!(Minecraft.func_71410_x().func_175606_aa() instanceof LivingEntity)) {
            return;
        }
        RegenCap.get((LivingEntity)renderView).ifPresent(data -> {
            if (data.getCurrentState() == RegenStates.GRACE_CRIT) {
                e.setRed(0.5f);
                e.setBlue(0.5f);
                e.setGreen(0.5f);
            }
            if (data.getTransitionType() == TransitionTypes.TROUGHTON && data.getCurrentState() == RegenStates.REGENERATING) {
                e.setRed(0.0f);
                e.setGreen(0.0f);
                e.setBlue(0.0f);
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onRenderOverlay(RenderGameOverlayEvent event) {
        if (!event.isCancelable() && event.getType() == RenderGameOverlayEvent.ElementType.HELMET) {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            RegenCap.get((LivingEntity)player).ifPresent(cap -> {
                String warning = null;
                TranslationTextComponent forceKeybind = new TranslationTextComponent(RKeybinds.FORCE_REGEN.func_197982_m().replace("key.keyboard.", ""));
                switch (cap.getCurrentState()) {
                    case GRACE: {
                        RenderHelp.renderVig(cap.getPrimaryColors(), 0.3f);
                        warning = new TranslationTextComponent("regeneration.messages.warning.grace", new Object[]{forceKeybind.getString()}).getString();
                        break;
                    }
                    case GRACE_CRIT: {
                        RenderHelp.renderVig(new Vector3d(1.0, 0.0, 0.0), 0.5f);
                        warning = new TranslationTextComponent("regeneration.messages.warning.grace_critical", new Object[]{forceKeybind.getString()}).getString();
                        break;
                    }
                    case REGENERATING: {
                        RenderHelp.renderVig(cap.getSecondaryColors(), 0.5f);
                        break;
                    }
                    case POST: {
                        if (player.field_70737_aN <= 0 && player.func_70660_b(Effects.field_76431_k) == null) break;
                        RenderHelp.renderVig(cap.getSecondaryColors(), 0.5f);
                    }
                }
                if (cap.areHandsGlowing()) {
                    RenderHelp.renderVig(TransitionTypes.FIERY.get().getDefaultPrimaryColor(), 0.5f);
                }
                IRenderTypeBuffer.Impl irendertypebuffer$impl = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
                if (warning != null) {
                    Minecraft.func_71410_x().field_71466_p.func_228079_a_(warning, (float)(Minecraft.func_71410_x().func_228018_at_().func_198107_o() / 2 - Minecraft.func_71410_x().field_71466_p.func_78256_a(warning) / 2), 4.0f, TextFormatting.WHITE.func_211163_e().intValue(), false, TransformationMatrix.func_227983_a_().func_227988_c_(), (IRenderTypeBuffer)irendertypebuffer$impl, false, 0, 0xF000F0);
                }
                irendertypebuffer$impl.func_228461_a_();
            });
        }
    }

    @SubscribeEvent
    public static void onSetupFogDensity(EntityViewRenderEvent.FogDensity event) {
        Entity viewer = Minecraft.func_71410_x().func_175606_aa();
        if (viewer != null) {
            RegenCap.get((LivingEntity)viewer).ifPresent(data -> {
                if (data.getCurrentState() == RegenStates.GRACE_CRIT) {
                    event.setCanceled(true);
                    float amount = MathHelper.func_76134_b((float)((float)data.getLiving().field_70173_aa * 0.02f)) * -0.1f;
                    event.setDensity(amount);
                }
                if (data.getTransitionType() == TransitionTypes.TROUGHTON && data.getTicksAnimating() > 0) {
                    event.setCanceled(true);
                    event.setDensity(0.3f);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onDeath(LivingDeathEvent e) {
        if (e.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)e.getEntityLiving();
            SkinHandler.PLAYER_SKINS.remove(player.func_110124_au());
            if (player.func_110124_au().equals(Minecraft.func_71410_x().field_71439_g.func_110124_au())) {
                SkinHandler.sendResetMessage();
            }
        }
    }

    @SubscribeEvent
    public static void keyInput(InputUpdateEvent e) {
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        RegenCap.get((LivingEntity)Minecraft.func_71410_x().field_71439_g).ifPresent(data -> {
            if (data.getCurrentState() == RegenStates.REGENERATING) {
                MovementInput moveType = e.getMovementInput();
                moveType.field_187258_f = false;
                moveType.field_187257_e = false;
                moveType.field_187256_d = false;
                moveType.field_78901_c = false;
                moveType.field_192832_b = 0.0f;
                moveType.field_228350_h_ = false;
                moveType.field_78902_a = 0.0f;
            }
        });
    }
}

