/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regen.handlers;

import com.mojang.brigadier.CommandDispatcher;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.swirtzly.regen.commands.RegenCommand;
import me.swirtzly.regen.common.regen.IRegen;
import me.swirtzly.regen.common.regen.RegenCap;
import me.swirtzly.regen.common.regen.state.RegenStates;
import me.swirtzly.regen.config.RegenConfig;
import me.swirtzly.regen.util.PlayerUtil;
import me.swirtzly.regen.util.RConstants;
import me.swirtzly.regen.util.RegenSources;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CommonEvents {
    @SubscribeEvent
    public static void attachCapabilities(final AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof LivingEntity) {
            event.addCapability(RConstants.CAP_REGEN_ID, (ICapabilityProvider)new ICapabilitySerializable<CompoundNBT>(){
                final RegenCap regen;
                final LazyOptional<IRegen> regenInstance;
                {
                    this.regen = new RegenCap((LivingEntity)event.getObject());
                    this.regenInstance = LazyOptional.of(() -> this.regen);
                }

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                    return cap == RegenCap.CAPABILITY ? this.regenInstance : LazyOptional.empty();
                }

                public CompoundNBT serializeNBT() {
                    return this.regen.serializeNBT();
                }

                public void deserializeNBT(CompoundNBT nbt) {
                    this.regen.deserializeNBT(nbt);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        RegenCap.get(livingEntity).ifPresent(iRegen -> {
            Entity trueSource = event.getSource().func_76346_g();
            if (trueSource instanceof PlayerEntity && event.getEntityLiving() != null) {
                PlayerEntity player = (PlayerEntity)trueSource;
                RegenCap.get((LivingEntity)player).ifPresent(data -> data.getStateManager().onPunchEntity(event));
            }
            if (event.getSource() == RegenSources.REGEN_DMG_CRITICAL || event.getSource() == RegenSources.REGEN_DMG_KILLED) {
                return;
            }
            iRegen.setDeathMessage(event.getSource().func_151519_b(livingEntity).getString());
            if (iRegen.getCurrentState() == RegenStates.POST) {
                event.setAmount(1.5f);
                PlayerUtil.sendMessage(livingEntity, new TranslationTextComponent("regeneration.messages.reduced_dmg"), true);
            }
            if (iRegen.getCurrentState() == RegenStates.REGENERATING && ((Boolean)RegenConfig.COMMON.regenFireImmune.get()).booleanValue() && event.getSource().func_76347_k() || iRegen.getCurrentState() == RegenStates.REGENERATING && event.getSource().func_94541_c()) {
                event.setCanceled(true);
            } else if (livingEntity.func_110143_aJ() + livingEntity.func_110139_bj() - event.getAmount() <= 0.0f) {
                boolean notDead = iRegen.getStateManager().onKilled(event.getSource());
                event.setCanceled(notDead);
            }
        });
    }

    @SubscribeEvent
    public static void onKnockback(LivingKnockBackEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        RegenCap.get(livingEntity).ifPresent(data -> event.setCanceled(data.getCurrentState() == RegenStates.REGENERATING));
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        Capability.IStorage storage = RegenCap.CAPABILITY.getStorage();
        event.getOriginal().revive();
        RegenCap.get((LivingEntity)event.getOriginal()).ifPresent(old -> RegenCap.get((LivingEntity)event.getPlayer()).ifPresent(data -> {
            CompoundNBT nbt = (CompoundNBT)storage.writeNBT(RegenCap.CAPABILITY, old, null);
            storage.readNBT(RegenCap.CAPABILITY, data, null, (INBT)nbt);
        }));
    }

    @SubscribeEvent
    public static void onTrackPlayer(PlayerEvent.StartTracking startTracking) {
        RegenCap.get((LivingEntity)startTracking.getPlayer()).ifPresent(iRegen -> iRegen.syncToClients(null));
    }

    @SubscribeEvent
    public static void onPunchBlock(PlayerInteractEvent.LeftClickBlock e) {
        if (e.getPlayer().field_70170_p.field_72995_K) {
            return;
        }
        RegenCap.get((LivingEntity)e.getPlayer()).ifPresent(data -> data.getStateManager().onPunchBlock(e));
    }

    @SubscribeEvent
    public static void onLive(LivingEvent.LivingUpdateEvent livingUpdateEvent) {
        RegenCap.get(livingUpdateEvent.getEntityLiving()).ifPresent(IRegen::tick);
    }

    @SubscribeEvent
    public static void onServerStart(FMLServerStartingEvent event) {
        CommandDispatcher dispatcher = event.getServer().func_195571_aL().func_197054_a();
        RegenCommand.register((CommandDispatcher<CommandSource>)dispatcher);
    }
}

