/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regen.network.messages;

import java.util.function.Supplier;
import me.swirtzly.regen.common.regen.RegenCap;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class SkinMessage {
    private final byte[] skinByteArray;
    private final boolean isAlex;

    public SkinMessage(byte[] skinByteArray, boolean isAlex) {
        this.skinByteArray = skinByteArray;
        this.isAlex = isAlex;
    }

    public SkinMessage(PacketBuffer buffer) {
        this.skinByteArray = buffer.func_189425_b(Integer.MAX_VALUE);
        this.isAlex = buffer.readBoolean();
    }

    public static void handle(SkinMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity serverPlayer = ((NetworkEvent.Context)ctx.get()).getSender();
            RegenCap.get((LivingEntity)serverPlayer).ifPresent(iRegen -> {
                iRegen.setSkin(message.skinByteArray);
                iRegen.setAlexSkin(message.isAlex);
                iRegen.syncToClients(null);
            });
        });
        ctx.get().setPacketHandled(true);
    }

    public void toBytes(PacketBuffer buffer) {
        buffer.func_179250_a(this.skinByteArray);
        buffer.writeBoolean(this.isAlex);
    }
}

