/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regen.util;

import java.util.ArrayList;
import java.util.List;
import me.swirtzly.regen.config.RegenConfig;
import me.swirtzly.regen.network.NetworkDispatcher;
import me.swirtzly.regen.network.messages.ModelMessage;
import me.swirtzly.regen.util.RegenSources;
import me.swirtzly.regen.util.RegenUtil;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.registries.ForgeRegistries;

public class PlayerUtil {
    public static ArrayList<Effect> POTIONS = new ArrayList();

    public static void setupPotions() {
        for (String name : (List)RegenConfig.COMMON.postRegenEffects.get()) {
            for (Effect effect : ForgeRegistries.POTIONS.getValues()) {
                if (!name.contentEquals(effect.getRegistryName().toString())) continue;
                POTIONS.add(effect);
            }
        }
    }

    public static void sendMessage(LivingEntity livingEntity, String message, boolean hotBar) {
        if (!(livingEntity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)livingEntity;
        if (!player.field_70170_p.field_72995_K) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent(message), hotBar);
        }
    }

    public static void sendMessage(LivingEntity livingEntity, TranslationTextComponent translation, boolean hotBar) {
        if (!(livingEntity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)livingEntity;
        if (!player.field_70170_p.field_72995_K) {
            player.func_146105_b((ITextComponent)translation, hotBar);
        }
    }

    public static void sendMessageToAll(TranslationTextComponent translation) {
        List players = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v();
        players.forEach(playerMP -> PlayerUtil.sendMessage((LivingEntity)playerMP, translation, false));
    }

    public static boolean applyPotionIfAbsent(LivingEntity player, Effect potion, int length, int amplifier, boolean ambient, boolean showParticles) {
        if (potion == null) {
            return false;
        }
        if (player.func_70660_b(potion) == null) {
            player.func_195064_c(new EffectInstance(potion, length, amplifier, ambient, showParticles));
            return true;
        }
        return false;
    }

    public static AxisAlignedBB getReach(BlockPos pos, int range) {
        return new AxisAlignedBB(pos.func_177981_b(range).func_177964_d(range).func_177985_f(range), pos.func_177979_c(range).func_177970_e(range).func_177965_g(range));
    }

    public static void explodeKnockback(Entity exploder, World world, BlockPos pos, double knockback, int range) {
        world.func_72839_b(exploder, PlayerUtil.getReach(pos, range)).forEach(entity -> {
            if (entity instanceof LivingEntity && exploder.func_70089_S()) {
                LivingEntity victim = (LivingEntity)entity;
                if (entity instanceof PlayerEntity && !((Boolean)RegenConfig.COMMON.regenerationKnocksbackPlayers.get()).booleanValue() || !victim.func_184222_aU()) {
                    return;
                }
                float densMod = Explosion.func_222259_a((Vector3d)entity.func_213303_ch(), (Entity)entity);
                int xr = (int)(-(victim.func_226277_ct_() - exploder.func_226277_ct_()));
                int zr = (int)(-(victim.func_226281_cx_() - exploder.func_226281_cx_()));
                victim.func_213317_d(victim.func_213322_ci().func_216372_d(knockback * (double)densMod, (double)xr, (double)zr));
            }
        });
    }

    public static void regenerationExplosion(LivingEntity player) {
        PlayerUtil.explodeKnockback((Entity)player, player.field_70170_p, new BlockPos(player.func_213303_ch()), (Double)RegenConfig.COMMON.regenerativeKnockback.get(), (Integer)RegenConfig.COMMON.regenKnockbackRange.get());
        PlayerUtil.explodeKill((Entity)player, player.field_70170_p, new BlockPos(player.func_213303_ch()), (Integer)RegenConfig.COMMON.regenerativeKillRange.get());
    }

    public static void explodeKill(Entity exploder, World world, BlockPos pos, int range) {
        world.func_72839_b(exploder, PlayerUtil.getReach(pos, range)).forEach(entity -> {
            if (entity instanceof CreatureEntity && entity.func_184222_aU() || entity instanceof PlayerEntity) {
                entity.func_70097_a(RegenSources.REGEN_DMG_ENERGY_EXPLOSION, 3.5f);
            }
        });
    }

    public static void updateModel(SkinType choices) {
        NetworkDispatcher.NETWORK_CHANNEL.sendToServer((Object)new ModelMessage(choices));
    }

    public static enum SkinType implements RegenUtil.IEnum<SkinType>
    {
        ALEX,
        STEVE,
        EITHER;


        public boolean isAlex() {
            if (this == EITHER) {
                return RegenUtil.RAND.nextBoolean();
            }
            return this == ALEX;
        }
    }
}

