/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regen.util;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.net.URL;
import java.util.Random;
import me.swirtzly.regen.client.skin.CommonSkin;
import me.swirtzly.regen.common.regen.RegenCap;
import me.swirtzly.regen.util.PlayerUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.LivingEntity;
import org.apache.commons.io.FileUtils;

public class RegenUtil {
    public static Random RAND = new Random();

    public static float randFloat(float min, float max) {
        return RAND.nextFloat() * (max - min) + min;
    }

    public static boolean doesHaveInternet() {
        try {
            Socket socket = new Socket("www.google.com", 80);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getJsonFromURL(String URL2) {
        URL url = null;
        try {
            url = new URL(URL2);
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            return RegenUtil.bufferedReaderToString(in);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String bufferedReaderToString(BufferedReader e) {
        StringBuilder builder = new StringBuilder();
        String aux = "";
        try {
            while ((aux = e.readLine()) != null) {
                builder.append(aux);
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return builder.toString();
    }

    public static byte[] fileToBytes(File file) {
        try {
            return FileUtils.readFileToByteArray((File)file);
        }
        catch (IOException e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    public static String colorToHex(Color color) {
        StringBuilder hex = new StringBuilder(Integer.toHexString(color.getRGB() & 0xFFFFFF));
        while (hex.length() < 6) {
            hex.insert(0, "0");
        }
        return "#" + hex;
    }

    public static CrashReport crashReport(CrashReport crashReport) {
        CrashReportCategory crashreportcategory = crashReport.func_85058_a("Regen Client Info");
        crashreportcategory.func_71507_a("Alex Skins", (Object)CommonSkin.listAllSkins(PlayerUtil.SkinType.ALEX).size());
        crashreportcategory.func_71507_a("Steve Skins", (Object)CommonSkin.listAllSkins(PlayerUtil.SkinType.STEVE).size());
        RegenCap.get((LivingEntity)Minecraft.func_71410_x().field_71439_g).ifPresent(iRegen -> crashreportcategory.func_71507_a("Preferred Model", (Object)iRegen.getPreferredModel().name()));
        return crashReport;
    }

    public static interface IEnum<E extends Enum<E>> {
        public int ordinal();

        default public E next() {
            Enum[] ies = this.getAllValues();
            return (E)(this.ordinal() != ies.length - 1 ? ies[this.ordinal() + 1] : null);
        }

        default public E previous() {
            return (E)(this.ordinal() != 0 ? this.getAllValues()[this.ordinal() - 1] : null);
        }

        default public E[] getAllValues() {
            IEnum[] ies = (IEnum[])this.getClass().getEnumConstants();
            return (Enum[])ies;
        }
    }
}

