/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures;

import com.telepathicgrunt.repurposedstructures.RSAddFeatures;
import com.telepathicgrunt.repurposedstructures.RSFeatures;
import com.telepathicgrunt.repurposedstructures.configs.RSDungeonsConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSMainConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSMineshaftsConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSOutpostsConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSShipwrecksConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSStrongholdsConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSTemplesConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSVillagesConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSWellsConfig;
import com.telepathicgrunt.repurposedstructures.misc.VillagerTradesModification;
import com.telepathicgrunt.repurposedstructures.utils.ConfigHelper;
import com.telepathicgrunt.repurposedstructures.utils.MobSpawnerManager;
import com.telepathicgrunt.repurposedstructures.world.placements.RSPlacements;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.EnumMap;
import java.util.Set;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="repurposed_structures")
public class RepurposedStructures {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "repurposed_structures";
    public static RSMainConfig.RSConfigValues RSMainConfig = null;
    public static RSDungeonsConfig.RSDungeonsConfigValues RSDungeonsConfig = null;
    public static RSMineshaftsConfig.RSMineshaftsConfigValues RSMineshaftsConfig = null;
    public static RSStrongholdsConfig.RSStrongholdsConfigValues RSStrongholdsConfig = null;
    public static RSWellsConfig.RSWellsConfigValues RSWellsConfig = null;
    public static RSOutpostsConfig.RSOutpostsConfigValues RSOutpostsConfig = null;
    public static RSVillagesConfig.RSVillagesConfigValues RSVillagesConfig = null;
    public static RSTemplesConfig.RSTemplesConfigValues RSTemplesConfig = null;
    public static RSShipwrecksConfig.RSShipwrecksConfigValues RSShipwrecksConfig = null;
    public static MobSpawnerManager mobSpawnerManager = null;

    public RepurposedStructures() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::setup);
        RSMainConfig = ConfigHelper.register(ModConfig.Type.COMMON, RSMainConfig.RSConfigValues::new, "repurposed_structures-common.toml");
        RSDungeonsConfig = ConfigHelper.register(ModConfig.Type.COMMON, RSDungeonsConfig.RSDungeonsConfigValues::new, "repurposed_structures-dungeons.toml");
        RSMineshaftsConfig = ConfigHelper.register(ModConfig.Type.COMMON, RSMineshaftsConfig.RSMineshaftsConfigValues::new, "repurposed_structures-mineshafts.toml");
        RSStrongholdsConfig = ConfigHelper.register(ModConfig.Type.COMMON, RSStrongholdsConfig.RSStrongholdsConfigValues::new, "repurposed_structures-strongholds.toml");
        RSWellsConfig = ConfigHelper.register(ModConfig.Type.COMMON, RSWellsConfig.RSWellsConfigValues::new, "repurposed_structures-wells.toml");
        RSShipwrecksConfig = ConfigHelper.register(ModConfig.Type.COMMON, RSShipwrecksConfig.RSShipwrecksConfigValues::new, "repurposed_structures-shipwrecks.toml");
        RSOutpostsConfig = ConfigHelper.register(ModConfig.Type.COMMON, RSOutpostsConfig.RSOutpostsConfigValues::new, "repurposed_structures-outposts.toml");
        RSTemplesConfig = ConfigHelper.register(ModConfig.Type.COMMON, RSTemplesConfig.RSTemplesConfigValues::new, "repurposed_structures-temples.toml");
        RSVillagesConfig = ConfigHelper.register(ModConfig.Type.COMMON, RSVillagesConfig.RSVillagesConfigValues::new, "repurposed_structures-villages.toml");
    }

    public void setup(FMLCommonSetupEvent event) {
        DeferredWorkQueue.runLater(RepurposedStructures::addFeaturesAndStructuresToBiomes);
        DeferredWorkQueue.runLater(VillagerTradesModification::addMapTrades);
    }

    private static void addFeaturesAndStructuresToBiomes() {
        for (Biome biome : ForgeRegistries.BIOMES) {
            RepurposedStructures.addFeaturesAndStructuresToBiomes(biome, biome.getRegistryName());
        }
        RSFeatures.registerVillagePools();
    }

    public static void addFeaturesAndStructuresToBiomes(Biome biome, ResourceLocation biomeID) {
        String biomeNamespace = biomeID.func_110624_b();
        String biomePath = biomeID.func_110623_a();
        RSAddFeatures.addMineshafts(biome, biomeNamespace, biomePath);
        RSAddFeatures.addJungleFortress(biome, biomeNamespace, biomePath);
        RSAddFeatures.addDungeons(biome, biomeNamespace, biomePath);
        RSAddFeatures.addWells(biome, biomeNamespace, biomePath);
        RSAddFeatures.addMiscFeatures(biome, biomeNamespace, biomePath);
        RSAddFeatures.addTemplesAndPyramids(biome, biomeNamespace, biomePath);
        RSAddFeatures.addIgloos(biome, biomeNamespace, biomePath);
        RSAddFeatures.addOutposts(biome, biomeNamespace, biomePath);
        RSAddFeatures.addShipwrecks(biome, biomeNamespace, biomePath);
        RSAddFeatures.addVillages(biome, biomeNamespace, biomePath);
        RSAddFeatures.addStrongholds(biome, biomeNamespace, biomePath);
    }

    private static void loadRSConfigs() {
        try {
            Field fld = ConfigTracker.class.getDeclaredField("configSets");
            fld.setAccessible(true);
            Class[] partypes = new Class[]{ModConfig.class, Path.class};
            Method method = ConfigTracker.class.getDeclaredMethod("openConfig", partypes);
            method.setAccessible(true);
            for (ModConfig modConfig : (Set)((EnumMap)fld.get(ConfigTracker.INSTANCE)).get(ModConfig.Type.COMMON)) {
                if (!modConfig.getModId().equals(MODID)) continue;
                Object[] arglist = new Object[]{modConfig, FMLPaths.CONFIGDIR.get()};
                method.invoke((Object)ConfigTracker.INSTANCE, arglist);
            }
            fld.setAccessible(false);
            method.setAccessible(false);
        }
        catch (Throwable e) {
            System.err.println(e);
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ForgeEvents {
        @SubscribeEvent
        public static void registerDatapackListener(AddReloadListenerEvent event) {
            mobSpawnerManager = new MobSpawnerManager();
            event.addListener((IFutureReloadListener)mobSpawnerManager);
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onRegisterFeatures(RegistryEvent.Register<Feature<?>> event) {
            RepurposedStructures.loadRSConfigs();
            RSFeatures.registerFeatures(event);
        }

        @SubscribeEvent
        public static void onRegisterPlacements(RegistryEvent.Register<Placement<?>> event) {
            RepurposedStructures.loadRSConfigs();
            RSPlacements.registerPlacements(event);
        }
    }
}

