/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.mixin;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.telepathicgrunt.repurposedstructures.RSFeatures;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.NoiseChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructureManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={NoiseChunkGenerator.class})
public class StructureMobSpawningMixin {
    @Inject(method={"getEntitySpawnList(Lnet/minecraft/world/biome/Biome;Lnet/minecraft/world/gen/feature/structure/StructureManager;Lnet/minecraft/entity/EntityClassification;Lnet/minecraft/util/math/BlockPos;)Ljava/util/List;"}, at={@At(value="HEAD")}, cancellable=true)
    private void locateRSStrongholds(Biome biome, StructureManager accessor, EntityClassification group, BlockPos pos, CallbackInfoReturnable<List<Biome.SpawnListEntry>> cir) {
        List<Biome.SpawnListEntry> list = StructureMobSpawningMixin.getStructureSpawns(biome, accessor, group, pos);
        if (list != null) {
            cir.setReturnValue(list);
        }
    }

    private static List<Biome.SpawnListEntry> getStructureSpawns(Biome biome, StructureManager accessor, EntityClassification group, BlockPos pos) {
        if (group == EntityClassification.MONSTER) {
            if (accessor.func_235010_a_(pos, true, RSFeatures.NETHER_BRICK_OUTPOST).func_75069_d()) {
                return RSFeatures.NETHER_BRICK_OUTPOST.func_202279_e();
            }
            if (accessor.func_235010_a_(pos, true, RSFeatures.WARPED_OUTPOST).func_75069_d()) {
                return RSFeatures.WARPED_OUTPOST.func_202279_e();
            }
            if (accessor.func_235010_a_(pos, true, RSFeatures.CRIMSON_OUTPOST).func_75069_d()) {
                return RSFeatures.CRIMSON_OUTPOST.func_202279_e();
            }
            if (accessor.func_235010_a_(pos, true, RSFeatures.NETHER_STRONGHOLD).func_75069_d()) {
                return RSFeatures.NETHER_STRONGHOLD.func_202279_e();
            }
            if (accessor.func_235010_a_(pos, true, RSFeatures.JUNGLE_FORTRESS).func_75069_d()) {
                return Lists.newArrayList((Iterator)Iterators.concat(biome.func_76747_a(EntityClassification.MONSTER).iterator(), RSFeatures.JUNGLE_FORTRESS.func_202279_e().iterator()));
            }
            if (accessor.func_235010_a_(pos, true, RSFeatures.END_MINESHAFT).func_75069_d()) {
                return Lists.newArrayList((Iterator)Iterators.concat(biome.func_76747_a(EntityClassification.MONSTER).iterator(), RSFeatures.END_MINESHAFT.func_202279_e().iterator()));
            }
        }
        return null;
    }
}

