/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.RSFeatures;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LanternBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.StructureManager;

public class StrongholdChains
extends Feature<NoFeatureConfig> {
    private static final Predicate<BlockState> STRONGHOLD_BLOCKS = blockState -> {
        if (blockState == null) {
            return false;
        }
        return blockState.func_203425_a(Blocks.field_196653_dH) || blockState.func_203425_a(Blocks.field_196817_hS) || blockState.func_203425_a(Blocks.field_196814_hQ) || blockState.func_203425_a(Blocks.field_235406_np_) || blockState.func_203425_a(Blocks.field_235410_nt_) || blockState.func_203425_a(Blocks.field_235411_nu_) || blockState.func_203425_a(Blocks.field_235412_nv_) || blockState.func_203425_a(Blocks.field_235413_nw_) || blockState.func_203425_a(Blocks.field_235387_nA_) || blockState.func_203425_a(Blocks.field_196722_fD) || blockState.func_203425_a(Blocks.field_150347_e) || blockState.func_203425_a(Blocks.field_196696_di) || blockState.func_203425_a(Blocks.field_196702_dl) || blockState.func_203425_a(Blocks.field_196700_dk) || blockState.func_203425_a(Blocks.field_196698_dj) || blockState.func_203425_a(Blocks.field_196694_dh) || blockState.func_203425_a(Blocks.field_196692_dg) || blockState.func_203425_a(Blocks.field_196688_de) || blockState.func_203425_a(Blocks.field_196690_df);
    };

    public StrongholdChains(Codec<NoFeatureConfig> configFactory) {
        super(configFactory);
    }

    public boolean generate(ISeedReader world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, Random random, BlockPos position, NoFeatureConfig config) {
        if (!world.func_175623_d(position) || !structureAccessor.func_235011_a_(SectionPos.func_218167_a((BlockPos)position), RSFeatures.STONEBRICK_STRONGHOLD).findAny().isPresent() && !structureAccessor.func_235011_a_(SectionPos.func_218167_a((BlockPos)position), RSFeatures.NETHER_STRONGHOLD).findAny().isPresent()) {
            return false;
        }
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable().func_189533_g((Vector3i)position);
        for (int i = 0; i < 10 && world.func_175623_d(blockpos$Mutable.func_177984_a()) && blockpos$Mutable.func_177956_o() < 255; ++i) {
            blockpos$Mutable.func_189536_c(Direction.UP);
        }
        int length = 0;
        while (blockpos$Mutable.func_177956_o() > 3 && length < random.nextInt(random.nextInt(random.nextInt(8) + 1) + 1) + 1) {
            if (world.func_175623_d((BlockPos)blockpos$Mutable)) {
                BlockState aboveBlockstate = world.func_180495_p(blockpos$Mutable.func_177984_a());
                if (STRONGHOLD_BLOCKS.test(aboveBlockstate) || aboveBlockstate.func_203425_a(Blocks.field_235341_dI_)) {
                    world.func_180501_a((BlockPos)blockpos$Mutable, Blocks.field_235341_dI_.func_176223_P(), 2);
                    ++length;
                }
            } else {
                return true;
            }
            blockpos$Mutable.func_189536_c(Direction.DOWN);
        }
        if (random.nextFloat() < 0.075f && world.func_175623_d((BlockPos)blockpos$Mutable)) {
            if (world.func_226691_t_((BlockPos)blockpos$Mutable).func_201856_r() == Biome.Category.NETHER) {
                world.func_180501_a((BlockPos)blockpos$Mutable, (BlockState)Blocks.field_235366_md_.func_176223_P().func_206870_a((Property)LanternBlock.field_220278_a, (Comparable)Boolean.valueOf(true)), 2);
            } else {
                world.func_180501_a((BlockPos)blockpos$Mutable, (BlockState)Blocks.field_222432_lU.func_176223_P().func_206870_a((Property)LanternBlock.field_220278_a, (Comparable)Boolean.valueOf(true)), 2);
            }
        }
        return true;
    }
}

