/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.world.features.WellAbstract;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.template.Template;

public class WellMossyStone
extends WellAbstract {
    private static final float ORE_CHANCE = 0.12f;
    private static final ResourceLocation MOSSY_WELL_ORE_RL = new ResourceLocation("repurposed_structures:mossy_well_ores");
    private static final ResourceLocation MOSSY_WELL_RL = new ResourceLocation("repurposed_structures:wells/mossy");

    public WellMossyStone(Codec<NoFeatureConfig> config) {
        super(config);
    }

    public boolean generate(ISeedReader world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, Random random, BlockPos position, NoFeatureConfig config) {
        BlockPos.Mutable mutable = new BlockPos.Mutable().func_189533_g((Vector3i)position);
        mutable.func_189536_c(Direction.UP);
        while ((world.func_175623_d((BlockPos)mutable) || !world.func_204610_c((BlockPos)mutable).func_206888_e()) && mutable.func_177956_o() > 2) {
            mutable.func_189536_c(Direction.DOWN);
        }
        BlockState block = world.func_180495_p((BlockPos)mutable);
        if (!(!BlockTags.field_203436_u.func_230235_a_((Object)block.func_177230_c()) && !block.func_203425_a(Blocks.field_150435_aG) && !WellMossyStone.func_227250_b_((Block)block.func_177230_c()) || world.func_175623_d(mutable.func_177977_b()) && world.func_175623_d(mutable.func_177979_c(2)))) {
            mutable.func_189536_c(Direction.DOWN);
            Template template = this.generateTemplate(MOSSY_WELL_RL, world, random, (BlockPos)mutable);
            this.handleDataBlocks(MOSSY_WELL_ORE_RL, template, world, random, (BlockPos)mutable, Blocks.field_150347_e, 0.12f);
            BlockPos offset = new BlockPos(-template.func_186259_a().func_177958_n() / 2, 0, -template.func_186259_a().func_177952_p() / 2);
            BlockPos.func_229383_a_((MutableBoundingBox)template.func_215388_b(this.placementsettings, mutable.func_177971_a((Vector3i)offset))).forEach(pos -> WellMossyStone.mossifyBlocks(world, random, pos));
            BlockPos.func_229383_a_((MutableBoundingBox)template.func_215388_b(this.placementsettings, mutable.func_177971_a((Vector3i)offset))).forEach(pos -> WellMossyStone.waterlogBlocks(world, pos));
            return true;
        }
        return false;
    }

    private static void mossifyBlocks(ISeedReader world, Random random, BlockPos position) {
        BlockState block = world.func_180495_p(position);
        if (block.func_203425_a(Blocks.field_196696_di) && random.nextFloat() < 0.6f) {
            world.func_180501_a(position, Blocks.field_196698_dj.func_176223_P(), 2);
        } else if (block.func_203425_a(Blocks.field_222413_lB) && random.nextFloat() < 0.6f) {
            world.func_180501_a(position, Blocks.field_222462_lz.func_176223_P(), 2);
        } else if (block.func_203425_a(Blocks.field_196573_bB) && random.nextFloat() < 0.6f) {
            world.func_180501_a(position, Blocks.field_222448_ll.func_176223_P(), 2);
        } else if (block.func_203425_a(Blocks.field_150347_e) && random.nextFloat() < 0.5f) {
            world.func_180501_a(position, Blocks.field_150341_Y.func_176223_P(), 2);
        }
    }

    private static void waterlogBlocks(ISeedReader world, BlockPos position) {
        BlockState blockstate = world.func_180495_p(position);
        if (position.func_177956_o() < world.func_181545_F() && blockstate.func_235901_b_((Property)BlockStateProperties.field_208198_y)) {
            world.func_180501_a(position, (BlockState)blockstate.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true)), 2);
        }
    }
}

