/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features.structures;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.RSFeatures;
import com.telepathicgrunt.repurposedstructures.world.features.structures.AbstractBaseStructure;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.MarginedStructureStart;
import net.minecraft.world.gen.feature.structure.Structure;

public abstract class AbstractNetherStructure
extends AbstractBaseStructure {
    public AbstractNetherStructure(Codec<NoFeatureConfig> config) {
        super(config);
    }

    protected boolean shouldStartAt(ChunkGenerator chunkGenerator, BiomeProvider biomeSource, long seed, SharedSeedRandom chunkRandom, int chunkX, int chunkZ, Biome biome, ChunkPos chunkPos, NoFeatureConfig defaultFeatureConfig) {
        ChunkPos chunkPos2;
        int curChunkZ;
        int curChunkX;
        if (this != RSFeatures.WARPED_OUTPOST && this != RSFeatures.CRIMSON_OUTPOST && this != RSFeatures.NETHER_BRICK_OUTPOST) {
            for (curChunkX = chunkX - 6; curChunkX <= chunkX + 6; ++curChunkX) {
                for (curChunkZ = chunkZ - 6; curChunkZ <= chunkZ + 6; ++curChunkZ) {
                    chunkPos2 = RSFeatures.WARPED_OUTPOST.func_236392_a_(chunkGenerator.func_235957_b_().func_236197_a_(RSFeatures.WARPED_OUTPOST), seed, chunkRandom, curChunkX, curChunkZ);
                    if (curChunkX == chunkPos2.field_77276_a && curChunkZ == chunkPos2.field_77275_b) {
                        return false;
                    }
                    chunkPos2 = RSFeatures.CRIMSON_OUTPOST.func_236392_a_(chunkGenerator.func_235957_b_().func_236197_a_(RSFeatures.CRIMSON_OUTPOST), seed, chunkRandom, curChunkX, curChunkZ);
                    if (curChunkX == chunkPos2.field_77276_a && curChunkZ == chunkPos2.field_77275_b) {
                        return false;
                    }
                    chunkPos2 = RSFeatures.NETHER_BRICK_OUTPOST.func_236392_a_(chunkGenerator.func_235957_b_().func_236197_a_(RSFeatures.NETHER_BRICK_OUTPOST), seed, chunkRandom, curChunkX, curChunkZ);
                    if (curChunkX != chunkPos2.field_77276_a || curChunkZ != chunkPos2.field_77275_b) continue;
                    return false;
                }
            }
        }
        for (curChunkX = chunkX - 3; curChunkX <= chunkX + 3; ++curChunkX) {
            for (curChunkZ = chunkZ - 3; curChunkZ <= chunkZ + 3; ++curChunkZ) {
                chunkPos2 = RSFeatures.NETHER_PYRAMID.func_236392_a_(chunkGenerator.func_235957_b_().func_236197_a_(RSFeatures.NETHER_PYRAMID), seed, chunkRandom, curChunkX, curChunkZ);
                if (curChunkX != chunkPos2.field_77276_a || curChunkZ != chunkPos2.field_77275_b) continue;
                return false;
            }
        }
        return super.func_230363_a_(chunkGenerator, biomeSource, seed, chunkRandom, chunkX, chunkZ, biome, chunkPos, (IFeatureConfig)defaultFeatureConfig);
    }

    public static abstract class AbstractStart
    extends MarginedStructureStart<NoFeatureConfig> {
        public AbstractStart(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        public BlockPos getHighestLand(ChunkGenerator chunkGenerator) {
            BlockPos.Mutable mutable = new BlockPos.Mutable().func_181079_c(this.field_75074_b.func_215126_f().func_177958_n(), 108, this.field_75074_b.func_215126_f().func_177952_p());
            IBlockReader blockView = chunkGenerator.func_230348_a_(mutable.func_177958_n(), mutable.func_177952_p());
            while (mutable.func_177956_o() > 33) {
                BlockState currentBlockstate = blockView.func_180495_p((BlockPos)mutable);
                if (!currentBlockstate.func_215686_e(blockView, (BlockPos)mutable)) {
                    mutable.func_189536_c(Direction.DOWN);
                    continue;
                }
                if (blockView.func_180495_p(mutable.func_177982_a(0, 3, 0)).func_185904_a() == Material.field_151579_a && this.isValidBlock(currentBlockstate)) break;
                mutable.func_189536_c(Direction.DOWN);
            }
            return mutable;
        }

        public BlockPos getLowestLand(ChunkGenerator chunkGenerator) {
            BlockPos.Mutable mutable = new BlockPos.Mutable().func_181079_c(this.field_75074_b.func_215126_f().func_177958_n(), 35, this.field_75074_b.func_215126_f().func_177952_p());
            IBlockReader blockView = chunkGenerator.func_230348_a_(mutable.func_177958_n(), mutable.func_177952_p());
            BlockState currentBlockstate = blockView.func_180495_p((BlockPos)mutable);
            while (mutable.func_177956_o() <= 108) {
                if (blockView.func_180495_p((BlockPos)mutable).func_185904_a() != Material.field_151579_a && blockView.func_180495_p(mutable.func_177984_a()).func_185904_a() == Material.field_151579_a && blockView.func_180495_p(mutable.func_177981_b(5)).func_185904_a() == Material.field_151579_a && this.isValidBlock(currentBlockstate)) {
                    mutable.func_189536_c(Direction.UP);
                    break;
                }
                mutable.func_189536_c(Direction.UP);
                currentBlockstate = blockView.func_180495_p((BlockPos)mutable);
            }
            return mutable;
        }

        private boolean isValidBlock(BlockState currentBlockstate) {
            return BlockTags.field_241278_aD_.func_230235_a_((Object)currentBlockstate.func_177230_c()) || BlockTags.field_205599_H.func_230235_a_((Object)currentBlockstate.func_177230_c()) || BlockTags.field_203436_u.func_230235_a_((Object)currentBlockstate.func_177230_c()) || BlockTags.field_232873_an_.func_230235_a_((Object)currentBlockstate.func_177230_c()) || BlockTags.field_205213_E.func_230235_a_((Object)currentBlockstate.func_177230_c()) || BlockTags.field_199898_b.func_230235_a_((Object)currentBlockstate.func_177230_c()) || BlockTags.field_200026_c.func_230235_a_((Object)currentBlockstate.func_177230_c()) || BlockTags.field_219755_X.func_230235_a_((Object)currentBlockstate.func_177230_c()) || BlockTags.field_199897_a.func_230235_a_((Object)currentBlockstate.func_177230_c()) || currentBlockstate.func_185904_a() == Material.field_151595_p || currentBlockstate.func_185904_a() == Material.field_151576_e || currentBlockstate.func_185904_a() == Material.field_151578_c;
        }
    }
}

