/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features.structures;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.RSFeatures;
import com.telepathicgrunt.repurposedstructures.world.features.structures.AbstractBaseStructure;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.MarginedStructureStart;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.structure.VillagePieces;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.gen.settings.StructureSeparationSettings;

public abstract class AbstractVillageStructure
extends Structure<NoFeatureConfig> {
    public AbstractVillageStructure(Codec<NoFeatureConfig> config) {
        super(config);
    }

    public abstract Structure<NoFeatureConfig> getVillageInstance();

    protected boolean shouldStartAt(ChunkGenerator chunkGenerator, BiomeProvider biomeSource, long seed, SharedSeedRandom chunkRandom, int chunkX, int chunkZ, Biome biome, ChunkPos chunkPos, NoFeatureConfig NoFeatureConfig2) {
        for (int curChunkX = chunkX - 1; curChunkX <= chunkX + 1; ++curChunkX) {
            for (int curChunkZ = chunkZ - 1; curChunkZ <= chunkZ + 1; ++curChunkZ) {
                if (biomeSource.func_225526_b_(curChunkX << 2, 60, curChunkZ << 2).func_201858_a(this.getVillageInstance())) continue;
                return false;
            }
        }
        return true;
    }

    public BlockPos func_236388_a_(IWorldReader worldView, StructureManager structureAccessor, BlockPos blockPos, int radius, boolean skipExistingChunks, long seed, StructureSeparationSettings structureConfig) {
        return AbstractBaseStructure.locateStructureFast(worldView, structureAccessor, blockPos, radius, skipExistingChunks, seed, structureConfig, this);
    }

    public static abstract class AbstractStart
    extends MarginedStructureStart<NoFeatureConfig> {
        private static boolean initalizedPools = false;

        public AbstractStart(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        public abstract ResourceLocation getResourceLocation();

        public abstract int getSize();

        public void init(ChunkGenerator chunkGenerator, TemplateManager structureManager, int chunkX, int chunkZ, Biome biome, NoFeatureConfig NoFeatureConfig2) {
            if (!initalizedPools) {
                RSFeatures.registerVillagePools();
                initalizedPools = true;
            }
            BlockPos blockpos = new BlockPos(chunkX * 16, 0, chunkZ * 16);
            VillagePieces.func_214838_a((ChunkGenerator)chunkGenerator, (TemplateManager)structureManager, (BlockPos)blockpos, (List)this.field_75075_a, (SharedSeedRandom)this.field_214631_d, (VillageConfig)new VillageConfig(this.getResourceLocation(), this.getSize()));
            this.func_202500_a();
        }
    }
}

