/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features.structures;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.world.features.structures.AbstractBaseStructure;
import com.telepathicgrunt.repurposedstructures.world.features.structures.GeneralJigsawGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.SingleJigsawPiece;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class EndShipwreckStructure
extends AbstractBaseStructure {
    public EndShipwreckStructure(Codec<NoFeatureConfig> config) {
        super(config);
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    protected boolean shouldStartAt(ChunkGenerator generator, BiomeProvider biomeProvider, long seed, SharedSeedRandom random, int x, int z, Biome biome, ChunkPos chunkPos, NoFeatureConfig config) {
        return EndShipwreckStructure.getYPosForStructure(x, z, generator) >= 20;
    }

    private static int getYPosForStructure(int x, int z, ChunkGenerator generator) {
        Random random = new Random(x + z * 10387313);
        Rotation rotation = Rotation.func_222466_a((Random)random);
        int i = 5;
        int j = 5;
        if (rotation == Rotation.CLOCKWISE_90) {
            i = -5;
        } else if (rotation == Rotation.CLOCKWISE_180) {
            i = -5;
            j = -5;
        } else if (rotation == Rotation.COUNTERCLOCKWISE_90) {
            j = -5;
        }
        int k = (x << 4) + 7;
        int l = (z << 4) + 7;
        int i1 = generator.func_222531_c(k, l, Heightmap.Type.WORLD_SURFACE_WG);
        int j1 = generator.func_222531_c(k, l + j, Heightmap.Type.WORLD_SURFACE_WG);
        int k1 = generator.func_222531_c(k + i, l, Heightmap.Type.WORLD_SURFACE_WG);
        int l1 = generator.func_222531_c(k + i, l + j, Heightmap.Type.WORLD_SURFACE_WG);
        return Math.min(Math.min(i1, j1), Math.min(k1, l1));
    }

    static {
        JigsawManager.field_214891_a.func_214932_a(new JigsawPattern(new ResourceLocation("repurposed_structures", "shipwrecks/end"), new ResourceLocation("empty"), (List)ImmutableList.of((Object)Pair.of((Object)new SingleJigsawPiece("repurposed_structures:shipwrecks/end/rightsideup_backhalf", new ArrayList()), (Object)1), (Object)Pair.of((Object)new SingleJigsawPiece("repurposed_structures:shipwrecks/end/rightsideup_backhalf_degraded", new ArrayList()), (Object)1), (Object)Pair.of((Object)new SingleJigsawPiece("repurposed_structures:shipwrecks/end/rightsideup_fronthalf", new ArrayList()), (Object)1), (Object)Pair.of((Object)new SingleJigsawPiece("repurposed_structures:shipwrecks/end/rightsideup_fronthalf_degraded", new ArrayList()), (Object)1), (Object)Pair.of((Object)new SingleJigsawPiece("repurposed_structures:shipwrecks/end/rightsideup_full", new ArrayList()), (Object)1), (Object)Pair.of((Object)new SingleJigsawPiece("repurposed_structures:shipwrecks/end/rightsideup_full_degraded", new ArrayList()), (Object)1), (Object)Pair.of((Object)new SingleJigsawPiece("repurposed_structures:shipwrecks/end/sideways_backhalf", new ArrayList()), (Object)1), (Object)Pair.of((Object)new SingleJigsawPiece("repurposed_structures:shipwrecks/end/sideways_backhalf_degraded", new ArrayList()), (Object)1), (Object)Pair.of((Object)new SingleJigsawPiece("repurposed_structures:shipwrecks/end/sideways_fronthalf", new ArrayList()), (Object)1), (Object)Pair.of((Object)new SingleJigsawPiece("repurposed_structures:shipwrecks/end/sideways_fronthalf_degraded", new ArrayList()), (Object)1), (Object)Pair.of((Object)new SingleJigsawPiece("repurposed_structures:shipwrecks/end/sideways_full", new ArrayList()), (Object)1), (Object)Pair.of((Object)new SingleJigsawPiece("repurposed_structures:shipwrecks/end/sideways_full_degraded", new ArrayList()), (Object)1), (Object[])new Pair[]{Pair.of((Object)new SingleJigsawPiece("repurposed_structures:shipwrecks/end/upsidedown_backhalf", new ArrayList()), (Object)1), Pair.of((Object)new SingleJigsawPiece("repurposed_structures:shipwrecks/end/upsidedown_backhalf_degraded", new ArrayList()), (Object)1), Pair.of((Object)new SingleJigsawPiece("repurposed_structures:shipwrecks/end/upsidedown_fronthalf_degraded", new ArrayList()), (Object)1), Pair.of((Object)new SingleJigsawPiece("repurposed_structures:shipwrecks/end/upsidedown_fronthalf", new ArrayList()), (Object)1), Pair.of((Object)new SingleJigsawPiece("repurposed_structures:shipwrecks/end/upsidedown_full", new ArrayList()), (Object)1), Pair.of((Object)new SingleJigsawPiece("repurposed_structures:shipwrecks/end/upsidedown_full_degraded", new ArrayList()), (Object)1)}), JigsawPattern.PlacementBehaviour.RIGID));
    }

    public static class Start
    extends StructureStart<NoFeatureConfig> {
        private static ResourceLocation SHIPWRECK_ResourceLocation = new ResourceLocation("repurposed_structures:shipwrecks/end");

        public Start(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        public void init(ChunkGenerator chunkGenerator, TemplateManager structureManager, int chunkX, int chunkZ, Biome biome, NoFeatureConfig NoFeatureConfig2) {
            BlockPos blockpos = new BlockPos(chunkX * 16, 62, chunkZ * 16);
            GeneralJigsawGenerator.addPieces(chunkGenerator, structureManager, blockpos, this.field_75075_a, this.field_214631_d, SHIPWRECK_ResourceLocation, 1);
            this.func_202500_a();
            BlockPos blockPos = new BlockPos(((StructurePiece)this.field_75075_a.get(0)).func_74874_b().func_215126_f());
            int highestLandPos = chunkGenerator.func_222529_a(blockPos.func_177958_n(), blockPos.func_177952_p(), Heightmap.Type.WORLD_SURFACE_WG);
            highestLandPos = Math.max(30, highestLandPos);
            this.func_214626_a((Random)this.field_214631_d, highestLandPos - 5, highestLandPos - 3);
        }
    }
}

