/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features.structures;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.world.features.structures.AbstractNetherStructure;
import com.telepathicgrunt.repurposedstructures.world.features.structures.GeneralJigsawGenerator;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.SingleJigsawPiece;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class OutpostWarpedStructure
extends Structure<NoFeatureConfig> {
    private static final List<Biome.SpawnListEntry> MONSTER_SPAWNS;

    public OutpostWarpedStructure(Codec<NoFeatureConfig> config) {
        super(config);
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    public List<Biome.SpawnListEntry> func_202279_e() {
        return MONSTER_SPAWNS;
    }

    static {
        JigsawManager.field_214891_a.func_214932_a(new JigsawPattern(new ResourceLocation("repurposed_structures", "outposts/warped/base_plates"), new ResourceLocation("empty"), (List)ImmutableList.of((Object)Pair.of((Object)new SingleJigsawPiece("repurposed_structures:outposts/warped/base_plate"), (Object)1)), JigsawPattern.PlacementBehaviour.RIGID));
        JigsawManager.field_214891_a.func_214932_a(new JigsawPattern(new ResourceLocation("repurposed_structures", "outposts/warped/towers"), new ResourceLocation("empty"), (List)ImmutableList.of((Object)Pair.of((Object)new SingleJigsawPiece("repurposed_structures:outposts/warped/tower"), (Object)1), (Object)Pair.of((Object)new SingleJigsawPiece("repurposed_structures:outposts/warped/tower_glowing"), (Object)1)), JigsawPattern.PlacementBehaviour.RIGID));
        JigsawManager.field_214891_a.func_214932_a(new JigsawPattern(new ResourceLocation("repurposed_structures", "outposts/warped/plates"), new ResourceLocation("empty"), (List)ImmutableList.of((Object)Pair.of((Object)new SingleJigsawPiece("repurposed_structures:outposts/warped/plate"), (Object)1)), JigsawPattern.PlacementBehaviour.RIGID));
        JigsawManager.field_214891_a.func_214932_a(new JigsawPattern(new ResourceLocation("repurposed_structures", "outposts/warped/features"), new ResourceLocation("empty"), (List)ImmutableList.of((Object)Pair.of((Object)new SingleJigsawPiece("repurposed_structures:outposts/warped/cage1"), (Object)1), (Object)Pair.of((Object)new SingleJigsawPiece("repurposed_structures:outposts/warped/cage2"), (Object)1), (Object)Pair.of((Object)new SingleJigsawPiece("repurposed_structures:outposts/warped/logs"), (Object)1), (Object)Pair.of((Object)new SingleJigsawPiece("repurposed_structures:outposts/warped/tent1"), (Object)1), (Object)Pair.of((Object)new SingleJigsawPiece("repurposed_structures:outposts/warped/tent2"), (Object)1), (Object)Pair.of((Object)new SingleJigsawPiece("repurposed_structures:outposts/warped/targets"), (Object)1)), JigsawPattern.PlacementBehaviour.RIGID));
        MONSTER_SPAWNS = Lists.newArrayList((Object[])new Biome.SpawnListEntry[]{new Biome.SpawnListEntry(EntityType.field_233591_ai_, 10, 1, 1)});
    }

    public static class Start
    extends AbstractNetherStructure.AbstractStart {
        ResourceLocation NETHER_OUTPOST_POOL = new ResourceLocation("repurposed_structures", "outposts/warped/base_plates");

        public Start(Structure<NoFeatureConfig> structureFeature, int x, int z, MutableBoundingBox blockBox, int referenceIn, long seed) {
            super(structureFeature, x, z, blockBox, referenceIn, seed);
        }

        public void init(ChunkGenerator chunkGenerator, TemplateManager structureManager, int x, int z, Biome biome, NoFeatureConfig NoFeatureConfig2) {
            BlockPos blockPos = new BlockPos(x * 16, 0, z * 16);
            GeneralJigsawGenerator.addPieces(chunkGenerator, structureManager, blockPos, this.field_75075_a, this.field_214631_d, this.NETHER_OUTPOST_POOL, 11);
            this.func_202500_a();
            BlockPos lowestLandPos = this.getHighestLand(chunkGenerator);
            if (lowestLandPos.func_177956_o() >= 108 || lowestLandPos.func_177956_o() <= 37) {
                this.func_214626_a((Random)this.field_214631_d, 19, 20);
            } else {
                this.func_214626_a((Random)this.field_214631_d, lowestLandPos.func_177956_o() - 15, lowestLandPos.func_177956_o() - 14);
            }
        }
    }
}

